/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class WScanBoxedScanners {
    public static JPanel container = new JPanel();
    public static Component component;
    private static HashMap<String, JCheckBox> scannerMap;

    public WScanBoxedScanners() {
        component = this.buildContainer();
        this.wireActions();
    }

    private Component buildContainer() {
        container.setBorder(BorderFactory.createTitledBorder("Scanners"));
        container.setLayout(new GridBagLayout());
        WScanBoxedScanners.setScannerList();
        return container;
    }

    private static void setScannerList() {
        Vector<BulkExtractorScanListReader.Scanner> vector;
        try {
            vector = BulkExtractorScanListReader.readScanList(WScanBoxedControls.usePluginDirectoriesCB.isSelected(), WScanBoxedControls.pluginDirectoriesTF.getText());
        }
        catch (IOException iOException) {
            WError.showError("Error in obtaining list of scanners from bulk_extractor.\nBulk_extractor is not available during this session.\nIs bulk_extractor installed?", "bulk_extractor failure", iOException);
            vector = new Vector();
        }
        int n = 0;
        for (BulkExtractorScanListReader.Scanner scanner : vector) {
            JCheckBox jCheckBox = new JCheckBox(scanner.name);
            WScan.addOptionLine(container, n++, jCheckBox);
            scannerMap.put(scanner.name, jCheckBox);
        }
    }

    public void setScanSettings(ScanSettings scanSettings) {
        for (BulkExtractorScanListReader.Scanner scanner : scanSettings.scanners) {
            JCheckBox jCheckBox = scannerMap.get(scanner.name);
            jCheckBox.setSelected(scanner.useScanner);
        }
    }

    public void getScanSettings(ScanSettings scanSettings) {
        for (BulkExtractorScanListReader.Scanner scanner : scanSettings.scanners) {
            JCheckBox jCheckBox = scannerMap.get(scanner.name);
            scanner.useScanner = jCheckBox.isSelected();
        }
    }

    private void wireActions() {
    }

    static {
        scannerMap = new HashMap();
    }
}

