###############################################################################
# Copyright (c) 2016-24, Lawrence Livermore National Security, LLC
# and CHAI project contributors. See the CHAI LICENSE file for details.
#
# SPDX-License-Identifier: (BSD-3-Clause)
###############################################################################

# Config related to compiler
set(CMAKE_C_COMPILER       "/opt/local/bin/mpicc-mpich-clang17"       CACHE PATH "")
set(CMAKE_CXX_COMPILER     "/opt/local/bin/mpicxx-mpich-clang17"     CACHE PATH "")
set(CMAKE_Fortran_COMPILER "/opt/local/bin/mpif90-mpich-clang17" CACHE PATH "")
set(CMAKE_CXX_STANDARD     "17"     CACHE STRING "")

set(CMAKE_C_FLAGS          " -Wall -Wextra  -pipe -Os -DNDEBUG -I/opt/local/include -isysroot/Library/Developer/CommandLineTools/SDKs/MacOSX14.sdk"          CACHE STRING "")
set(CMAKE_CXX_FLAGS        " -Wall -Wextra  -pipe -Os -DNDEBUG -I/opt/local/include -stdlib=libc++ -isysroot/Library/Developer/CommandLineTools/SDKs/MacOSX14.sdk   "        CACHE STRING "")
set(CMAKE_Fortran_FLAGS    "-pipe -Os -m64"    CACHE STRING "")
set(CMAKE_EXE_LINKER_FLAGS "-L/opt/local/lib -Wl,-headerpad_max_install_names -L/opt/local/lib/libomp -lomp -Wl,-rpath,/opt/local/lib/libgcc -Wl,-ld_classic -Wl,-syslibroot,/Library/Developer/CommandLineTools/SDKs/MacOSX14.sdk" CACHE STRING "")

set(CMAKE_EXPORT_COMPILE_COMMANDS TRUE CACHE BOOL "")

set(BLT_CMAKE_IMPLICIT_LINK_DIRECTORIES_EXCLUDE "" CACHE STRING "")

# MPI
set(ENABLE_MPI           ON             CACHE BOOL "")
set(MPI_C_COMPILER       "/opt/local/bin/mpicc-mpich-clang17"       CACHE PATH "")
set(MPI_CXX_COMPILER     "/opt/local/bin/mpicxx-mpich-clang17"     CACHE PATH "")
set(MPI_Fortran_COMPILER "/opt/local/bin/mpif90-mpich-clang17" CACHE PATH "")
set(MPIEXEC_EXECUTABLE   "MPIEXEC_EXECUTABLE-NOTFOUND"   CACHE PATH "")
set(MPIEXEC_NUMPROC_FLAG "-n" CACHE STRING "")

# CUDA
set(ENABLE_CUDA Off CACHE BOOL "")

if(ENABLE_CUDA)
  set(CUDA_TOOLKIT_ROOT_DIR    ""    CACHE PATH "")
  set(CMAKE_CUDA_COMPILER      ""      CACHE PATH "")
  set(CMAKE_CUDA_STANDARD      ""      CACHE STRING "")
  set(CMAKE_CUDA_HOST_COMPILER "" CACHE PATH "")
  set(CMAKE_CUDA_SEPARABLE_COMPILATION  CACHE BOOL "")
  set(CMAKE_CUDA_ARCHITECTURES "" CACHE STRING "")
  set(CMAKE_CUDA_FLAGS         " --expt-extended-lambda"         CACHE STRING "")
endif()

# HIP
set(ENABLE_HIP OFF CACHE BOOL "")

if(ENABLE_HIP)
  set(HIP_ROOT_DIR            ""            CACHE PATH "")
  set(HIP_CLANG_PATH          ""          CACHE PATH "")
  set(CMAKE_HIP_ARCHITECTURES "gfx900" CACHE STRING "")
  set(CMAKE_EXE_LINKER_FLAGS  "-L/opt/local/lib -Wl,-headerpad_max_install_names -L/opt/local/lib/libomp -lomp -Wl,-rpath,/opt/local/lib/libgcc -Wl,-ld_classic -Wl,-syslibroot,/Library/Developer/CommandLineTools/SDKs/MacOSX14.sdk"  CACHE STRING "")
endif()

set(CHAI_DIR "/opt/local" CACHE PATH "")
