(in-package :common-lisp-user)

(defpackage :cl-colors2
  (:use :alexandria
   :common-lisp)
  (:export
   :*epsilon*
   :rgb
   :rgb-red
   :rgb-green
   :rgb-blue
   :gray
   :hsv
   :hsv-hue
   :hsv-saturation
   :hsv-value
   :hsl
   :hsl-hue
   :hsl-saturation
   :hsl-lightness
   :rgb-to-hsv
   :hsv-to-rgb
   :hex-to-rgb
   :rgb/a-to-rgb                        ; deprecated
   :parse-rgb/a-to-rgb
   :parse-hsv-to-rgb
   :parse-hsl-to-rgb
   :as-hsv
   :as-hsv*
   :as-hsl
   :as-rgb
   :rgb-combination
   :hsv-combination
   :color-equals
   :parse-hex-rgb
   :define-rgb-color
   :print-hex-rgb
   :print-hex
   :print-css-rgb/a
   :print-css-hsl
   :print-css-hsv
   :*colors-list*
   :*x11-colors-list*
   :*svg-colors-list*
   :*svg-extended-colors-list*
   :*gdk-colors-list*
   ;; predefined color names
   ~A))

(defpackage :cl-colors2.svg
  (:use :common-lisp)
  (:import-from :cl-colors2 :define-rgb-color :*svg-colors-list*)
  (:export
   #:+black+
   #:+silver+
   #:+gray+
   #:+white+
   #:+maroon+
   #:+red+
   #:+purple+
   #:+fuchsia+
   #:+green+
   #:+lime+
   #:+olive+
   #:+yellow+
   #:+navy+
   #:+blue+
   #:+teal+
   #:+aqua+))


(defpackage :cl-colors2.svg-extended
  (:use :common-lisp)
  (:import-from :cl-colors2 :define-rgb-color :*svg-extended-colors-list*)
  (:export
   #:+aliceblue+
   #:+antiquewhite+
   #:+aqua+
   #:+aquamarine+
   #:+azure+
   #:+beige+
   #:+bisque+
   #:+black+
   #:+blanchedalmond+
   #:+blue+
   #:+blueviolet+
   #:+brown+
   #:+burlywood+
   #:+cadetblue+
   #:+chartreuse+
   #:+chocolate+
   #:+coral+
   #:+cornflowerblue+
   #:+cornsilk+
   #:+crimson+
   #:+cyan+
   #:+darkblue+
   #:+darkcyan+
   #:+darkgoldenrod+
   #:+darkgray+
   #:+darkgreen+
   #:+darkgrey+
   #:+darkkhaki+
   #:+darkmagenta+
   #:+darkolivegreen+
   #:+darkorange+
   #:+darkorchid+
   #:+darkred+
   #:+darksalmon+
   #:+darkseagreen+
   #:+darkslateblue+
   #:+darkslategray+
   #:+darkslategrey+
   #:+darkturquoise+
   #:+darkviolet+
   #:+deeppink+
   #:+deepskyblue+
   #:+dimgray+
   #:+dimgrey+
   #:+dodgerblue+
   #:+firebrick+
   #:+floralwhite+
   #:+forestgreen+
   #:+fuchsia+
   #:+gainsboro+
   #:+ghostwhite+
   #:+gold+
   #:+goldenrod+
   #:+gray+
   #:+green+
   #:+greenyellow+
   #:+grey+
   #:+honeydew+
   #:+hotpink+
   #:+indianred+
   #:+indigo+
   #:+ivory+
   #:+khaki+
   #:+lavender+
   #:+lavenderblush+
   #:+lawngreen+
   #:+lemonchiffon+
   #:+lightblue+
   #:+lightcoral+
   #:+lightcyan+
   #:+lightgoldenrodyellow+
   #:+lightgray+
   #:+lightgreen+
   #:+lightgrey+
   #:+lightpink+
   #:+lightsalmon+
   #:+lightseagreen+
   #:+lightskyblue+
   #:+lightslategray+
   #:+lightslategrey+
   #:+lightsteelblue+
   #:+lightyellow+
   #:+lime+
   #:+limegreen+
   #:+linen+
   #:+magenta+
   #:+maroon+
   #:+mediumaquamarine+
   #:+mediumblue+
   #:+mediumorchid+
   #:+mediumpurple+
   #:+mediumseagreen+
   #:+mediumslateblue+
   #:+mediumspringgreen+
   #:+mediumturquoise+
   #:+mediumvioletred+
   #:+midnightblue+
   #:+mintcream+
   #:+mistyrose+
   #:+moccasin+
   #:+navajowhite+
   #:+navy+
   #:+oldlace+
   #:+olive+
   #:+olivedrab+
   #:+orange+
   #:+orangered+
   #:+orchid+
   #:+palegoldenrod+
   #:+palegreen+
   #:+paleturquoise+
   #:+palevioletred+
   #:+papayawhip+
   #:+peachpuff+
   #:+peru+
   #:+pink+
   #:+plum+
   #:+powderblue+
   #:+purple+
   #:+red+
   #:+rosybrown+
   #:+royalblue+
   #:+saddlebrown+
   #:+salmon+
   #:+sandybrown+
   #:+seagreen+
   #:+seashell+
   #:+sienna+
   #:+silver+
   #:+skyblue+
   #:+slateblue+
   #:+slategray+
   #:+slategrey+
   #:+snow+
   #:+springgreen+
   #:+steelblue+
   #:+tan+
   #:+teal+
   #:+thistle+
   #:+tomato+
   #:+turquoise+
   #:+violet+
   #:+wheat+
   #:+white+
   #:+whitesmoke+
   #:+yellow+
   #:+yellowgreen+
   ))
