/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.ArrayList;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.Parser;

public class GnuParser
extends Parser {
    private ArrayList tokens = new ArrayList();

    private void init() {
        this.tokens.clear();
    }

    @Override
    protected String[] flatten(Options options, String[] arguments, boolean stopAtNonOption) {
        this.init();
        boolean eatTheRest = false;
        Option currentOption = null;
        for (int i = 0; i < arguments.length; ++i) {
            if ("--".equals(arguments[i])) {
                eatTheRest = true;
                this.tokens.add("--");
            } else if ("-".equals(arguments[i])) {
                this.tokens.add("-");
            } else if (arguments[i].startsWith("-")) {
                Option specialOption;
                Option option = options.getOption(arguments[i]);
                if (option == null) {
                    specialOption = options.getOption(arguments[i].substring(0, 2));
                    if (specialOption != null) {
                        this.tokens.add(arguments[i].substring(0, 2));
                        this.tokens.add(arguments[i].substring(2));
                    } else if (stopAtNonOption) {
                        eatTheRest = true;
                        this.tokens.add(arguments[i]);
                    } else {
                        this.tokens.add(arguments[i]);
                    }
                } else {
                    currentOption = option;
                    specialOption = options.getOption(arguments[i].substring(0, 2));
                    if (specialOption != null && option == null) {
                        this.tokens.add(arguments[i].substring(0, 2));
                        this.tokens.add(arguments[i].substring(2));
                    } else if (currentOption != null && currentOption.hasArg()) {
                        if (currentOption.hasArg()) {
                            this.tokens.add(arguments[i]);
                            currentOption = null;
                        } else if (currentOption.hasArgs()) {
                            this.tokens.add(arguments[i]);
                        } else if (stopAtNonOption) {
                            eatTheRest = true;
                            this.tokens.add("--");
                            this.tokens.add(arguments[i]);
                        } else {
                            this.tokens.add(arguments[i]);
                        }
                    } else if (currentOption != null) {
                        this.tokens.add(arguments[i]);
                    } else if (stopAtNonOption) {
                        eatTheRest = true;
                        this.tokens.add("--");
                        this.tokens.add(arguments[i]);
                    } else {
                        this.tokens.add(arguments[i]);
                    }
                }
            } else {
                this.tokens.add(arguments[i]);
            }
            if (!eatTheRest) continue;
            ++i;
            while (i < arguments.length) {
                this.tokens.add(arguments[i]);
                ++i;
            }
        }
        return this.tokens.toArray(new String[this.tokens.size()]);
    }
}

