/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.diff.html;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.compare.internal.LCSSettings;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.outerj.daisy.diff.html.TextNodeComparator;
import org.outerj.daisy.diff.html.modification.ModificationType;
import org.outerj.daisy.diff.output.DiffOutput;
import org.outerj.daisy.diff.output.Differ;
import org.xml.sax.SAXException;

public class HTMLDiffer
implements Differ {
    private DiffOutput output;

    public HTMLDiffer(DiffOutput diffOutput) {
        this.output = diffOutput;
    }

    public void diff(TextNodeComparator textNodeComparator, TextNodeComparator textNodeComparator2, TextNodeComparator textNodeComparator3) throws SAXException {
        LCSSettings lCSSettings = new LCSSettings();
        lCSSettings.setUseGreedyMethod(false);
        RangeDifference[] rangeDifferenceArray = RangeDifferencer.findDifferences(lCSSettings, textNodeComparator, (IRangeComparator)textNodeComparator2, (IRangeComparator)textNodeComparator3);
        List<RangeDifference> list = this.preProcess(rangeDifferenceArray);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (RangeDifference rangeDifference : list) {
            int n4 = rangeDifference.kind();
            if (n4 == 4) continue;
            if (rangeDifference.leftStart() > n2) {
                textNodeComparator.handlePossibleChangedPart(n2, rangeDifference.leftStart(), n, rangeDifference.ancestorStart(), textNodeComparator2);
            }
            if (rangeDifference.rightStart() > n3) {
                textNodeComparator.handlePossibleChangedPart(n3, rangeDifference.rightStart(), n, rangeDifference.ancestorStart(), textNodeComparator3);
            }
            if ((n4 == 1 || n4 == 3) && rangeDifference.leftLength() > 0) {
                textNodeComparator.markAsDeleted(rangeDifference.leftStart(), rangeDifference.leftEnd(), textNodeComparator2, rangeDifference.ancestorStart(), ModificationType.ADDED);
            }
            if ((n4 == 1 || n4 == 2) && rangeDifference.rightLength() > 0) {
                textNodeComparator.markAsDeleted(rangeDifference.rightStart(), rangeDifference.rightEnd(), textNodeComparator3, rangeDifference.ancestorStart(), ModificationType.ADDED);
            }
            textNodeComparator.markAsNew(rangeDifference.ancestorStart(), rangeDifference.ancestorEnd(), ModificationType.REMOVED);
            n = rangeDifference.ancestorEnd();
            n2 = rangeDifference.leftEnd();
            n3 = rangeDifference.rightEnd();
        }
        if (n2 < textNodeComparator2.getRangeCount()) {
            textNodeComparator.handlePossibleChangedPart(n2, textNodeComparator2.getRangeCount(), n, textNodeComparator.getRangeCount(), textNodeComparator2);
        }
        if (n3 < textNodeComparator3.getRangeCount()) {
            textNodeComparator.handlePossibleChangedPart(n3, textNodeComparator3.getRangeCount(), n, textNodeComparator.getRangeCount(), textNodeComparator3);
        }
        textNodeComparator.expandWhiteSpace();
        this.output.generateOutput(textNodeComparator.getBodyNode());
    }

    @Override
    public void diff(TextNodeComparator textNodeComparator, TextNodeComparator textNodeComparator2) throws SAXException {
        LCSSettings lCSSettings = new LCSSettings();
        lCSSettings.setUseGreedyMethod(false);
        RangeDifference[] rangeDifferenceArray = RangeDifferencer.findDifferences(lCSSettings, textNodeComparator, textNodeComparator2);
        List<RangeDifference> list = this.preProcess(rangeDifferenceArray);
        int n = 0;
        int n2 = 0;
        for (RangeDifference rangeDifference : list) {
            if (rangeDifference.leftStart() > n) {
                textNodeComparator2.handlePossibleChangedPart(n, rangeDifference.leftStart(), n2, rangeDifference.rightStart(), textNodeComparator);
            }
            if (rangeDifference.leftLength() > 0) {
                textNodeComparator2.markAsDeleted(rangeDifference.leftStart(), rangeDifference.leftEnd(), textNodeComparator, rangeDifference.rightStart());
            }
            textNodeComparator2.markAsNew(rangeDifference.rightStart(), rangeDifference.rightEnd());
            n = rangeDifference.leftEnd();
            n2 = rangeDifference.rightEnd();
        }
        if (n < textNodeComparator.getRangeCount()) {
            textNodeComparator2.handlePossibleChangedPart(n, textNodeComparator.getRangeCount(), n2, textNodeComparator2.getRangeCount(), textNodeComparator);
        }
        textNodeComparator2.expandWhiteSpace();
        this.output.generateOutput(textNodeComparator2.getBodyNode());
    }

    private List<RangeDifference> preProcess(RangeDifference[] rangeDifferenceArray) {
        LinkedList<RangeDifference> linkedList = new LinkedList<RangeDifference>();
        for (int i = 0; i < rangeDifferenceArray.length; ++i) {
            int n = rangeDifferenceArray[i].ancestorStart();
            int n2 = rangeDifferenceArray[i].ancestorEnd();
            int n3 = rangeDifferenceArray[i].leftStart();
            int n4 = rangeDifferenceArray[i].leftEnd();
            int n5 = rangeDifferenceArray[i].rightStart();
            int n6 = rangeDifferenceArray[i].rightEnd();
            int n7 = rangeDifferenceArray[i].kind();
            int n8 = n2 - n;
            int n9 = n4 - n3;
            int n10 = n6 - n5;
            while (i + 1 < rangeDifferenceArray.length && rangeDifferenceArray[i + 1].kind() == n7) {
                int[] nArray = new int[]{n9, rangeDifferenceArray[i + 1].leftLength(), n10, rangeDifferenceArray[i + 1].rightLength()};
                if (!(HTMLDiffer.score(nArray) > (double)(rangeDifferenceArray[i + 1].leftStart() - n4))) break;
                n4 = rangeDifferenceArray[i + 1].leftEnd();
                n6 = rangeDifferenceArray[i + 1].rightEnd();
                n2 = rangeDifferenceArray[i + 1].ancestorEnd();
                n9 = n4 - n3;
                n10 = n6 - n5;
                n8 = n2 - n;
                ++i;
            }
            linkedList.add(new RangeDifference(n7, n5, n10, n3, n9, n, n8));
        }
        return linkedList;
    }

    public static double score(int ... nArray) {
        if (nArray[0] == 0 && nArray[1] == 0 || nArray[2] == 0 && nArray[3] == 0) {
            return 0.0;
        }
        double d = 0.0;
        int[] nArray2 = nArray;
        int n = nArray2.length;
        for (int i = 0; i < n; ++i) {
            double d2;
            for (d2 = (double)nArray2[i]; d2 > 3.0; d2 *= 0.5) {
                d += 3.0;
                d2 -= 3.0;
            }
            d += d2;
        }
        return d / (1.5 * (double)nArray.length);
    }
}

