/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.diff.helper;

import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class MergeCharacterEventsHandler
implements ContentHandler {
    private ContentHandler consumer;
    private char[] ch;
    private int start = 0;
    private int length = 0;

    public MergeCharacterEventsHandler(ContentHandler contentHandler) {
        this.consumer = contentHandler;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        char[] cArray2 = new char[this.length + n2];
        if (this.ch != null) {
            System.arraycopy(this.ch, this.start, cArray2, 0, this.length);
        }
        System.arraycopy(cArray, n, cArray2, this.length, n2);
        this.start = 0;
        this.length = cArray2.length;
        this.ch = cArray2;
    }

    private void flushCharacters() throws SAXException {
        if (this.ch != null) {
            this.consumer.characters(this.ch, this.start, this.length);
            this.ch = null;
            this.start = 0;
            this.length = 0;
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.flushCharacters();
        this.consumer.endDocument();
    }

    @Override
    public void startDocument() throws SAXException {
        this.flushCharacters();
        this.consumer.startDocument();
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.flushCharacters();
        this.consumer.ignorableWhitespace(cArray, n, n2);
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
        this.flushCharacters();
        this.consumer.endPrefixMapping(string);
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
        this.flushCharacters();
        this.consumer.skippedEntity(string);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.consumer.setDocumentLocator(locator);
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        this.flushCharacters();
        this.consumer.processingInstruction(string, string2);
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.flushCharacters();
        this.consumer.startPrefixMapping(string, string2);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        this.flushCharacters();
        this.consumer.endElement(string, string2, string3);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.flushCharacters();
        this.consumer.startElement(string, string2, string3, attributes);
    }
}

