/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.collections.BaseIterator;
import com.sleepycat.collections.DataCursor;
import com.sleepycat.collections.DataView;
import com.sleepycat.collections.StoredCollection;
import com.sleepycat.collections.StoredContainer;
import com.sleepycat.collections.StoredIterator;
import com.sleepycat.collections.StoredMapEntry;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.OperationStatus;
import java.util.Map;
import java.util.Set;

public class StoredEntrySet
extends StoredCollection
implements Set {
    StoredEntrySet(DataView dataView) {
        super(dataView);
    }

    @Override
    public boolean add(Object object) {
        Map.Entry entry = (Map.Entry)object;
        return this.add(entry.getKey(), entry.getValue());
    }

    @Override
    public boolean remove(Object object) {
        if (!(object instanceof Map.Entry)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)object;
        DataCursor dataCursor = null;
        boolean bl = this.beginAutoCommit();
        try {
            dataCursor = new DataCursor(this.view, true);
            OperationStatus operationStatus = dataCursor.findBoth(entry.getKey(), entry.getValue(), true);
            if (operationStatus == OperationStatus.SUCCESS) {
                dataCursor.delete();
            }
            this.closeCursor(dataCursor);
            this.commitAutoCommit(bl);
            return operationStatus == OperationStatus.SUCCESS;
        }
        catch (Exception exception) {
            this.closeCursor(dataCursor);
            throw this.handleException(exception, bl);
        }
    }

    @Override
    public boolean contains(Object object) {
        boolean bl;
        if (!(object instanceof Map.Entry)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)object;
        DataCursor dataCursor = null;
        try {
            dataCursor = new DataCursor(this.view, false);
            OperationStatus operationStatus = dataCursor.findBoth(entry.getKey(), entry.getValue(), false);
            bl = operationStatus == OperationStatus.SUCCESS;
        }
        catch (Exception exception) {
            try {
                throw StoredContainer.convertException(exception);
            }
            catch (Throwable throwable) {
                this.closeCursor(dataCursor);
                throw throwable;
            }
        }
        this.closeCursor(dataCursor);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        StoredIterator storedIterator = this.storedIterator();
        try {
            Object object;
            while (storedIterator.hasNext()) {
                object = (Map.Entry)storedIterator.next();
                if (stringBuffer.length() > 1) {
                    stringBuffer.append(',');
                }
                Object k = object.getKey();
                Object v = object.getValue();
                if (k != null) {
                    stringBuffer.append(k.toString());
                }
                stringBuffer.append('=');
                if (v == null) continue;
                stringBuffer.append(v.toString());
            }
            stringBuffer.append(']');
            object = stringBuffer.toString();
            return object;
        }
        finally {
            storedIterator.close();
        }
    }

    @Override
    Object makeIteratorData(BaseIterator baseIterator, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3) {
        return new StoredMapEntry(this.view.makeKey(databaseEntry, databaseEntry2), this.view.makeValue(databaseEntry2, databaseEntry3), this, baseIterator);
    }

    @Override
    boolean hasValues() {
        return true;
    }
}

