/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.bind.EntryBinding;
import com.sleepycat.collections.DataCursor;
import com.sleepycat.collections.DataView;
import com.sleepycat.collections.PrimaryKeyAssigner;
import com.sleepycat.collections.StoredContainer;
import com.sleepycat.collections.StoredEntrySet;
import com.sleepycat.collections.StoredIterator;
import com.sleepycat.collections.StoredKeySet;
import com.sleepycat.collections.StoredSortedEntrySet;
import com.sleepycat.collections.StoredSortedKeySet;
import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.collections.StoredSortedValueSet;
import com.sleepycat.collections.StoredValueSet;
import com.sleepycat.db.Database;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.util.keyrange.KeyRangeException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoredMap<K, V>
extends StoredContainer
implements ConcurrentMap<K, V> {
    private StoredKeySet<K> keySet;
    private StoredEntrySet<K, V> entrySet;
    private StoredValueSet<V> valueSet;

    public StoredMap(Database database, EntryBinding<K> entryBinding, EntryBinding<V> entryBinding2, boolean bl) {
        super(new DataView(database, entryBinding, entryBinding2, null, bl, null));
        this.initView();
    }

    public StoredMap(Database database, EntryBinding<K> entryBinding, EntryBinding<V> entryBinding2, PrimaryKeyAssigner primaryKeyAssigner) {
        super(new DataView(database, entryBinding, entryBinding2, null, true, primaryKeyAssigner));
        this.initView();
    }

    public StoredMap(Database database, EntryBinding<K> entryBinding, EntityBinding<V> entityBinding, boolean bl) {
        super(new DataView(database, entryBinding, null, entityBinding, bl, null));
        this.initView();
    }

    public StoredMap(Database database, EntryBinding<K> entryBinding, EntityBinding<V> entityBinding, PrimaryKeyAssigner primaryKeyAssigner) {
        super(new DataView(database, entryBinding, null, entityBinding, true, primaryKeyAssigner));
        this.initView();
    }

    StoredMap(DataView dataView) {
        super(dataView);
        this.initView();
    }

    @Override
    void initAfterClone() {
        this.initView();
    }

    private void initView() {
        this.entrySet = this.areKeyRangesAllowed() ? new StoredSortedEntrySet(this.view) : new StoredEntrySet(this.view);
        DataView dataView = this.view.keySetView();
        this.keySet = this.areKeyRangesAllowed() ? new StoredSortedKeySet(dataView) : new StoredKeySet(dataView);
        dataView = this.view.valueSetView();
        this.valueSet = this.areKeyRangesAllowed() && dataView.canDeriveKeyFromValue() ? new StoredSortedValueSet<V>(dataView) : new StoredValueSet(dataView);
    }

    @Override
    public V get(Object object) {
        return (V)this.getValue(object);
    }

    @Override
    public V put(K k, V v) {
        return (V)this.putKeyValue(k, v);
    }

    public K append(V v) {
        boolean bl = this.beginAutoCommit();
        try {
            Object[] objectArray = new Object[1];
            this.view.append(v, objectArray, null);
            this.commitAutoCommit(bl);
            return (K)objectArray[0];
        }
        catch (Exception exception) {
            throw this.handleException(exception, bl);
        }
    }

    @Override
    public V remove(Object object) {
        Object[] objectArray = new Object[1];
        this.removeKey(object, objectArray);
        return (V)objectArray[0];
    }

    @Override
    public V putIfAbsent(K k, V v) {
        DataCursor dataCursor = null;
        boolean bl = this.beginAutoCommit();
        try {
            Object object;
            block3: {
                OperationStatus operationStatus;
                dataCursor = new DataCursor(this.view, true);
                do {
                    if ((operationStatus = dataCursor.putNoOverwrite(k, v, false)) != OperationStatus.SUCCESS) continue;
                    object = null;
                    break block3;
                } while ((operationStatus = dataCursor.getSearchKey(k, null, false)) != OperationStatus.SUCCESS);
                object = dataCursor.getCurrentValue();
            }
            this.closeCursor(dataCursor);
            this.commitAutoCommit(bl);
            return (V)object;
        }
        catch (Exception exception) {
            this.closeCursor(dataCursor);
            throw this.handleException(exception, bl);
        }
    }

    @Override
    public boolean remove(Object object, Object object2) {
        DataCursor dataCursor = null;
        boolean bl = this.beginAutoCommit();
        try {
            boolean bl2;
            dataCursor = new DataCursor(this.view, true, object);
            OperationStatus operationStatus = dataCursor.getFirst(true);
            if (operationStatus == OperationStatus.SUCCESS && dataCursor.getCurrentValue().equals(object2)) {
                dataCursor.delete();
                bl2 = true;
            } else {
                bl2 = false;
            }
            this.closeCursor(dataCursor);
            this.commitAutoCommit(bl);
            return bl2;
        }
        catch (Exception exception) {
            this.closeCursor(dataCursor);
            throw this.handleException(exception, bl);
        }
    }

    @Override
    public V replace(K k, V v) {
        DataCursor dataCursor = null;
        boolean bl = this.beginAutoCommit();
        try {
            Object object;
            dataCursor = new DataCursor(this.view, true, k);
            OperationStatus operationStatus = dataCursor.getFirst(true);
            if (operationStatus == OperationStatus.SUCCESS) {
                object = dataCursor.getCurrentValue();
                dataCursor.putCurrent(v);
            } else {
                object = null;
            }
            this.closeCursor(dataCursor);
            this.commitAutoCommit(bl);
            return (V)object;
        }
        catch (Exception exception) {
            this.closeCursor(dataCursor);
            throw this.handleException(exception, bl);
        }
    }

    @Override
    public boolean replace(K k, V v, V v2) {
        DataCursor dataCursor = null;
        boolean bl = this.beginAutoCommit();
        try {
            boolean bl2;
            dataCursor = new DataCursor(this.view, true, k);
            OperationStatus operationStatus = dataCursor.getFirst(true);
            if (operationStatus == OperationStatus.SUCCESS && dataCursor.getCurrentValue().equals(v)) {
                dataCursor.putCurrent(v2);
                bl2 = true;
            } else {
                bl2 = false;
            }
            this.closeCursor(dataCursor);
            this.commitAutoCommit(bl);
            return bl2;
        }
        catch (Exception exception) {
            this.closeCursor(dataCursor);
            throw this.handleException(exception, bl);
        }
    }

    @Override
    public boolean containsKey(Object object) {
        return super.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return super.containsValue(object);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        boolean bl = this.beginAutoCommit();
        Iterator iterator = null;
        try {
            Set<Map.Entry<? extends K, ? extends V>> set = map.entrySet();
            iterator = this.storedOrExternalIterator(set);
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                this.putKeyValue(entry.getKey(), entry.getValue());
            }
            StoredIterator.close(iterator);
            this.commitAutoCommit(bl);
        }
        catch (Exception exception) {
            StoredIterator.close(iterator);
            throw this.handleException(exception, bl);
        }
    }

    @Override
    public Set<K> keySet() {
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet;
    }

    @Override
    public Collection<V> values() {
        return this.valueSet;
    }

    public Collection<V> duplicates(K k) {
        try {
            DataView dataView = this.view.valueSetView(k);
            return new StoredValueSet(dataView);
        }
        catch (KeyRangeException keyRangeException) {
            return Collections.EMPTY_SET;
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    public <PK> Map<PK, V> duplicatesMap(K k, EntryBinding entryBinding) {
        try {
            DataView dataView = this.view.duplicatesView(k, entryBinding);
            if (this.isOrdered()) {
                return new StoredSortedMap(dataView);
            }
            return new StoredMap<K, V>(dataView);
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Map) {
            return this.entrySet().equals(((Map)object).entrySet());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public int size() {
        return this.values().size();
    }

    public String toString() {
        return this.entrySet().toString();
    }
}

