/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.bind.tuple.IntegerBinding;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseConfig;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.Environment;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.db.Transaction;
import com.sleepycat.persist.DatabaseNamer;
import com.sleepycat.persist.StoreExistsException;
import com.sleepycat.persist.StoreNotFoundException;
import com.sleepycat.persist.evolve.DeletedClassException;
import com.sleepycat.persist.evolve.IncompatibleClassException;
import com.sleepycat.persist.evolve.Mutations;
import com.sleepycat.persist.evolve.Renamer;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.CollectionProxy;
import com.sleepycat.persist.impl.ComplexFormat;
import com.sleepycat.persist.impl.CompositeKeyFormat;
import com.sleepycat.persist.impl.EnumFormat;
import com.sleepycat.persist.impl.Evolver;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.MapProxy;
import com.sleepycat.persist.impl.NonPersistentFormat;
import com.sleepycat.persist.impl.ObjectArrayFormat;
import com.sleepycat.persist.impl.PrimitiveArrayFormat;
import com.sleepycat.persist.impl.ProxiedFormat;
import com.sleepycat.persist.impl.ReadOnlyCatalog;
import com.sleepycat.persist.impl.SimpleCatalog;
import com.sleepycat.persist.impl.Store;
import com.sleepycat.persist.impl.StoredModel;
import com.sleepycat.persist.model.AnnotationModel;
import com.sleepycat.persist.model.ClassMetadata;
import com.sleepycat.persist.model.EntityMetadata;
import com.sleepycat.persist.model.EntityModel;
import com.sleepycat.persist.raw.RawObject;
import com.sleepycat.persist.raw.RawType;
import com.sleepycat.util.RuntimeExceptionWrapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistCatalog
implements Catalog {
    private static final byte[] DATA_KEY = PersistCatalog.getIntBytes(-1);
    private static final byte[] BETA_MUTATIONS_KEY = PersistCatalog.getIntBytes(-2);
    public static boolean expectNoClassChanges;
    public static boolean unevolvedFormatsEncountered;
    private volatile List<Format> formatList;
    private volatile Map<String, Format> formatMap;
    private volatile Map<String, Format> latestFormatMap;
    private Map<String, String> proxyClassMap;
    private boolean rawAccess;
    private EntityModel model;
    private Mutations mutations;
    private Database db;
    private int openCount;
    private Store store;
    private Evolver evolver;
    private Data catalogData;

    private static byte[] getIntBytes(int n) {
        DatabaseEntry databaseEntry = new DatabaseEntry();
        IntegerBinding.intToEntry(n, databaseEntry);
        assert (databaseEntry.getSize() == 4 && databaseEntry.getData().length == 4);
        return databaseEntry.getData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistCatalog(Transaction transaction, Environment environment, String string, String string2, DatabaseConfig databaseConfig, EntityModel entityModel, Mutations mutations, boolean bl, Store store) throws StoreExistsException, StoreNotFoundException, IncompatibleClassException, DatabaseException {
        this.rawAccess = bl;
        this.store = store;
        String[] stringArray = store != null ? store.parseDbName(string2) : Store.parseDbName(string2, DatabaseNamer.DEFAULT);
        this.db = DbCompat.openDatabase(environment, transaction, stringArray[0], stringArray[1], databaseConfig);
        if (this.db == null) {
            String string3 = store.getDbNameMessage(stringArray);
            if (databaseConfig.getExclusiveCreate()) {
                throw new StoreExistsException("Catalog DB already exists and ExclusiveCreate=true, " + string3);
            }
            assert (!databaseConfig.getAllowCreate());
            throw new StoreNotFoundException("Catalog DB does not exist and AllowCreate=false, " + string3);
        }
        this.openCount = 1;
        boolean bl2 = false;
        try {
            boolean bl3;
            Iterator<Format> iterator;
            boolean bl4;
            this.catalogData = this.readData(transaction);
            this.mutations = this.catalogData.mutations;
            if (this.mutations == null) {
                this.mutations = new Mutations();
            }
            boolean bl5 = bl4 = this.catalogData.version == -1;
            boolean bl6 = bl4;
            boolean bl7 = false;
            if (mutations != null && !this.mutations.equals(mutations)) {
                this.mutations = mutations;
                bl5 = true;
                bl7 = true;
            }
            this.formatList = this.catalogData.formatList;
            if (this.formatList == null) {
                this.formatList = SimpleCatalog.copyFormatList();
                iterator = new NonPersistentFormat(Object.class);
                ((Format)((Object)iterator)).setId(1);
                this.formatList.set(1, (Format)((Object)iterator));
                iterator = new NonPersistentFormat(Number.class);
                ((Format)((Object)iterator)).setId(22);
                this.formatList.set(22, (Format)((Object)iterator));
            } else if (SimpleCatalog.copyMissingFormats(this.formatList)) {
                bl5 = true;
            }
            if (bl4) {
                iterator = new HashMap();
                for (Format format : this.formatList) {
                    if (format == null) continue;
                    iterator.put(format.getClassName(), format);
                }
                for (Format format : this.formatList) {
                    if (format == null) continue;
                    format.migrateFromBeta((Map<String, Format>)((Object)iterator));
                }
            }
            this.formatMap = new HashMap<String, Format>(this.formatList.size());
            this.latestFormatMap = new HashMap<String, Format>(this.formatList.size());
            if (bl) {
                for (Format format : this.formatList) {
                    if (format == null) continue;
                    String string3 = format.getClassName();
                    if (format.isCurrentVersion()) {
                        this.formatMap.put(string3, format);
                    }
                    if (format != format.getLatestVersion()) continue;
                    this.latestFormatMap.put(string3, format);
                }
                this.model = new StoredModel(this);
                for (Format format : this.formatList) {
                    if (format == null) continue;
                    format.initializeIfNeeded(this, this.model);
                }
                bl2 = true;
                return;
            }
            this.model = entityModel != null ? entityModel : new AnnotationModel();
            for (int i = 0; i <= 30; ++i) {
                Format format = this.formatList.get(i);
                if (format == null) continue;
                this.formatMap.put(format.getClassName(), format);
            }
            ArrayList<String> arrayList = new ArrayList<String>(this.model.getKnownClasses());
            this.addPredefinedProxies(arrayList);
            this.proxyClassMap = new HashMap<String, String>();
            for (Format format : this.formatList) {
                if (format == null || Format.isPredefined(format)) continue;
                String string4 = format.getClassName();
                Renamer renamer = this.mutations.getRenamer(string4, format.getVersion(), null);
                String string5 = renamer != null ? renamer.getNewName() : string4;
                this.addProxiedClass(string5);
            }
            for (String string6 : arrayList) {
                this.addProxiedClass(string6);
            }
            HashMap<String, Format> hashMap = new HashMap<String, Format>();
            for (String string7 : arrayList) {
                this.createFormat(string7, hashMap);
            }
            this.evolver = new Evolver(this, string, this.mutations, hashMap, bl7, bl6);
            for (Format format : this.formatList) {
                if (format == null || Format.isPredefined(format)) continue;
                if (format.isEntity()) {
                    this.evolver.evolveFormat(format);
                    continue;
                }
                this.evolver.addNonEntityFormat(format);
            }
            this.evolver.finishEvolution();
            String string8 = this.evolver.getErrors();
            if (string8 != null) {
                throw new IncompatibleClassException(string8);
            }
            for (Format format : hashMap.values()) {
                this.addFormat(format);
            }
            for (Format format : this.formatList) {
                if (format == null) continue;
                format.initializeIfNeeded(this, this.model);
                if (format != format.getLatestVersion()) continue;
                this.latestFormatMap.put(format.getClassName(), format);
            }
            boolean bl8 = bl3 = hashMap.size() > 0 || this.evolver.areFormatsChanged();
            if (expectNoClassChanges && bl3) {
                throw new IllegalStateException("Unexpected changes  newFormats.size=" + hashMap.size() + " areFormatsChanged=" + this.evolver.areFormatsChanged());
            }
            if ((bl3 || bl5) && !this.db.getConfig().getReadOnly()) {
                this.evolver.renameAndRemoveDatabases(store, transaction);
                this.catalogData.formatList = this.formatList;
                this.catalogData.mutations = this.mutations;
                this.writeData(transaction, this.catalogData);
            } else if (bl5) {
                throw new IllegalArgumentException("When an upgrade is required the store may not be opened read-only");
            }
            bl2 = true;
        }
        finally {
            this.proxyClassMap = null;
            this.catalogData = null;
            this.evolver = null;
            if (!bl2) {
                this.close();
            }
        }
    }

    public void getEntityFormats(Collection<Format> collection) {
        for (Format format : this.formatMap.values()) {
            if (!format.isEntity()) continue;
            collection.add(format);
        }
    }

    private void addProxiedClass(String string) {
        String string2;
        ClassMetadata classMetadata = this.model.getClassMetadata(string);
        if (classMetadata != null && (string2 = classMetadata.getProxiedClassName()) != null) {
            this.proxyClassMap.put(string2, string);
        }
    }

    private void addPredefinedProxies(List<String> list) {
        list.add(CollectionProxy.ArrayListProxy.class.getName());
        list.add(CollectionProxy.LinkedListProxy.class.getName());
        list.add(CollectionProxy.HashSetProxy.class.getName());
        list.add(CollectionProxy.TreeSetProxy.class.getName());
        list.add(MapProxy.HashMapProxy.class.getName());
        list.add(MapProxy.TreeMapProxy.class.getName());
    }

    Map<Format, Set<Format>> getSubclassMap() {
        HashMap<Format, Set<Format>> hashMap = new HashMap<Format, Set<Format>>();
        for (Format format : this.formatList) {
            Format format2;
            if (format == null || Format.isPredefined(format) || (format2 = format.getSuperFormat()) == null) continue;
            HashSet<Format> hashSet = (HashSet<Format>)hashMap.get(format2);
            if (hashSet == null) {
                hashSet = new HashSet<Format>();
                hashMap.put(format2, hashSet);
            }
            hashSet.add(format);
        }
        return hashMap;
    }

    public EntityModel getResolvedModel() {
        return this.model;
    }

    public void openExisting() {
        ++this.openCount;
    }

    public boolean close() throws DatabaseException {
        if (this.openCount == 0) {
            throw new IllegalStateException("Catalog is not open");
        }
        --this.openCount;
        if (this.openCount == 0) {
            Database database = this.db;
            this.db = null;
            database.close();
            return true;
        }
        return false;
    }

    public Mutations getMutations() {
        return this.mutations;
    }

    @Override
    public Format createFormat(String string, Map<String, Format> map) {
        Class clazz;
        try {
            clazz = SimpleCatalog.classForName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException("Class does not exist: " + string);
        }
        return this.createFormat(clazz, map);
    }

    @Override
    public Format createFormat(Class clazz, Map<String, Format> map) {
        String string = clazz.getName();
        Format format = map.get(string);
        if (format != null) {
            return format;
        }
        format = this.formatMap.get(string);
        if (format != null) {
            return format;
        }
        assert (!SimpleCatalog.isSimpleType(clazz)) : string;
        ClassMetadata classMetadata = this.model.getClassMetadata(string);
        String string2 = null;
        if (this.proxyClassMap != null) {
            string2 = this.proxyClassMap.get(string);
        }
        if (string2 != null) {
            format = new ProxiedFormat(clazz, string2);
        } else if (clazz.isArray()) {
            format = clazz.getComponentType().isPrimitive() ? new PrimitiveArrayFormat(clazz) : new ObjectArrayFormat(clazz);
        } else if (clazz.isEnum()) {
            format = new EnumFormat(clazz);
        } else if (clazz == Object.class || clazz.isInterface()) {
            format = new NonPersistentFormat(clazz);
        } else {
            if (classMetadata == null) {
                throw new IllegalArgumentException("Class could not be loaded or is not persistent: " + string);
            }
            if (classMetadata.getCompositeKeyFields() != null && (classMetadata.getPrimaryKey() != null || classMetadata.getSecondaryKeys() != null)) {
                throw new IllegalArgumentException("A composite key class may not have primary or secondary key fields: " + clazz.getName());
            }
            if (clazz.getEnclosingClass() != null && !Modifier.isStatic(clazz.getModifiers())) {
                throw new IllegalArgumentException("Inner classes not allowed: " + clazz.getName());
            }
            try {
                clazz.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalArgumentException("No default constructor: " + clazz.getName(), noSuchMethodException);
            }
            if (classMetadata.getCompositeKeyFields() != null) {
                format = new CompositeKeyFormat(clazz, classMetadata, classMetadata.getCompositeKeyFields());
            } else {
                EntityMetadata entityMetadata = this.model.getEntityMetadata(string);
                format = new ComplexFormat(clazz, classMetadata, entityMetadata);
            }
        }
        map.put(string, format);
        format.collectRelatedFormats(this, map);
        return format;
    }

    private void addFormat(Format format) {
        this.addFormat(format, this.formatList, this.formatMap);
    }

    private void addFormat(Format format, List<Format> list, Map<String, Format> map) {
        format.setId(list.size());
        list.add(format);
        map.put(format.getClassName(), format);
    }

    void useExistingFormat(Format format) {
        assert (format.isCurrentVersion());
        this.formatMap.put(format.getClassName(), format);
    }

    Set<String> getModelClasses() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Format format : this.formatMap.values()) {
            if (!format.isModelClass()) continue;
            hashSet.add(format.getClassName());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public List<RawType> getAllRawTypes() {
        ArrayList<RawType> arrayList = new ArrayList<RawType>();
        for (RawType rawType : this.formatList) {
            if (rawType == null) continue;
            arrayList.add(rawType);
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public int getInitVersion(Format format, boolean bl) {
        if (this.catalogData == null || this.catalogData.formatList == null || format.getId() >= this.catalogData.formatList.size()) {
            return 1;
        }
        assert (this.catalogData != null);
        if (bl) {
            return this.evolver != null && this.evolver.isFormatChanged(format) ? 1 : this.catalogData.version;
        }
        return this.catalogData.version;
    }

    @Override
    public Format getFormat(int n) {
        try {
            Format format = this.formatList.get(n);
            if (format == null) {
                throw new DeletedClassException("Format does not exist: " + n);
            }
            return format;
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new DeletedClassException("Format does not exist: " + n);
        }
    }

    @Override
    public Format getFormat(Class clazz, boolean bl) {
        Format format = this.formatMap.get(clazz.getName());
        if (format == null) {
            if (this.model != null) {
                ComplexFormat complexFormat;
                format = this.addNewFormat(clazz);
                if (bl && this.store != null && (complexFormat = format.getEntityFormat()) != null && complexFormat != format) {
                    try {
                        this.store.checkEntitySubclassSecondaries(((Format)complexFormat).getEntityMetadata(), clazz.getName());
                    }
                    catch (DatabaseException databaseException) {
                        throw new RuntimeExceptionWrapper(databaseException);
                    }
                }
            }
            if (format == null) {
                throw new IllegalArgumentException("Class is not persistent: " + clazz.getName());
            }
        }
        return format;
    }

    @Override
    public Format getFormat(String string) {
        return this.formatMap.get(string);
    }

    public Format getLatestVersion(String string) {
        return this.latestFormatMap.get(string);
    }

    private synchronized Format addNewFormat(Class clazz) {
        Format format = this.formatMap.get(clazz.getName());
        if (format != null) {
            return format;
        }
        ArrayList<Format> arrayList = new ArrayList<Format>(this.formatList);
        HashMap<String, Format> hashMap = new HashMap<String, Format>(this.formatMap);
        HashMap<String, Format> hashMap2 = new HashMap<String, Format>(this.latestFormatMap);
        HashMap<String, Format> hashMap3 = new HashMap<String, Format>();
        format = this.createFormat(clazz, hashMap3);
        for (Object object : hashMap3.values()) {
            this.addFormat((Format)object, arrayList, hashMap);
        }
        ReadOnlyCatalog readOnlyCatalog = new ReadOnlyCatalog(arrayList, hashMap);
        for (Format format2 : hashMap3.values()) {
            format2.initializeIfNeeded(readOnlyCatalog, this.model);
            hashMap2.put(format2.getClassName(), format2);
        }
        try {
            Object object;
            object = new Data();
            ((Data)object).formatList = arrayList;
            ((Data)object).mutations = this.mutations;
            this.writeData(null, (Data)object);
        }
        catch (DatabaseException databaseException) {
            throw new RuntimeExceptionWrapper(databaseException);
        }
        this.formatList = arrayList;
        this.formatMap = hashMap;
        this.latestFormatMap = hashMap2;
        return format;
    }

    public synchronized void flush() throws DatabaseException {
        Data data = new Data();
        data.formatList = this.formatList;
        data.mutations = this.mutations;
        this.writeData(null, data);
    }

    private Data readData(Transaction transaction) throws DatabaseException {
        DatabaseEntry databaseEntry = new DatabaseEntry(DATA_KEY);
        DatabaseEntry databaseEntry2 = new DatabaseEntry();
        OperationStatus operationStatus = this.db.get(transaction, databaseEntry, databaseEntry2, null);
        if (operationStatus == OperationStatus.SUCCESS) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(databaseEntry2.getData(), databaseEntry2.getOffset(), databaseEntry2.getSize());
            try {
                Data data;
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                Object object = objectInputStream.readObject();
                assert (objectInputStream.available() == 0);
                if (object instanceof Data) {
                    data = (Data)object;
                } else {
                    if (!(object instanceof List)) {
                        throw new IllegalStateException(object.getClass().getName());
                    }
                    data = new Data();
                    data.formatList = (List)object;
                    data.version = -1;
                }
                return data;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalStateException(classNotFoundException);
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }
        Data data = new Data();
        data.version = 1;
        return data;
    }

    private void writeData(Transaction transaction, Data data) throws DatabaseException {
        Object object;
        boolean bl = data.version == -1;
        data.version = 1;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            object = new ObjectOutputStream(byteArrayOutputStream);
            ((ObjectOutputStream)object).writeObject(data);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        object = new DatabaseEntry(DATA_KEY);
        DatabaseEntry databaseEntry = new DatabaseEntry(byteArrayOutputStream.toByteArray());
        this.db.put(transaction, (DatabaseEntry)object, databaseEntry);
        if (bl) {
            ((DatabaseEntry)object).setData(BETA_MUTATIONS_KEY);
            this.db.delete(transaction, (DatabaseEntry)object);
        }
    }

    @Override
    public boolean isRawAccess() {
        return this.rawAccess;
    }

    @Override
    public Object convertRawObject(RawObject rawObject, IdentityHashMap identityHashMap) {
        Object object;
        Object object2 = (Format)rawObject.getType();
        if (this != ((Format)object2).getCatalog()) {
            object = ((Format)object2).getClassName();
            try {
                Class clazz = SimpleCatalog.classForName((String)object);
                object2 = this.getFormat(clazz, true);
            }
            catch (ClassNotFoundException classNotFoundException) {
                object2 = null;
            }
            if (object2 == null) {
                throw new IllegalArgumentException("External raw type not found: " + (String)object);
            }
        }
        if ((object = ((Format)object2).getProxiedFormat()) != null) {
            object2 = object;
        }
        if (identityHashMap == null) {
            identityHashMap = new IdentityHashMap();
        }
        return ((Format)object2).convertRawObject(this, false, rawObject, identityHashMap);
    }

    private static class Data
    implements Serializable {
        static final long serialVersionUID = 7515058069137413261L;
        List<Format> formatList;
        Mutations mutations;
        int version;

        private Data() {
        }
    }
}

