/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.PersistCatalog;
import com.sleepycat.persist.model.ClassMetadata;
import com.sleepycat.persist.model.EntityMetadata;
import com.sleepycat.persist.model.EntityModel;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StoredModel
extends EntityModel {
    private PersistCatalog catalog;
    private Set<String> knownClasses;

    StoredModel(PersistCatalog persistCatalog) {
        this.catalog = persistCatalog;
    }

    @Override
    public ClassMetadata getClassMetadata(String string) {
        ClassMetadata classMetadata = null;
        Format format = this.catalog.getFormat(string);
        if (format != null && format.isCurrentVersion()) {
            classMetadata = format.getClassMetadata();
        }
        return classMetadata;
    }

    @Override
    public EntityMetadata getEntityMetadata(String string) {
        EntityMetadata entityMetadata = null;
        Format format = this.catalog.getFormat(string);
        if (format != null && format.isCurrentVersion()) {
            entityMetadata = format.getEntityMetadata();
        }
        return entityMetadata;
    }

    @Override
    public Set<String> getKnownClasses() {
        if (this.knownClasses == null) {
            this.knownClasses = this.catalog.getModelClasses();
        }
        return this.knownClasses;
    }
}

