/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.asm;

import com.sleepycat.asm.AnnotationVisitor;
import com.sleepycat.asm.AnnotationWriter;
import com.sleepycat.asm.Attribute;
import com.sleepycat.asm.ByteVector;
import com.sleepycat.asm.ClassReader;
import com.sleepycat.asm.ClassVisitor;
import com.sleepycat.asm.FieldVisitor;
import com.sleepycat.asm.FieldWriter;
import com.sleepycat.asm.Item;
import com.sleepycat.asm.MethodVisitor;
import com.sleepycat.asm.MethodWriter;
import com.sleepycat.asm.Type;

public class ClassWriter
implements ClassVisitor {
    static final int NOARG_INSN = 0;
    static final int SBYTE_INSN = 1;
    static final int SHORT_INSN = 2;
    static final int VAR_INSN = 3;
    static final int IMPLVAR_INSN = 4;
    static final int TYPE_INSN = 5;
    static final int FIELDORMETH_INSN = 6;
    static final int ITFMETH_INSN = 7;
    static final int LABEL_INSN = 8;
    static final int LABELW_INSN = 9;
    static final int LDC_INSN = 10;
    static final int LDCW_INSN = 11;
    static final int IINC_INSN = 12;
    static final int TABL_INSN = 13;
    static final int LOOK_INSN = 14;
    static final int MANA_INSN = 15;
    static final int WIDE_INSN = 16;
    static byte[] TYPE;
    static final int CLASS = 7;
    static final int FIELD = 9;
    static final int METH = 10;
    static final int IMETH = 11;
    static final int STR = 8;
    static final int INT = 3;
    static final int FLOAT = 4;
    static final int LONG = 5;
    static final int DOUBLE = 6;
    static final int NAME_TYPE = 12;
    static final int UTF8 = 1;
    ClassReader cr;
    int version;
    int index = 1;
    ByteVector pool = new ByteVector();
    Item[] items = new Item[256];
    int threshold = (int)(0.75 * (double)this.items.length);
    Item key = new Item();
    Item key2 = new Item();
    Item key3 = new Item();
    private int access;
    private int name;
    private int signature;
    private int superName;
    private int interfaceCount;
    private int[] interfaces;
    private int sourceFile;
    private ByteVector sourceDebug;
    private int enclosingMethodOwner;
    private int enclosingMethod;
    private AnnotationWriter anns;
    private AnnotationWriter ianns;
    private Attribute attrs;
    private int innerClassesCount;
    private ByteVector innerClasses;
    FieldWriter firstField;
    FieldWriter lastField;
    MethodWriter firstMethod;
    MethodWriter lastMethod;
    private boolean computeMaxs;

    public ClassWriter(boolean bl) {
        this(bl, false);
    }

    public ClassWriter(boolean bl, boolean bl2) {
        this.computeMaxs = bl;
    }

    public ClassWriter(ClassReader classReader, boolean bl) {
        this(bl, false);
        classReader.copyPool(this);
        this.cr = classReader;
    }

    @Override
    public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        this.version = n;
        this.access = n2;
        this.name = this.newClass(string);
        if (string2 != null) {
            this.signature = this.newUTF8(string2);
        }
        int n3 = this.superName = string3 == null ? 0 : this.newClass(string3);
        if (stringArray != null && stringArray.length > 0) {
            this.interfaceCount = stringArray.length;
            this.interfaces = new int[this.interfaceCount];
            for (int i = 0; i < this.interfaceCount; ++i) {
                this.interfaces[i] = this.newClass(stringArray[i]);
            }
        }
    }

    @Override
    public void visitSource(String string, String string2) {
        if (string != null) {
            this.sourceFile = this.newUTF8(string);
        }
        if (string2 != null) {
            this.sourceDebug = new ByteVector().putUTF8(string2);
        }
    }

    @Override
    public void visitOuterClass(String string, String string2, String string3) {
        this.enclosingMethodOwner = this.newClass(string);
        if (string2 != null && string3 != null) {
            this.enclosingMethod = this.newNameType(string2, string3);
        }
    }

    @Override
    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        ByteVector byteVector = new ByteVector();
        byteVector.putShort(this.newUTF8(string)).putShort(0);
        AnnotationWriter annotationWriter = new AnnotationWriter(this, true, byteVector, byteVector, 2);
        if (bl) {
            annotationWriter.next = this.anns;
            this.anns = annotationWriter;
        } else {
            annotationWriter.next = this.ianns;
            this.ianns = annotationWriter;
        }
        return annotationWriter;
    }

    @Override
    public void visitAttribute(Attribute attribute) {
        attribute.next = this.attrs;
        this.attrs = attribute;
    }

    @Override
    public void visitInnerClass(String string, String string2, String string3, int n) {
        if (this.innerClasses == null) {
            this.innerClasses = new ByteVector();
        }
        ++this.innerClassesCount;
        this.innerClasses.putShort(string == null ? 0 : this.newClass(string));
        this.innerClasses.putShort(string2 == null ? 0 : this.newClass(string2));
        this.innerClasses.putShort(string3 == null ? 0 : this.newUTF8(string3));
        this.innerClasses.putShort(n);
    }

    @Override
    public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
        return new FieldWriter(this, n, string, string2, string3, object);
    }

    @Override
    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        return new MethodWriter(this, n, string, string2, string3, stringArray, this.computeMaxs);
    }

    @Override
    public void visitEnd() {
    }

    public byte[] toByteArray() {
        int n;
        int n2 = 24 + 2 * this.interfaceCount;
        int n3 = 0;
        FieldWriter fieldWriter = this.firstField;
        while (fieldWriter != null) {
            ++n3;
            n2 += fieldWriter.getSize();
            fieldWriter = fieldWriter.next;
        }
        int n4 = 0;
        MethodWriter methodWriter = this.firstMethod;
        while (methodWriter != null) {
            ++n4;
            n2 += methodWriter.getSize();
            methodWriter = methodWriter.next;
        }
        int n5 = 0;
        if (this.signature != 0) {
            ++n5;
            n2 += 8;
            this.newUTF8("Signature");
        }
        if (this.sourceFile != 0) {
            ++n5;
            n2 += 8;
            this.newUTF8("SourceFile");
        }
        if (this.sourceDebug != null) {
            ++n5;
            n2 += this.sourceDebug.length + 4;
            this.newUTF8("SourceDebugExtension");
        }
        if (this.enclosingMethodOwner != 0) {
            ++n5;
            n2 += 10;
            this.newUTF8("EnclosingMethod");
        }
        if ((this.access & 0x20000) != 0) {
            ++n5;
            n2 += 6;
            this.newUTF8("Deprecated");
        }
        if ((this.access & 0x1000) != 0 && (this.version & 0xFFFF) < 49) {
            ++n5;
            n2 += 6;
            this.newUTF8("Synthetic");
        }
        if (this.version == 48) {
            if ((this.access & 0x2000) != 0) {
                ++n5;
                n2 += 6;
                this.newUTF8("Annotation");
            }
            if ((this.access & 0x4000) != 0) {
                ++n5;
                n2 += 6;
                this.newUTF8("Enum");
            }
        }
        if (this.innerClasses != null) {
            ++n5;
            n2 += 8 + this.innerClasses.length;
            this.newUTF8("InnerClasses");
        }
        if (this.anns != null) {
            ++n5;
            n2 += 8 + this.anns.getSize();
            this.newUTF8("RuntimeVisibleAnnotations");
        }
        if (this.ianns != null) {
            ++n5;
            n2 += 8 + this.ianns.getSize();
            this.newUTF8("RuntimeInvisibleAnnotations");
        }
        if (this.attrs != null) {
            n5 += this.attrs.getCount();
            n2 += this.attrs.getSize(this, null, 0, -1, -1);
        }
        ByteVector byteVector = new ByteVector(n2 += this.pool.length);
        byteVector.putInt(-889275714).putInt(this.version);
        byteVector.putShort(this.index).putByteArray(this.pool.data, 0, this.pool.length);
        byteVector.putShort(this.access).putShort(this.name).putShort(this.superName);
        byteVector.putShort(this.interfaceCount);
        for (n = 0; n < this.interfaceCount; ++n) {
            byteVector.putShort(this.interfaces[n]);
        }
        byteVector.putShort(n3);
        fieldWriter = this.firstField;
        while (fieldWriter != null) {
            fieldWriter.put(byteVector);
            fieldWriter = fieldWriter.next;
        }
        byteVector.putShort(n4);
        methodWriter = this.firstMethod;
        while (methodWriter != null) {
            methodWriter.put(byteVector);
            methodWriter = methodWriter.next;
        }
        byteVector.putShort(n5);
        if (this.signature != 0) {
            byteVector.putShort(this.newUTF8("Signature")).putInt(2).putShort(this.signature);
        }
        if (this.sourceFile != 0) {
            byteVector.putShort(this.newUTF8("SourceFile")).putInt(2).putShort(this.sourceFile);
        }
        if (this.sourceDebug != null) {
            n = this.sourceDebug.length - 2;
            byteVector.putShort(this.newUTF8("SourceDebugExtension")).putInt(n);
            byteVector.putByteArray(this.sourceDebug.data, 2, n);
        }
        if (this.enclosingMethodOwner != 0) {
            byteVector.putShort(this.newUTF8("EnclosingMethod")).putInt(4);
            byteVector.putShort(this.enclosingMethodOwner).putShort(this.enclosingMethod);
        }
        if ((this.access & 0x20000) != 0) {
            byteVector.putShort(this.newUTF8("Deprecated")).putInt(0);
        }
        if ((this.access & 0x1000) != 0 && (this.version & 0xFFFF) < 49) {
            byteVector.putShort(this.newUTF8("Synthetic")).putInt(0);
        }
        if (this.version == 48) {
            if ((this.access & 0x2000) != 0) {
                byteVector.putShort(this.newUTF8("Annotation")).putInt(0);
            }
            if ((this.access & 0x4000) != 0) {
                byteVector.putShort(this.newUTF8("Enum")).putInt(0);
            }
        }
        if (this.innerClasses != null) {
            byteVector.putShort(this.newUTF8("InnerClasses"));
            byteVector.putInt(this.innerClasses.length + 2).putShort(this.innerClassesCount);
            byteVector.putByteArray(this.innerClasses.data, 0, this.innerClasses.length);
        }
        if (this.anns != null) {
            byteVector.putShort(this.newUTF8("RuntimeVisibleAnnotations"));
            this.anns.put(byteVector);
        }
        if (this.ianns != null) {
            byteVector.putShort(this.newUTF8("RuntimeInvisibleAnnotations"));
            this.ianns.put(byteVector);
        }
        if (this.attrs != null) {
            this.attrs.put(this, null, 0, -1, -1, byteVector);
        }
        return byteVector.data;
    }

    Item newConstItem(Object object) {
        if (object instanceof Integer) {
            int n = (Integer)object;
            return this.newInteger(n);
        }
        if (object instanceof Byte) {
            int n = ((Byte)object).intValue();
            return this.newInteger(n);
        }
        if (object instanceof Character) {
            char c = ((Character)object).charValue();
            return this.newInteger(c);
        }
        if (object instanceof Short) {
            int n = ((Short)object).intValue();
            return this.newInteger(n);
        }
        if (object instanceof Boolean) {
            int n = (Boolean)object != false ? 1 : 0;
            return this.newInteger(n);
        }
        if (object instanceof Float) {
            float f = ((Float)object).floatValue();
            return this.newFloat(f);
        }
        if (object instanceof Long) {
            long l = (Long)object;
            return this.newLong(l);
        }
        if (object instanceof Double) {
            double d = (Double)object;
            return this.newDouble(d);
        }
        if (object instanceof String) {
            return this.newString((String)object);
        }
        if (object instanceof Type) {
            Type type = (Type)object;
            return this.newClassItem(type.getSort() == 10 ? type.getInternalName() : type.getDescriptor());
        }
        throw new IllegalArgumentException("value " + object);
    }

    public int newConst(Object object) {
        return this.newConstItem((Object)object).index;
    }

    public int newUTF8(String string) {
        this.key.set(1, string, null, null);
        Item item = this.get(this.key);
        if (item == null) {
            this.pool.putByte(1).putUTF8(string);
            item = new Item(this.index++, this.key);
            this.put(item);
        }
        return item.index;
    }

    public int newClass(String string) {
        return this.newClassItem((String)string).index;
    }

    private Item newClassItem(String string) {
        this.key2.set(7, string, null, null);
        Item item = this.get(this.key2);
        if (item == null) {
            this.pool.put12(7, this.newUTF8(string));
            item = new Item(this.index++, this.key2);
            this.put(item);
        }
        return item;
    }

    public int newField(String string, String string2, String string3) {
        this.key3.set(9, string, string2, string3);
        Item item = this.get(this.key3);
        if (item == null) {
            this.put122(9, this.newClass(string), this.newNameType(string2, string3));
            item = new Item(this.index++, this.key3);
            this.put(item);
        }
        return item.index;
    }

    Item newMethodItem(String string, String string2, String string3, boolean bl) {
        int n = bl ? 11 : 10;
        this.key3.set(n, string, string2, string3);
        Item item = this.get(this.key3);
        if (item == null) {
            this.put122(n, this.newClass(string), this.newNameType(string2, string3));
            item = new Item(this.index++, this.key3);
            this.put(item);
        }
        return item;
    }

    public int newMethod(String string, String string2, String string3, boolean bl) {
        return this.newMethodItem((String)string, (String)string2, (String)string3, (boolean)bl).index;
    }

    Item newInteger(int n) {
        this.key.set(n);
        Item item = this.get(this.key);
        if (item == null) {
            this.pool.putByte(3).putInt(n);
            item = new Item(this.index++, this.key);
            this.put(item);
        }
        return item;
    }

    Item newFloat(float f) {
        this.key.set(f);
        Item item = this.get(this.key);
        if (item == null) {
            this.pool.putByte(4).putInt(Float.floatToIntBits(f));
            item = new Item(this.index++, this.key);
            this.put(item);
        }
        return item;
    }

    Item newLong(long l) {
        this.key.set(l);
        Item item = this.get(this.key);
        if (item == null) {
            this.pool.putByte(5).putLong(l);
            item = new Item(this.index, this.key);
            this.put(item);
            this.index += 2;
        }
        return item;
    }

    Item newDouble(double d) {
        this.key.set(d);
        Item item = this.get(this.key);
        if (item == null) {
            this.pool.putByte(6).putLong(Double.doubleToLongBits(d));
            item = new Item(this.index, this.key);
            this.put(item);
            this.index += 2;
        }
        return item;
    }

    private Item newString(String string) {
        this.key2.set(8, string, null, null);
        Item item = this.get(this.key2);
        if (item == null) {
            this.pool.put12(8, this.newUTF8(string));
            item = new Item(this.index++, this.key2);
            this.put(item);
        }
        return item;
    }

    public int newNameType(String string, String string2) {
        this.key2.set(12, string, string2, null);
        Item item = this.get(this.key2);
        if (item == null) {
            this.put122(12, this.newUTF8(string), this.newUTF8(string2));
            item = new Item(this.index++, this.key2);
            this.put(item);
        }
        return item.index;
    }

    private Item get(Item item) {
        Item item2 = this.items[item.hashCode % this.items.length];
        while (item2 != null && !item.isEqualTo(item2)) {
            item2 = item2.next;
        }
        return item2;
    }

    private void put(Item item) {
        int n;
        if (this.index > this.threshold) {
            n = this.items.length;
            int n2 = n * 2 + 1;
            Item[] itemArray = new Item[n2];
            for (int i = n - 1; i >= 0; --i) {
                Item item2 = this.items[i];
                while (item2 != null) {
                    int n3 = item2.hashCode % itemArray.length;
                    Item item3 = item2.next;
                    item2.next = itemArray[n3];
                    itemArray[n3] = item2;
                    item2 = item3;
                }
            }
            this.items = itemArray;
            this.threshold = (int)((double)n2 * 0.75);
        }
        n = item.hashCode % this.items.length;
        item.next = this.items[n];
        this.items[n] = item;
    }

    private void put122(int n, int n2, int n3) {
        this.pool.put12(n, n2).putShort(n3);
    }

    static {
        byte[] byArray = new byte[220];
        String string = "AAAAAAAAAAAAAAAABCKLLDDDDDEEEEEEEEEEEEEEEEEEEEAAAAAAAADDDDDEEEEEEEEEEEEEEEEEEEEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMAAAAAAAAAAAAAAAAAAAAIIIIIIIIIIIIIIIIDNOAAAAAAGGGGGGGHAFBFAAFFAAQPIIJJIIIIIIIIIIIIIIIIII";
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(string.charAt(i) - 65);
        }
        TYPE = byArray;
    }
}

