/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.db.DatabaseEntry;

public class ByteBinding
extends TupleBinding<Byte> {
    private static final int BYTE_SIZE = 1;

    @Override
    public Byte entryToObject(TupleInput tupleInput) {
        return tupleInput.readByte();
    }

    @Override
    public void objectToEntry(Byte by, TupleOutput tupleOutput) {
        tupleOutput.writeByte(by.byteValue());
    }

    @Override
    protected TupleOutput getTupleOutput(Byte by) {
        return ByteBinding.sizedOutput();
    }

    public static byte entryToByte(DatabaseEntry databaseEntry) {
        return ByteBinding.entryToInput(databaseEntry).readByte();
    }

    public static void byteToEntry(byte by, DatabaseEntry databaseEntry) {
        ByteBinding.outputToEntry(ByteBinding.sizedOutput().writeByte(by), databaseEntry);
    }

    private static TupleOutput sizedOutput() {
        return new TupleOutput(new byte[1]);
    }
}

