/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.db.DatabaseEntry;

public class TupleBase<E> {
    private int outputBufferSize = 0;

    public void setTupleBufferSize(int n) {
        this.outputBufferSize = n;
    }

    public int getTupleBufferSize() {
        return this.outputBufferSize;
    }

    protected TupleOutput getTupleOutput(E e) {
        int n = this.getTupleBufferSize();
        if (n != 0) {
            return new TupleOutput(new byte[n]);
        }
        return new TupleOutput();
    }

    public static void outputToEntry(TupleOutput tupleOutput, DatabaseEntry databaseEntry) {
        databaseEntry.setData(tupleOutput.getBufferBytes(), tupleOutput.getBufferOffset(), tupleOutput.getBufferLength());
    }

    public static void inputToEntry(TupleInput tupleInput, DatabaseEntry databaseEntry) {
        databaseEntry.setData(tupleInput.getBufferBytes(), tupleInput.getBufferOffset(), tupleInput.getBufferLength());
    }

    public static TupleInput entryToInput(DatabaseEntry databaseEntry) {
        return new TupleInput(databaseEntry.getData(), databaseEntry.getOffset(), databaseEntry.getSize());
    }

    public static TupleOutput newOutput() {
        return new TupleOutput();
    }

    public static TupleOutput newOutput(byte[] byArray) {
        return new TupleOutput(byArray);
    }
}

