/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

public final class ReplicationConfig
implements Cloneable {
    public static final ReplicationConfig BULK = new ReplicationConfig("BULK", 2);
    public static final ReplicationConfig DELAYCLIENT = new ReplicationConfig("DELAYCLIENT", 4);
    public static final ReplicationConfig INMEM = new ReplicationConfig("INMEM", 8);
    public static final ReplicationConfig NOAUTOINIT = new ReplicationConfig("NOAUTOINIT", 32);
    public static final ReplicationConfig NOWAIT = new ReplicationConfig("NOWAIT", 64);
    public static final ReplicationConfig STRICT_2SITE = new ReplicationConfig("STRICT_2SITE", 1);
    public static final ReplicationConfig LEASE = new ReplicationConfig("LEASE", 16);
    private String configName;
    private int flag;

    static ReplicationConfig fromInt(int n) {
        switch (n) {
            case 2: {
                return BULK;
            }
            case 4: {
                return DELAYCLIENT;
            }
            case 8: {
                return INMEM;
            }
            case 32: {
                return NOAUTOINIT;
            }
            case 64: {
                return NOWAIT;
            }
            case 1: {
                return STRICT_2SITE;
            }
            case 16: {
                return LEASE;
            }
        }
        throw new IllegalArgumentException("Unknown replication config: " + n);
    }

    private ReplicationConfig(String string, int n) {
        this.configName = string;
        this.flag = n;
    }

    int getFlag() {
        return this.flag;
    }

    public String toString() {
        return "ReplicationConfig." + this.configName;
    }
}

