/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.KeyLocation;
import com.sleepycat.persist.impl.Reader;
import java.util.HashMap;
import java.util.Map;

class RecordInput
extends TupleInput
implements EntityInput {
    static final int VISITED_INIT_SIZE = 50;
    static final int PRI_KEY_VISITED_OFFSET = 0x7FFFFFFE;
    static final int PROHIBIT_REF_OFFSET = 0x7FFFFFFD;
    static final Object PROHIBIT_REF_OBJECT = new Object();
    static final String PROHIBIT_NESTED_REF_MSG = "Cannot embed a reference to a proxied object in the proxy; for example, a collection may not be an element of the collection because collections are proxied";
    private Catalog catalog;
    private boolean rawAccess;
    private Map<Integer, Object> visited;
    private DatabaseEntry priKeyEntry;
    private int priKeyFormatId;

    RecordInput(Catalog catalog, boolean bl, DatabaseEntry databaseEntry, int n, byte[] byArray, int n2, int n3) {
        super(byArray, n2, n3);
        this.catalog = catalog;
        this.rawAccess = bl;
        this.priKeyEntry = databaseEntry;
        this.priKeyFormatId = n;
    }

    private RecordInput(RecordInput recordInput, int n) {
        this(recordInput.catalog, recordInput.rawAccess, recordInput.priKeyEntry, recordInput.priKeyFormatId, recordInput.buf, n, recordInput.len);
        this.visited = recordInput.visited;
    }

    private RecordInput(RecordInput recordInput, DatabaseEntry databaseEntry) {
        this(recordInput.catalog, recordInput.rawAccess, recordInput.priKeyEntry, recordInput.priKeyFormatId, databaseEntry.getData(), databaseEntry.getOffset(), databaseEntry.getSize());
        this.visited = recordInput.visited;
    }

    @Override
    public Catalog getCatalog() {
        return this.catalog;
    }

    @Override
    public boolean isRawAccess() {
        return this.rawAccess;
    }

    @Override
    public boolean setRawAccess(boolean bl) {
        boolean bl2 = this.rawAccess;
        this.rawAccess = bl;
        return bl2;
    }

    @Override
    public Object readObject() {
        Integer n = this.off;
        RecordInput recordInput = this;
        int n2 = this.readPackedInt();
        Object object = null;
        if (n2 == 0) {
            return null;
        }
        if (n2 < 0) {
            int n3 = -(n2 + 1);
            if (this.visited != null) {
                object = this.visited.get(n3);
            }
            if (object == PROHIBIT_REF_OBJECT) {
                throw new IllegalArgumentException(PROHIBIT_NESTED_REF_MSG);
            }
            if (object != null) {
                return object;
            }
            n = n3;
            if (n3 == 0x7FFFFFFE) {
                assert (this.priKeyEntry != null && this.priKeyFormatId > 0);
                recordInput = new RecordInput(this, this.priKeyEntry);
                n2 = this.priKeyFormatId;
            } else {
                recordInput = new RecordInput(this, n3);
                n2 = recordInput.readPackedInt();
            }
        }
        if (this.visited == null) {
            this.visited = new HashMap<Integer, Object>(50);
        }
        this.visited.put(n, PROHIBIT_REF_OBJECT);
        Format format = this.catalog.getFormat(n2);
        Reader reader = format.getReader();
        object = reader.newInstance(recordInput, this.rawAccess);
        this.visited.put(n, object);
        Object object2 = reader.readObject(object, recordInput, this.rawAccess);
        if (object != object2) {
            this.visited.put(n, object2);
        }
        return object2;
    }

    @Override
    public Object readKeyObject(Format format) {
        Reader reader = format.getReader();
        Object object = reader.newInstance(this, this.rawAccess);
        return reader.readObject(object, this, this.rawAccess);
    }

    KeyLocation getKeyLocation(Format format) {
        RecordInput recordInput = this;
        if (!format.isPrimitive()) {
            int n = recordInput.readPackedInt();
            if (n == 0) {
                return null;
            }
            if (n < 0) {
                int n2 = -(n + 1);
                if (n2 == 0x7FFFFFFE) {
                    assert (this.priKeyEntry != null && this.priKeyFormatId > 0);
                    recordInput = new RecordInput(this, this.priKeyEntry);
                    n = this.priKeyFormatId;
                } else {
                    recordInput = new RecordInput(this, n2);
                    n = recordInput.readPackedInt();
                }
            }
            format = this.catalog.getFormat(n);
        }
        return new KeyLocation(recordInput, format);
    }

    @Override
    public void registerPriKeyObject(Object object) {
        if (this.visited == null) {
            this.visited = new HashMap<Integer, Object>(50);
        }
        this.visited.put(0x7FFFFFFE, object);
    }

    @Override
    public void skipField(Format format) {
        if (format != null && format.isPrimitive()) {
            format.skipContents(this);
        } else {
            int n = this.readPackedInt();
            if (n > 0) {
                Format format2 = this.catalog.getFormat(n);
                format2.skipContents(this);
            }
        }
    }

    @Override
    public int readArrayLength() {
        return this.readPackedInt();
    }

    @Override
    public int readEnumConstant(String[] stringArray) {
        return this.readPackedInt();
    }
}

