/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.tuple.TupleBase;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.CompositeKeyFormat;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.PersistEntityBinding;
import com.sleepycat.persist.impl.RecordInput;
import com.sleepycat.persist.impl.RecordOutput;

public class PersistKeyBinding
implements EntryBinding {
    Catalog catalog;
    Format keyFormat;
    boolean rawAccess;

    public PersistKeyBinding(Catalog catalog, String string, boolean bl) {
        this.catalog = catalog;
        this.keyFormat = PersistEntityBinding.getOrCreateFormat(catalog, string, bl);
        if (!(this.keyFormat.isSimple() || this.keyFormat.isEnum() || this.keyFormat.getClassMetadata() != null && this.keyFormat.getClassMetadata().getCompositeKeyFields() != null)) {
            throw new IllegalArgumentException("Key class is not a simple type, an enum, or a composite key class (composite keys must include @KeyField annotations): " + string);
        }
        this.rawAccess = bl;
    }

    PersistKeyBinding(Catalog catalog, Class clazz, String[] stringArray) {
        this.catalog = catalog;
        this.keyFormat = new CompositeKeyFormat(clazz, stringArray);
        this.keyFormat.initializeIfNeeded(catalog, null);
    }

    Object bytesToObject(byte[] byArray, int n, int n2) {
        return PersistKeyBinding.readKey(this.keyFormat, this.catalog, byArray, n, n2, this.rawAccess);
    }

    static Object readKey(Format format, Catalog catalog, byte[] byArray, int n, int n2, boolean bl) {
        RecordInput recordInput = new RecordInput(catalog, bl, null, 0, byArray, n, n2);
        return recordInput.readKeyObject(format);
    }

    public Object entryToObject(DatabaseEntry databaseEntry) {
        return this.bytesToObject(databaseEntry.getData(), databaseEntry.getOffset(), databaseEntry.getSize());
    }

    public void objectToEntry(Object object, DatabaseEntry databaseEntry) {
        RecordOutput recordOutput = new RecordOutput(this.catalog, this.rawAccess);
        recordOutput.writeKeyObject(object, this.keyFormat);
        TupleBase.outputToEntry(recordOutput, databaseEntry);
    }
}

