/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.model;

import com.sleepycat.persist.model.FieldMetadata;
import com.sleepycat.persist.model.PrimaryKeyMetadata;
import com.sleepycat.persist.model.SecondaryKeyMetadata;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ClassMetadata
implements Serializable {
    private static final long serialVersionUID = -2520207423701776679L;
    private String className;
    private int version;
    private String proxiedClassName;
    private boolean entityClass;
    private PrimaryKeyMetadata primaryKey;
    private Map<String, SecondaryKeyMetadata> secondaryKeys;
    private List<FieldMetadata> compositeKeyFields;
    private Collection<FieldMetadata> persistentFields;

    public ClassMetadata(String string, int n, String string2, boolean bl, PrimaryKeyMetadata primaryKeyMetadata, Map<String, SecondaryKeyMetadata> map, List<FieldMetadata> list) {
        this(string, n, string2, bl, primaryKeyMetadata, map, list, null);
    }

    public ClassMetadata(String string, int n, String string2, boolean bl, PrimaryKeyMetadata primaryKeyMetadata, Map<String, SecondaryKeyMetadata> map, List<FieldMetadata> list, Collection<FieldMetadata> collection) {
        this.className = string;
        this.version = n;
        this.proxiedClassName = string2;
        this.entityClass = bl;
        this.primaryKey = primaryKeyMetadata;
        this.secondaryKeys = map;
        this.compositeKeyFields = list;
        this.persistentFields = collection;
    }

    public String getClassName() {
        return this.className;
    }

    public int getVersion() {
        return this.version;
    }

    public String getProxiedClassName() {
        return this.proxiedClassName;
    }

    public boolean isEntityClass() {
        return this.entityClass;
    }

    public PrimaryKeyMetadata getPrimaryKey() {
        return this.primaryKey;
    }

    public Map<String, SecondaryKeyMetadata> getSecondaryKeys() {
        return this.secondaryKeys;
    }

    public List<FieldMetadata> getCompositeKeyFields() {
        return this.compositeKeyFields;
    }

    public Collection<FieldMetadata> getPersistentFields() {
        return this.persistentFields;
    }

    public boolean equals(Object object) {
        if (object instanceof ClassMetadata) {
            ClassMetadata classMetadata = (ClassMetadata)object;
            return this.version == classMetadata.version && this.entityClass == classMetadata.entityClass && ClassMetadata.nullOrEqual(this.className, classMetadata.className) && ClassMetadata.nullOrEqual(this.proxiedClassName, classMetadata.proxiedClassName) && ClassMetadata.nullOrEqual(this.primaryKey, classMetadata.primaryKey) && ClassMetadata.nullOrEqual(this.secondaryKeys, classMetadata.secondaryKeys) && ClassMetadata.nullOrEqual(this.compositeKeyFields, classMetadata.compositeKeyFields);
        }
        return false;
    }

    public int hashCode() {
        return this.version + (this.entityClass ? 1 : 0) + ClassMetadata.hashCode(this.className) + ClassMetadata.hashCode(this.proxiedClassName) + ClassMetadata.hashCode(this.primaryKey) + ClassMetadata.hashCode(this.secondaryKeys) + ClassMetadata.hashCode(this.compositeKeyFields);
    }

    static boolean nullOrEqual(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    static int hashCode(Object object) {
        if (object != null) {
            return object.hashCode();
        }
        return 0;
    }
}

