/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist;

import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.LockMode;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.persist.BasicIterator;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.ValueAdapter;
import com.sleepycat.util.keyrange.RangeCursor;
import java.util.Iterator;

class BasicCursor<V>
implements EntityCursor<V> {
    RangeCursor cursor;
    ValueAdapter<V> adapter;
    boolean updateAllowed;
    DatabaseEntry key;
    DatabaseEntry pkey;
    DatabaseEntry data;

    BasicCursor(RangeCursor rangeCursor, ValueAdapter<V> valueAdapter, boolean bl) {
        this.cursor = rangeCursor;
        this.adapter = valueAdapter;
        this.updateAllowed = bl;
        this.key = valueAdapter.initKey();
        this.pkey = valueAdapter.initPKey();
        this.data = valueAdapter.initData();
    }

    @Override
    public V first() throws DatabaseException {
        return this.first(null);
    }

    @Override
    public V first(LockMode lockMode) throws DatabaseException {
        return this.returnValue(this.cursor.getFirst(this.key, this.pkey, this.data, lockMode));
    }

    @Override
    public V last() throws DatabaseException {
        return this.last(null);
    }

    @Override
    public V last(LockMode lockMode) throws DatabaseException {
        return this.returnValue(this.cursor.getLast(this.key, this.pkey, this.data, lockMode));
    }

    @Override
    public V next() throws DatabaseException {
        return this.next(null);
    }

    @Override
    public V next(LockMode lockMode) throws DatabaseException {
        return this.returnValue(this.cursor.getNext(this.key, this.pkey, this.data, lockMode));
    }

    @Override
    public V nextDup() throws DatabaseException {
        return this.nextDup(null);
    }

    @Override
    public V nextDup(LockMode lockMode) throws DatabaseException {
        this.checkInitialized();
        return this.returnValue(this.cursor.getNextDup(this.key, this.pkey, this.data, lockMode));
    }

    @Override
    public V nextNoDup() throws DatabaseException {
        return this.nextNoDup(null);
    }

    @Override
    public V nextNoDup(LockMode lockMode) throws DatabaseException {
        return this.returnValue(this.cursor.getNextNoDup(this.key, this.pkey, this.data, lockMode));
    }

    @Override
    public V prev() throws DatabaseException {
        return this.prev(null);
    }

    @Override
    public V prev(LockMode lockMode) throws DatabaseException {
        return this.returnValue(this.cursor.getPrev(this.key, this.pkey, this.data, lockMode));
    }

    @Override
    public V prevDup() throws DatabaseException {
        return this.prevDup(null);
    }

    @Override
    public V prevDup(LockMode lockMode) throws DatabaseException {
        this.checkInitialized();
        return this.returnValue(this.cursor.getPrevDup(this.key, this.pkey, this.data, lockMode));
    }

    @Override
    public V prevNoDup() throws DatabaseException {
        return this.prevNoDup(null);
    }

    @Override
    public V prevNoDup(LockMode lockMode) throws DatabaseException {
        return this.returnValue(this.cursor.getPrevNoDup(this.key, this.pkey, this.data, lockMode));
    }

    @Override
    public V current() throws DatabaseException {
        return this.current(null);
    }

    @Override
    public V current(LockMode lockMode) throws DatabaseException {
        this.checkInitialized();
        return this.returnValue(this.cursor.getCurrent(this.key, this.pkey, this.data, lockMode));
    }

    @Override
    public int count() throws DatabaseException {
        this.checkInitialized();
        return this.cursor.count();
    }

    @Override
    public Iterator<V> iterator() {
        return this.iterator(null);
    }

    @Override
    public Iterator<V> iterator(LockMode lockMode) {
        return new BasicIterator(this, lockMode);
    }

    @Override
    public boolean update(V v) throws DatabaseException {
        if (!this.updateAllowed) {
            throw new UnsupportedOperationException("Update not allowed on a secondary index");
        }
        this.checkInitialized();
        this.adapter.valueToData(v, this.data);
        return this.cursor.putCurrent(this.data) == OperationStatus.SUCCESS;
    }

    @Override
    public boolean delete() throws DatabaseException {
        this.checkInitialized();
        return this.cursor.delete() == OperationStatus.SUCCESS;
    }

    @Override
    public EntityCursor<V> dup() throws DatabaseException {
        return new BasicCursor<V>(this.cursor.dup(true), this.adapter, this.updateAllowed);
    }

    @Override
    public void close() throws DatabaseException {
        this.cursor.close();
    }

    void checkInitialized() throws IllegalStateException {
        if (!this.cursor.isInitialized()) {
            throw new IllegalStateException("Cursor is not initialized at a valid position");
        }
    }

    V returnValue(OperationStatus operationStatus) {
        V v = operationStatus == OperationStatus.SUCCESS ? (V)this.adapter.entryToValue(this.key, this.pkey, this.data) : null;
        this.adapter.clearEntries(this.key, this.pkey, this.data);
        return v;
    }
}

