/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.serial;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBase;
import com.sleepycat.bind.serial.SerialInput;
import com.sleepycat.bind.serial.SerialOutput;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.util.FastInputStream;
import com.sleepycat.util.FastOutputStream;
import com.sleepycat.util.RuntimeExceptionWrapper;
import java.io.IOException;
import java.io.ObjectOutputStream;

public class SerialBinding<E>
extends SerialBase
implements EntryBinding<E> {
    private ClassCatalog classCatalog;
    private Class<E> baseClass;

    public SerialBinding(ClassCatalog classCatalog, Class<E> clazz) {
        if (classCatalog == null) {
            throw new NullPointerException("classCatalog must be non-null");
        }
        this.classCatalog = classCatalog;
        this.baseClass = clazz;
    }

    public final Class<E> getBaseClass() {
        return this.baseClass;
    }

    public ClassLoader getClassLoader() {
        ClassLoader classLoader = this.classCatalog.getClassLoader();
        if (classLoader != null) {
            return classLoader;
        }
        return Thread.currentThread().getContextClassLoader();
    }

    @Override
    public E entryToObject(DatabaseEntry databaseEntry) {
        int n = databaseEntry.getSize();
        byte[] byArray = SerialOutput.getStreamHeader();
        byte[] byArray2 = new byte[n + byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        System.arraycopy(databaseEntry.getData(), databaseEntry.getOffset(), byArray2, byArray.length, n);
        try {
            SerialInput serialInput = new SerialInput(new FastInputStream(byArray2, 0, byArray2.length), this.classCatalog, this.getClassLoader());
            return (E)serialInput.readObject();
        }
        catch (IOException iOException) {
            throw RuntimeExceptionWrapper.wrapIfNeeded(iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw RuntimeExceptionWrapper.wrapIfNeeded(classNotFoundException);
        }
    }

    @Override
    public void objectToEntry(E e, DatabaseEntry databaseEntry) {
        Object object;
        if (this.baseClass != null && !this.baseClass.isInstance(e)) {
            throw new IllegalArgumentException((e != null ? "Data object class (" + e.getClass() + ')' : "Null value") + " is not an instance of binding's base class (" + this.baseClass + ')');
        }
        FastOutputStream fastOutputStream = this.getSerialOutput(e);
        try {
            object = new SerialOutput(fastOutputStream, this.classCatalog);
            ((ObjectOutputStream)object).writeObject(e);
        }
        catch (IOException iOException) {
            throw RuntimeExceptionWrapper.wrapIfNeeded(iOException);
        }
        object = SerialOutput.getStreamHeader();
        databaseEntry.setData(fastOutputStream.getBufferBytes(), ((Object)object).length, fastOutputStream.getBufferLength() - ((Object)object).length);
    }
}

