/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.collections.BaseIterator;
import com.sleepycat.collections.BlockIterator;
import com.sleepycat.collections.DataCursor;
import com.sleepycat.collections.DataView;
import com.sleepycat.collections.StoredContainer;
import com.sleepycat.collections.StoredIterator;
import com.sleepycat.db.CursorConfig;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.JoinConfig;
import com.sleepycat.db.OperationStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class StoredCollection<E>
extends StoredContainer
implements Collection<E> {
    public static final int DEFAULT_ITERATOR_BLOCK_SIZE = 10;
    private int iteratorBlockSize = 10;

    StoredCollection(DataView dataView) {
        super(dataView);
    }

    public int getIteratorBlockSize() {
        return this.iteratorBlockSize;
    }

    public void setIteratorBlockSize(int n) {
        if (n < 2) {
            throw new IllegalArgumentException("blockSize is less than two: " + n);
        }
        this.iteratorBlockSize = n;
    }

    final boolean add(Object object, Object object2) {
        DataCursor dataCursor = null;
        boolean bl = this.beginAutoCommit();
        try {
            dataCursor = new DataCursor(this.view, true);
            OperationStatus operationStatus = dataCursor.putNoDupData(object, object2, null, false);
            this.closeCursor(dataCursor);
            this.commitAutoCommit(bl);
            return operationStatus == OperationStatus.SUCCESS;
        }
        catch (Exception exception) {
            this.closeCursor(dataCursor);
            throw this.handleException(exception, bl);
        }
    }

    BlockIterator blockIterator() {
        return new BlockIterator(this, this.isWriteAllowed(), this.iteratorBlockSize);
    }

    @Override
    public Iterator<E> iterator() {
        return this.blockIterator();
    }

    public StoredIterator<E> storedIterator() {
        return this.storedIterator(this.isWriteAllowed());
    }

    public StoredIterator<E> storedIterator(boolean bl) {
        try {
            return new StoredIterator(this, bl && this.isWriteAllowed(), null);
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    public StoredIterator<E> iterator(boolean bl) {
        return this.storedIterator(bl);
    }

    @Override
    public Object[] toArray() {
        ArrayList<E> arrayList = new ArrayList<E>();
        StoredIterator<E> storedIterator = null;
        try {
            storedIterator = this.storedIterator();
            while (storedIterator.hasNext()) {
                arrayList.add(storedIterator.next());
            }
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
        finally {
            StoredIterator.close(storedIterator);
        }
        return arrayList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        int n = 0;
        StoredIterator<E> storedIterator = null;
        try {
            storedIterator = this.storedIterator();
            while (n < TArray.length && storedIterator.hasNext()) {
                TArray[n++] = storedIterator.next();
            }
            if (n < TArray.length) {
                TArray[n] = null;
            } else if (storedIterator.hasNext()) {
                ArrayList<T> arrayList = new ArrayList<T>(Arrays.asList(TArray));
                while (storedIterator.hasNext()) {
                    arrayList.add(storedIterator.next());
                }
                TArray = arrayList.toArray(TArray);
            }
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
        finally {
            StoredIterator.close(storedIterator);
        }
        return TArray;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        Iterator iterator = null;
        try {
            iterator = this.storedOrExternalIterator(collection);
            while (iterator.hasNext()) {
                if (this.contains(iterator.next())) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
        finally {
            StoredIterator.close(iterator);
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        Iterator iterator = null;
        boolean bl = this.beginAutoCommit();
        try {
            iterator = this.storedOrExternalIterator(collection);
            boolean bl2 = false;
            while (iterator.hasNext()) {
                if (!this.add(iterator.next())) continue;
                bl2 = true;
            }
            StoredIterator.close(iterator);
            this.commitAutoCommit(bl);
            return bl2;
        }
        catch (Exception exception) {
            StoredIterator.close(iterator);
            throw this.handleException(exception, bl);
        }
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        Iterator iterator = null;
        boolean bl = this.beginAutoCommit();
        try {
            boolean bl2 = false;
            iterator = this.storedOrExternalIterator(collection);
            while (iterator.hasNext()) {
                if (!this.remove(iterator.next())) continue;
                bl2 = true;
            }
            StoredIterator.close(iterator);
            this.commitAutoCommit(bl);
            return bl2;
        }
        catch (Exception exception) {
            StoredIterator.close(iterator);
            throw this.handleException(exception, bl);
        }
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        StoredIterator<E> storedIterator = null;
        boolean bl = this.beginAutoCommit();
        try {
            boolean bl2 = false;
            storedIterator = this.storedIterator();
            while (storedIterator.hasNext()) {
                if (collection.contains(storedIterator.next())) continue;
                storedIterator.remove();
                bl2 = true;
            }
            StoredIterator.close(storedIterator);
            this.commitAutoCommit(bl);
            return bl2;
        }
        catch (Exception exception) {
            StoredIterator.close(storedIterator);
            throw this.handleException(exception, bl);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Collection) {
            Collection collection = StoredCollection.copyCollection(object);
            StoredIterator<E> storedIterator = null;
            try {
                storedIterator = this.storedIterator();
                boolean bl = true;
                while (storedIterator.hasNext()) {
                    if (collection.remove(storedIterator.next())) continue;
                    bl = false;
                    break;
                }
                boolean bl2 = bl && collection.isEmpty();
                return bl2;
            }
            catch (Exception exception) {
                throw StoredContainer.convertException(exception);
            }
            finally {
                StoredIterator.close(storedIterator);
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public List<E> toList() {
        ArrayList<E> arrayList = new ArrayList<E>();
        StoredIterator<E> storedIterator = null;
        try {
            storedIterator = this.storedIterator();
            while (storedIterator.hasNext()) {
                arrayList.add(storedIterator.next());
            }
            ArrayList<E> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
        finally {
            StoredIterator.close(storedIterator);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        StoredIterator<E> storedIterator = null;
        try {
            storedIterator = this.storedIterator();
            while (storedIterator.hasNext()) {
                if (stringBuilder.length() > 1) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(storedIterator.next().toString());
            }
            stringBuilder.append(']');
            String string = stringBuilder.toString();
            return string;
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
        finally {
            StoredIterator.close(storedIterator);
        }
    }

    @Override
    public int size() {
        boolean bl = this.iterateDuplicates();
        int n = 0;
        CursorConfig cursorConfig = this.view.currentTxn.isLockingMode() ? CursorConfig.READ_UNCOMMITTED : null;
        DataCursor dataCursor = null;
        try {
            dataCursor = new DataCursor(this.view, false, cursorConfig);
            OperationStatus operationStatus = dataCursor.getFirst(false);
            while (operationStatus == OperationStatus.SUCCESS) {
                n = bl ? (n += dataCursor.count()) : ++n;
                operationStatus = dataCursor.getNextNoDup(false);
            }
        }
        catch (Exception exception) {
            try {
                throw StoredContainer.convertException(exception);
            }
            catch (Throwable throwable) {
                this.closeCursor(dataCursor);
                throw throwable;
            }
        }
        this.closeCursor(dataCursor);
        return n;
    }

    public StoredIterator<E> join(StoredContainer[] storedContainerArray, Object[] objectArray, JoinConfig joinConfig) {
        try {
            DataView[] dataViewArray = new DataView[storedContainerArray.length];
            for (int i = 0; i < storedContainerArray.length; ++i) {
                dataViewArray[i] = storedContainerArray[i].view;
            }
            DataCursor dataCursor = this.view.join(dataViewArray, objectArray, joinConfig);
            return new StoredIterator(this, false, dataCursor);
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    final E getFirstOrLast(boolean bl) {
        E e;
        DataCursor dataCursor = null;
        try {
            dataCursor = new DataCursor(this.view, false);
            OperationStatus operationStatus = bl ? dataCursor.getFirst(false) : dataCursor.getLast(false);
            e = operationStatus == OperationStatus.SUCCESS ? (E)this.makeIteratorData(null, dataCursor) : null;
        }
        catch (Exception exception) {
            try {
                throw StoredContainer.convertException(exception);
            }
            catch (Throwable throwable) {
                this.closeCursor(dataCursor);
                throw throwable;
            }
        }
        this.closeCursor(dataCursor);
        return e;
    }

    E makeIteratorData(BaseIterator baseIterator, DataCursor dataCursor) {
        return this.makeIteratorData(baseIterator, dataCursor.getKeyThang(), dataCursor.getPrimaryKeyThang(), dataCursor.getValueThang());
    }

    abstract E makeIteratorData(BaseIterator var1, DatabaseEntry var2, DatabaseEntry var3, DatabaseEntry var4);

    abstract boolean hasValues();

    boolean iterateDuplicates() {
        return true;
    }

    void checkIterAddAllowed() throws UnsupportedOperationException {
        if (!this.areDuplicatesAllowed()) {
            throw new UnsupportedOperationException("Duplicates required");
        }
    }

    int getIndexOffset() {
        return 0;
    }

    private static Collection copyCollection(Object object) {
        if (object instanceof StoredCollection) {
            return ((StoredCollection)object).toList();
        }
        return new ArrayList((Collection)object);
    }
}

