/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.internal.DbStream;
import com.sleepycat.db.internal.Dbc;

public class DatabaseStreamConfig
implements Cloneable {
    private boolean readOnly = false;
    private boolean readOnlyIsSet = false;
    private boolean syncPerWrite = false;
    public static final DatabaseStreamConfig DEFAULT = new DatabaseStreamConfig();

    static DatabaseStreamConfig checkNull(DatabaseStreamConfig databaseStreamConfig) {
        return databaseStreamConfig == null ? DEFAULT : databaseStreamConfig;
    }

    public void setReadOnly(boolean bl) {
        this.readOnlyIsSet = true;
        this.readOnly = bl;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void setSyncPerWrite(boolean bl) {
        this.syncPerWrite = bl;
    }

    public boolean getSyncPerWrite() {
        return this.syncPerWrite;
    }

    DbStream openDatabaseStream(Dbc dbc) throws DatabaseException {
        int n = 0;
        if (this.readOnlyIsSet) {
            n |= this.readOnly ? 1 : 2;
        }
        if (this.syncPerWrite) {
            n |= 4;
        }
        return dbc.db_stream(n);
    }
}

