/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.Lock;
import com.sleepycat.db.LockOperation;
import com.sleepycat.db.LockRequestMode;
import com.sleepycat.db.internal.DbLock;

public class LockRequest {
    private DbLock lock;
    private LockRequestMode mode;
    private int modeFlag;
    private DatabaseEntry obj;
    private int op;
    private int timeout;

    public LockRequest(LockOperation lockOperation, LockRequestMode lockRequestMode, DatabaseEntry databaseEntry) {
        this(lockOperation, lockRequestMode, databaseEntry, null, 0);
    }

    public LockRequest(LockOperation lockOperation, LockRequestMode lockRequestMode, DatabaseEntry databaseEntry, Lock lock) {
        this(lockOperation, lockRequestMode, databaseEntry, lock, 0);
    }

    public LockRequest(LockOperation lockOperation, LockRequestMode lockRequestMode, DatabaseEntry databaseEntry, Lock lock, int n) {
        this.setOp(lockOperation);
        this.setMode(lockRequestMode);
        this.setObj(databaseEntry);
        this.setLock(lock);
        this.setTimeout(n);
    }

    public void setLock(Lock lock) {
        this.lock = lock == null ? null : lock.unwrap();
    }

    public void setMode(LockRequestMode lockRequestMode) {
        this.mode = lockRequestMode;
        this.modeFlag = lockRequestMode.getFlag();
    }

    public void setObj(DatabaseEntry databaseEntry) {
        this.obj = databaseEntry;
    }

    public void setOp(LockOperation lockOperation) {
        this.op = lockOperation.getFlag();
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    public Lock getLock() {
        if (this.lock != null && this.lock.wrapper != null) {
            return this.lock.wrapper;
        }
        return Lock.wrap(this.lock);
    }

    public LockRequestMode getMode() {
        return this.mode;
    }

    public DatabaseEntry getObj() {
        return this.obj;
    }

    public LockOperation getOp() {
        return LockOperation.fromFlag(this.op);
    }

    public int getTimeout() {
        return this.timeout;
    }
}

