/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db.internal;

import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.internal.db_javaJNI;

public class DbStream {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    protected DbStream(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(DbStream dbStream) {
        return dbStream == null ? 0L : dbStream.swigCPtr;
    }

    synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                throw new UnsupportedOperationException("C++ destructor does not have public access");
            }
            this.swigCPtr = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(int n) throws DatabaseException {
        try {
            this.close0(n);
        }
        finally {
            this.swigCPtr = 0L;
        }
    }

    void close0(int n) {
        db_javaJNI.DbStream_close0(this.swigCPtr, this, n);
    }

    public int read(DatabaseEntry databaseEntry, long l, int n, int n2) throws DatabaseException {
        return db_javaJNI.DbStream_read(this.swigCPtr, this, databaseEntry, l, n, n2);
    }

    public long size(int n) throws DatabaseException {
        return db_javaJNI.DbStream_size(this.swigCPtr, this, n);
    }

    public int write(DatabaseEntry databaseEntry, long l, int n) throws DatabaseException {
        return db_javaJNI.DbStream_write(this.swigCPtr, this, databaseEntry, l, n);
    }
}

