/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.db.Cursor;
import com.sleepycat.db.CursorConfig;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseConfig;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.Environment;
import com.sleepycat.db.LockMode;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.db.Transaction;
import com.sleepycat.persist.BasicCursor;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.EntityIndex;
import com.sleepycat.persist.KeyValueAdapter;
import com.sleepycat.persist.ValueAdapter;
import com.sleepycat.util.keyrange.KeyRange;
import com.sleepycat.util.keyrange.RangeCursor;

abstract class BasicIndex<K, E>
implements EntityIndex<K, E> {
    static final DatabaseEntry NO_RETURN_ENTRY = new DatabaseEntry();
    Database db;
    boolean transactional;
    boolean sortedDups;
    boolean locking;
    boolean concurrentDB;
    Class<K> keyClass;
    EntryBinding keyBinding;
    KeyRange emptyRange;
    ValueAdapter<K> keyAdapter;
    ValueAdapter<E> entityAdapter;

    BasicIndex(Database database, Class<K> clazz, EntryBinding entryBinding, ValueAdapter<E> valueAdapter) throws DatabaseException {
        this.db = database;
        DatabaseConfig databaseConfig = database.getConfig();
        this.transactional = databaseConfig.getTransactional();
        this.sortedDups = databaseConfig.getSortedDuplicates();
        this.locking = DbCompat.getInitializeLocking(database.getEnvironment().getConfig());
        Environment environment = database.getEnvironment();
        this.concurrentDB = DbCompat.getInitializeCDB(environment.getConfig());
        this.keyClass = clazz;
        this.keyBinding = entryBinding;
        this.entityAdapter = valueAdapter;
        this.emptyRange = new KeyRange(databaseConfig.getBtreeComparator());
        this.keyAdapter = new KeyValueAdapter<K>(clazz, entryBinding);
    }

    @Override
    public boolean contains(K k) throws DatabaseException {
        return this.contains(null, k, null);
    }

    @Override
    public boolean contains(Transaction transaction, K k, LockMode lockMode) throws DatabaseException {
        DatabaseEntry databaseEntry = new DatabaseEntry();
        DatabaseEntry databaseEntry2 = NO_RETURN_ENTRY;
        this.keyBinding.objectToEntry(k, databaseEntry);
        OperationStatus operationStatus = this.db.get(transaction, databaseEntry, databaseEntry2, lockMode);
        return operationStatus == OperationStatus.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count() throws DatabaseException {
        long l = 0L;
        DatabaseEntry databaseEntry = NO_RETURN_ENTRY;
        DatabaseEntry databaseEntry2 = NO_RETURN_ENTRY;
        CursorConfig cursorConfig = this.locking ? CursorConfig.READ_UNCOMMITTED : null;
        Cursor cursor = this.db.openCursor(null, cursorConfig);
        try {
            OperationStatus operationStatus = cursor.getFirst(databaseEntry, databaseEntry2, null);
            while (operationStatus == OperationStatus.SUCCESS) {
                l = this.sortedDups ? (l += (long)cursor.count()) : ++l;
                operationStatus = cursor.getNextNoDup(databaseEntry, databaseEntry2, null);
            }
        }
        finally {
            cursor.close();
        }
        return l;
    }

    @Override
    public boolean delete(K k) throws DatabaseException {
        return this.delete(null, k);
    }

    @Override
    public boolean delete(Transaction transaction, K k) throws DatabaseException {
        DatabaseEntry databaseEntry = new DatabaseEntry();
        this.keyBinding.objectToEntry(k, databaseEntry);
        OperationStatus operationStatus = this.db.delete(transaction, databaseEntry);
        return operationStatus == OperationStatus.SUCCESS;
    }

    @Override
    public EntityCursor<K> keys() throws DatabaseException {
        return this.keys(null, null);
    }

    @Override
    public EntityCursor<K> keys(Transaction transaction, CursorConfig cursorConfig) throws DatabaseException {
        return this.cursor(transaction, this.emptyRange, this.keyAdapter, cursorConfig);
    }

    @Override
    public EntityCursor<E> entities() throws DatabaseException {
        return this.cursor(null, this.emptyRange, this.entityAdapter, null);
    }

    @Override
    public EntityCursor<E> entities(Transaction transaction, CursorConfig cursorConfig) throws DatabaseException {
        return this.cursor(transaction, this.emptyRange, this.entityAdapter, cursorConfig);
    }

    @Override
    public EntityCursor<K> keys(K k, boolean bl, K k2, boolean bl2) throws DatabaseException {
        return this.cursor(null, k, bl, k2, bl2, this.keyAdapter, null);
    }

    @Override
    public EntityCursor<K> keys(Transaction transaction, K k, boolean bl, K k2, boolean bl2, CursorConfig cursorConfig) throws DatabaseException {
        return this.cursor(transaction, k, bl, k2, bl2, this.keyAdapter, cursorConfig);
    }

    @Override
    public EntityCursor<E> entities(K k, boolean bl, K k2, boolean bl2) throws DatabaseException {
        return this.cursor(null, k, bl, k2, bl2, this.entityAdapter, null);
    }

    @Override
    public EntityCursor<E> entities(Transaction transaction, K k, boolean bl, K k2, boolean bl2, CursorConfig cursorConfig) throws DatabaseException {
        return this.cursor(transaction, k, bl, k2, bl2, this.entityAdapter, cursorConfig);
    }

    private <V> EntityCursor<V> cursor(Transaction transaction, K k, boolean bl, K k2, boolean bl2, ValueAdapter<V> valueAdapter, CursorConfig cursorConfig) throws DatabaseException {
        DatabaseEntry databaseEntry = null;
        if (k != null) {
            databaseEntry = new DatabaseEntry();
            this.keyBinding.objectToEntry(k, databaseEntry);
        }
        DatabaseEntry databaseEntry2 = null;
        if (k2 != null) {
            databaseEntry2 = new DatabaseEntry();
            this.keyBinding.objectToEntry(k2, databaseEntry2);
        }
        KeyRange keyRange = this.emptyRange.subRange(databaseEntry, bl, databaseEntry2, bl2);
        return this.cursor(transaction, keyRange, valueAdapter, cursorConfig);
    }

    private <V> EntityCursor<V> cursor(Transaction transaction, KeyRange keyRange, ValueAdapter<V> valueAdapter, CursorConfig cursorConfig) throws DatabaseException {
        Cursor cursor = this.db.openCursor(transaction, cursorConfig);
        RangeCursor rangeCursor = new RangeCursor(keyRange, null, this.sortedDups, cursor);
        return new BasicCursor<V>(rangeCursor, valueAdapter, this.isUpdateAllowed());
    }

    abstract boolean isUpdateAllowed();

    static {
        NO_RETURN_ENTRY.setPartial(0, 0, true);
    }
}

