/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.bind.tuple.TupleBase;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.Sequence;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.PersistCatalog;
import com.sleepycat.persist.impl.PersistEntityBinding;
import com.sleepycat.persist.impl.PersistKeyBinding;
import com.sleepycat.persist.impl.RecordInput;
import com.sleepycat.persist.impl.RecordOutput;
import com.sleepycat.persist.impl.RefreshException;

public class PersistKeyAssigner {
    private volatile Catalog catalog;
    private volatile Format keyFieldFormat;
    private volatile Format entityFormat;
    private final boolean rawAccess;
    private final Sequence sequence;

    PersistKeyAssigner(PersistKeyBinding persistKeyBinding, PersistEntityBinding persistEntityBinding, Sequence sequence) {
        this.catalog = persistKeyBinding.catalog;
        this.keyFieldFormat = persistKeyBinding.keyFormat.getSequenceKeyFormat();
        this.entityFormat = persistEntityBinding.entityFormat;
        this.rawAccess = persistEntityBinding.rawAccess;
        this.sequence = sequence;
    }

    public boolean assignPrimaryKey(Object object, DatabaseEntry databaseEntry) throws DatabaseException {
        try {
            return this.assignPrimaryKeyInternal(object, databaseEntry);
        }
        catch (RefreshException refreshException) {
            refreshException.refresh();
            try {
                return this.assignPrimaryKeyInternal(object, databaseEntry);
            }
            catch (RefreshException refreshException2) {
                throw DbCompat.unexpectedException(refreshException2);
            }
        }
    }

    private boolean assignPrimaryKeyInternal(Object object, DatabaseEntry databaseEntry) throws DatabaseException, RefreshException {
        if (this.entityFormat.isPriKeyNullOrZero(object, this.rawAccess)) {
            Long l = this.sequence.get(null, 1);
            RecordOutput recordOutput = new RecordOutput(this.catalog, this.rawAccess);
            this.keyFieldFormat.writeObject(l, recordOutput, this.rawAccess);
            TupleBase.outputToEntry(recordOutput, databaseEntry);
            RecordInput recordInput = new RecordInput(this.catalog, this.rawAccess, null, 0, databaseEntry.getData(), databaseEntry.getOffset(), databaseEntry.getSize());
            this.entityFormat.getReader().readPriKey(object, recordInput, this.rawAccess);
            return true;
        }
        return false;
    }

    void refresh(PersistCatalog persistCatalog) {
        this.catalog = persistCatalog;
        this.entityFormat = this.catalog.getFormat(this.entityFormat.getClassName());
        this.keyFieldFormat = this.catalog.getFormat(this.keyFieldFormat.getClassName());
    }
}

