/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.db.DatabaseEntry;
import java.math.BigDecimal;

public class SortedBigDecimalBinding
extends TupleBinding<BigDecimal> {
    @Override
    public BigDecimal entryToObject(TupleInput tupleInput) {
        return tupleInput.readSortedBigDecimal();
    }

    @Override
    public void objectToEntry(BigDecimal bigDecimal, TupleOutput tupleOutput) {
        tupleOutput.writeSortedBigDecimal(bigDecimal);
    }

    @Override
    protected TupleOutput getTupleOutput(BigDecimal bigDecimal) {
        return SortedBigDecimalBinding.sizedOutput(bigDecimal);
    }

    public static BigDecimal entryToBigDecimal(DatabaseEntry databaseEntry) {
        return SortedBigDecimalBinding.entryToInput(databaseEntry).readSortedBigDecimal();
    }

    public static void bigDecimalToEntry(BigDecimal bigDecimal, DatabaseEntry databaseEntry) {
        SortedBigDecimalBinding.outputToEntry(SortedBigDecimalBinding.sizedOutput(bigDecimal).writeSortedBigDecimal(bigDecimal), databaseEntry);
    }

    private static TupleOutput sizedOutput(BigDecimal bigDecimal) {
        int n = TupleOutput.getSortedBigDecimalMaxByteLength(bigDecimal);
        return new TupleOutput(new byte[n]);
    }
}

