/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.collections.BaseIterator;
import com.sleepycat.collections.DataCursor;
import com.sleepycat.collections.DataView;
import com.sleepycat.collections.StoredCollection;
import com.sleepycat.collections.StoredContainer;
import com.sleepycat.collections.StoredIterator;
import com.sleepycat.collections.StoredMapEntry;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.OperationStatus;
import java.util.Map;
import java.util.Set;

public class StoredEntrySet<K, V>
extends StoredCollection<Map.Entry<K, V>>
implements Set<Map.Entry<K, V>> {
    StoredEntrySet(DataView dataView) {
        super(dataView);
    }

    @Override
    public boolean add(Map.Entry<K, V> entry) {
        return this.add(entry.getKey(), entry.getValue());
    }

    @Override
    public boolean remove(Object object) {
        if (!(object instanceof Map.Entry)) {
            return false;
        }
        DataCursor dataCursor = null;
        boolean bl = this.beginAutoCommit();
        try {
            dataCursor = new DataCursor(this.view, true);
            Map.Entry entry = (Map.Entry)object;
            OperationStatus operationStatus = dataCursor.findBoth(entry.getKey(), entry.getValue(), true);
            if (operationStatus == OperationStatus.SUCCESS) {
                dataCursor.delete();
            }
            this.closeCursor(dataCursor);
            this.commitAutoCommit(bl);
            return operationStatus == OperationStatus.SUCCESS;
        }
        catch (Exception exception) {
            this.closeCursor(dataCursor);
            throw this.handleException(exception, bl);
        }
    }

    @Override
    public boolean contains(Object object) {
        boolean bl;
        if (!(object instanceof Map.Entry)) {
            return false;
        }
        DataCursor dataCursor = null;
        try {
            dataCursor = new DataCursor(this.view, false);
            Map.Entry entry = (Map.Entry)object;
            OperationStatus operationStatus = dataCursor.findBoth(entry.getKey(), entry.getValue(), false);
            bl = operationStatus == OperationStatus.SUCCESS;
        }
        catch (Exception exception) {
            try {
                throw StoredContainer.convertException(exception);
            }
            catch (Throwable throwable) {
                this.closeCursor(dataCursor);
                throw throwable;
            }
        }
        this.closeCursor(dataCursor);
        return bl;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        StoredIterator storedIterator = null;
        try {
            Object object;
            storedIterator = this.storedIterator();
            while (storedIterator.hasNext()) {
                object = (Map.Entry)storedIterator.next();
                if (stringBuilder.length() > 1) {
                    stringBuilder.append(',');
                }
                Object k = object.getKey();
                Object v = object.getValue();
                if (k != null) {
                    stringBuilder.append(k.toString());
                }
                stringBuilder.append('=');
                if (v == null) continue;
                stringBuilder.append(v.toString());
            }
            stringBuilder.append(']');
            object = stringBuilder.toString();
            return object;
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
        finally {
            StoredIterator.close(storedIterator);
        }
    }

    @Override
    Map.Entry<K, V> makeIteratorData(BaseIterator baseIterator, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3) {
        return new StoredMapEntry(this.view.makeKey(databaseEntry, databaseEntry2), this.view.makeValue(databaseEntry2, databaseEntry3), this, baseIterator);
    }

    @Override
    boolean hasValues() {
        return true;
    }
}

