/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.BackupOptions;
import com.sleepycat.db.CacheFileStats;
import com.sleepycat.db.CacheStats;
import com.sleepycat.db.CheckpointConfig;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseConfig;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.EnvironmentConfig;
import com.sleepycat.db.Lock;
import com.sleepycat.db.LockDetectMode;
import com.sleepycat.db.LockRequest;
import com.sleepycat.db.LockRequestMode;
import com.sleepycat.db.LockStats;
import com.sleepycat.db.LogCursor;
import com.sleepycat.db.LogSequenceNumber;
import com.sleepycat.db.LogStats;
import com.sleepycat.db.LogVerifyConfig;
import com.sleepycat.db.MutexStats;
import com.sleepycat.db.PreparedTransaction;
import com.sleepycat.db.ReplicationChannel;
import com.sleepycat.db.ReplicationConfig;
import com.sleepycat.db.ReplicationManagerMessageDispatch;
import com.sleepycat.db.ReplicationManagerSite;
import com.sleepycat.db.ReplicationManagerSiteInfo;
import com.sleepycat.db.ReplicationManagerStartPolicy;
import com.sleepycat.db.ReplicationManagerStats;
import com.sleepycat.db.ReplicationStats;
import com.sleepycat.db.ReplicationStatus;
import com.sleepycat.db.ReplicationTimeoutType;
import com.sleepycat.db.SecondaryConfig;
import com.sleepycat.db.SecondaryDatabase;
import com.sleepycat.db.StatsConfig;
import com.sleepycat.db.Transaction;
import com.sleepycat.db.TransactionConfig;
import com.sleepycat.db.TransactionStats;
import com.sleepycat.db.TransactionStatus;
import com.sleepycat.db.internal.DbEnv;
import com.sleepycat.db.internal.DbSite;
import java.io.File;
import java.io.FileNotFoundException;

public class Environment {
    private DbEnv dbenv;
    private Environment[] slices = null;
    private int autoCommitFlag;
    public static final int EID_MASTER = -3;

    Environment(DbEnv dbEnv) throws DatabaseException {
        this.dbenv = dbEnv;
        dbEnv.wrapper = this;
    }

    public Environment(File file, EnvironmentConfig environmentConfig) throws DatabaseException, FileNotFoundException {
        this(EnvironmentConfig.checkNull(environmentConfig).openEnvironment(file));
        this.autoCommitFlag = (this.dbenv.get_open_flags() & 0x2000) == 0 ? 0 : 256;
    }

    public void close() throws DatabaseException {
        this.dbenv.close(0);
    }

    public void closeForceSync() throws DatabaseException {
        this.dbenv.close(1);
    }

    public void closeForceSyncEnv() throws DatabaseException {
        this.dbenv.close(2);
    }

    public void closeForceSyncAndForceSyncEnv() throws DatabaseException {
        this.dbenv.close(3);
    }

    DbEnv unwrap() {
        return this.dbenv;
    }

    public static void remove(File file, boolean bl, EnvironmentConfig environmentConfig) throws DatabaseException, FileNotFoundException {
        environmentConfig = EnvironmentConfig.checkNull(environmentConfig);
        int n = bl ? 1 : 0;
        n |= environmentConfig.getUseEnvironment() ? 4 : 0;
        DbEnv dbEnv = environmentConfig.createEnvironment();
        dbEnv.remove(file == null ? null : file.toString(), n |= environmentConfig.getUseEnvironmentRoot() ? 8 : 0);
    }

    public void setConfig(EnvironmentConfig environmentConfig) throws DatabaseException {
        environmentConfig.configureEnvironment(this.dbenv, new EnvironmentConfig(this.dbenv));
    }

    public EnvironmentConfig getConfig() throws DatabaseException {
        return new EnvironmentConfig(this.dbenv);
    }

    public Database openDatabase(Transaction transaction, String string, String string2, DatabaseConfig databaseConfig) throws DatabaseException, FileNotFoundException {
        Database database = null;
        database = new Database(DatabaseConfig.checkNull(databaseConfig).openDatabase(this.dbenv, transaction == null ? null : transaction.txn, string, string2));
        if (database == null) {
            return database;
        }
        if (Environment.slices_enabled() && database.getConfig().getSliced()) {
            database.getSlices();
        }
        return database;
    }

    public SecondaryDatabase openSecondaryDatabase(Transaction transaction, String string, String string2, Database database, SecondaryConfig secondaryConfig) throws DatabaseException, FileNotFoundException {
        return new SecondaryDatabase(SecondaryConfig.checkNull(secondaryConfig).openSecondaryDatabase(this.dbenv, transaction == null ? null : transaction.txn, string, string2, database.db), database);
    }

    public void removeDatabase(Transaction transaction, String string, String string2) throws DatabaseException, FileNotFoundException {
        this.dbenv.dbremove(transaction == null ? null : transaction.txn, string, string2, transaction == null ? this.autoCommitFlag : 0);
    }

    public void renameDatabase(Transaction transaction, String string, String string2, String string3) throws DatabaseException, FileNotFoundException {
        this.dbenv.dbrename(transaction == null ? null : transaction.txn, string, string2, string3, transaction == null ? this.autoCommitFlag : 0);
    }

    public File getHome() throws DatabaseException {
        String string = this.dbenv.get_home();
        return string == null ? null : new File(string);
    }

    public int trickleCacheWrite(int n) throws DatabaseException {
        return this.dbenv.memp_trickle(n);
    }

    public int detectDeadlocks(LockDetectMode lockDetectMode) throws DatabaseException {
        return this.dbenv.lock_detect(0, lockDetectMode.getFlag());
    }

    public Lock getLock(int n, boolean bl, DatabaseEntry databaseEntry, LockRequestMode lockRequestMode) throws DatabaseException {
        return Lock.wrap(this.dbenv.lock_get(n, bl ? 4 : 0, databaseEntry, lockRequestMode.getFlag()));
    }

    public void putLock(Lock lock) throws DatabaseException {
        this.dbenv.lock_put(lock.unwrap());
    }

    public int createLockerID() throws DatabaseException {
        return this.dbenv.lock_id();
    }

    public void freeLockerID(int n) throws DatabaseException {
        this.dbenv.lock_id_free(n);
    }

    public int getLockerPriority(int n) throws DatabaseException {
        return this.dbenv.get_lk_priority(n);
    }

    public void setLockerPriority(int n, int n2) throws DatabaseException {
        this.dbenv.set_lk_priority(n, n2);
    }

    public void lockVector(int n, boolean bl, LockRequest[] lockRequestArray) throws DatabaseException {
        this.dbenv.lock_vec(n, bl ? 4 : 0, lockRequestArray, 0, lockRequestArray.length);
    }

    public LogCursor openLogCursor() throws DatabaseException {
        return LogCursor.wrap(this.dbenv.log_cursor(0));
    }

    public String getLogFileName(LogSequenceNumber logSequenceNumber) throws DatabaseException {
        return this.dbenv.log_file(logSequenceNumber);
    }

    public int logVerify(LogVerifyConfig logVerifyConfig) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string = logVerifyConfig.getEnvHome();
        String string2 = logVerifyConfig.getDbFile();
        String string3 = logVerifyConfig.getDbName();
        long l = 0L;
        long l2 = 0L;
        if (logVerifyConfig.getContinueAfterFail()) {
            n3 = 1;
        }
        if (logVerifyConfig.getVerbose()) {
            n = 1;
        }
        if (logVerifyConfig.getStartTime() != null) {
            l = logVerifyConfig.getStartTime().getTime() / 1000L;
        }
        if (logVerifyConfig.getEndTime() != null) {
            l2 = logVerifyConfig.getEndTime().getTime() / 1000L;
        }
        LogSequenceNumber logSequenceNumber = logVerifyConfig.getStartLsn();
        LogSequenceNumber logSequenceNumber2 = logVerifyConfig.getEndLsn();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (logSequenceNumber2 != null) {
            n7 = logSequenceNumber2.getFile();
        }
        if (logSequenceNumber2 != null) {
            n6 = logSequenceNumber2.getOffset();
        }
        if (logSequenceNumber != null) {
            n5 = logSequenceNumber.getFile();
        }
        if (logSequenceNumber != null) {
            n4 = logSequenceNumber.getOffset();
        }
        try {
            n2 = this.dbenv.log_verify(string, logVerifyConfig.getCacheSize(), string2, string3, l, l2, n5, n4, n7, n6, n3, n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }

    public void startReplication(DatabaseEntry databaseEntry, boolean bl) throws DatabaseException {
        this.dbenv.rep_start(databaseEntry, bl ? 2 : 1);
    }

    public void electReplicationMaster(int n, int n2) throws DatabaseException {
        this.dbenv.rep_elect(n, n2, 0);
    }

    public void flushReplication() throws DatabaseException {
        this.dbenv.rep_flush();
    }

    public ReplicationStatus processReplicationMessage(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, int n) throws DatabaseException {
        DatabaseEntry databaseEntry3 = new DatabaseEntry(databaseEntry2.getData(), databaseEntry2.getOffset(), databaseEntry2.getSize());
        LogSequenceNumber logSequenceNumber = new LogSequenceNumber();
        int n2 = this.dbenv.rep_process_message(databaseEntry, databaseEntry3, n, logSequenceNumber);
        return ReplicationStatus.getStatus(n2, databaseEntry3, n, logSequenceNumber);
    }

    public void setReplicationConfig(ReplicationConfig replicationConfig, boolean bl) throws DatabaseException {
        this.dbenv.rep_set_config(replicationConfig.getFlag(), bl);
    }

    public boolean getReplicationConfig(ReplicationConfig replicationConfig) throws DatabaseException {
        return this.dbenv.rep_get_config(replicationConfig.getFlag());
    }

    public int getReplicationNumSites() throws DatabaseException {
        return this.dbenv.rep_get_nsites();
    }

    public void setReplicationTimeout(ReplicationTimeoutType replicationTimeoutType, int n) throws DatabaseException {
        this.dbenv.rep_set_timeout(replicationTimeoutType.getId(), n);
    }

    public int getReplicationTimeout(ReplicationTimeoutType replicationTimeoutType) throws DatabaseException {
        return this.dbenv.rep_get_timeout(replicationTimeoutType.getId());
    }

    public void syncReplication() throws DatabaseException {
        this.dbenv.rep_sync(0);
    }

    public void replicationManagerStart(int n, ReplicationManagerStartPolicy replicationManagerStartPolicy) throws DatabaseException {
        this.dbenv.repmgr_start(n, replicationManagerStartPolicy.getId());
    }

    public ReplicationManagerSite getReplicationManagerLocalSite() throws DatabaseException {
        DbSite dbSite = this.dbenv.repmgr_local_site();
        return dbSite == null ? null : new ReplicationManagerSite(dbSite);
    }

    public ReplicationManagerSiteInfo[] getReplicationManagerSiteList() throws DatabaseException {
        return this.dbenv.repmgr_site_list();
    }

    public ReplicationManagerSite getReplicationManagerSite(int n) throws DatabaseException {
        return new ReplicationManagerSite(this.dbenv.repmgr_site_by_eid(n));
    }

    public ReplicationManagerSite getReplicationManagerSite(String string, long l) throws DatabaseException {
        return new ReplicationManagerSite(this.dbenv.repmgr_site(string, l));
    }

    public ReplicationChannel openChannel(int n) throws DatabaseException {
        return new ReplicationChannel(this.dbenv.repmgr_channel(n, 0));
    }

    public void setReplicationManagerMessageDispatch(ReplicationManagerMessageDispatch replicationManagerMessageDispatch, int n) throws DatabaseException {
        this.dbenv.repmgr_set_dispatch(replicationManagerMessageDispatch, n);
    }

    public CacheStats getCacheStats(StatsConfig statsConfig) throws DatabaseException {
        return this.dbenv.memp_stat(StatsConfig.checkNull(statsConfig).getFlags());
    }

    public CacheFileStats[] getCacheFileStats(StatsConfig statsConfig) throws DatabaseException {
        return this.dbenv.memp_fstat(StatsConfig.checkNull(statsConfig).getFlags());
    }

    public LogStats getLogStats(StatsConfig statsConfig) throws DatabaseException {
        return this.dbenv.log_stat(StatsConfig.checkNull(statsConfig).getFlags());
    }

    public ReplicationStats getReplicationStats(StatsConfig statsConfig) throws DatabaseException {
        return this.dbenv.rep_stat(StatsConfig.checkNull(statsConfig).getFlags());
    }

    public ReplicationManagerStats getReplicationManagerStats(StatsConfig statsConfig) throws DatabaseException {
        return this.dbenv.repmgr_stat(StatsConfig.checkNull(statsConfig).getFlags());
    }

    public LockStats getLockStats(StatsConfig statsConfig) throws DatabaseException {
        return this.dbenv.lock_stat(StatsConfig.checkNull(statsConfig).getFlags());
    }

    public MutexStats getMutexStats(StatsConfig statsConfig) throws DatabaseException {
        return this.dbenv.mutex_stat(StatsConfig.checkNull(statsConfig).getFlags());
    }

    public TransactionStats getTransactionStats(StatsConfig statsConfig) throws DatabaseException {
        return this.dbenv.txn_stat(StatsConfig.checkNull(statsConfig).getFlags());
    }

    public int printMempStats(StatsConfig statsConfig) throws DatabaseException {
        return this.dbenv.memp_stat_print(StatsConfig.checkNull(statsConfig).getFlags());
    }

    public int printLogStats(StatsConfig statsConfig) throws DatabaseException {
        return this.dbenv.log_stat_print(StatsConfig.checkNull(statsConfig).getFlags());
    }

    public int printReplicationStats(StatsConfig statsConfig) throws DatabaseException {
        return this.dbenv.rep_stat_print(StatsConfig.checkNull(statsConfig).getFlags());
    }

    public int printReplicationManagerStats(StatsConfig statsConfig) throws DatabaseException {
        return this.dbenv.repmgr_stat_print(StatsConfig.checkNull(statsConfig).getFlags());
    }

    public int printLockStats(StatsConfig statsConfig) throws DatabaseException {
        return this.dbenv.lock_stat_print(StatsConfig.checkNull(statsConfig).getFlags());
    }

    public int printMutexStats(StatsConfig statsConfig) throws DatabaseException {
        return this.dbenv.mutex_stat_print(StatsConfig.checkNull(statsConfig).getFlags());
    }

    public int printStats(StatsConfig statsConfig) throws DatabaseException {
        return this.dbenv.stat_print(StatsConfig.checkNull(statsConfig).getFlags());
    }

    public int printTransactionStats(StatsConfig statsConfig) throws DatabaseException {
        return this.dbenv.txn_stat_print(StatsConfig.checkNull(statsConfig).getFlags());
    }

    public Transaction beginCDSGroup() throws DatabaseException {
        return new Transaction(this.dbenv.cdsgroup_begin());
    }

    public Transaction beginTransaction(Transaction transaction, TransactionConfig transactionConfig) throws DatabaseException {
        return new Transaction(TransactionConfig.checkNull(transactionConfig).beginTransaction(this.dbenv, transaction == null ? null : transaction.txn));
    }

    public void checkpoint(CheckpointConfig checkpointConfig) throws DatabaseException {
        CheckpointConfig.checkNull(checkpointConfig).runCheckpoint(this.dbenv);
    }

    public void logFlush(LogSequenceNumber logSequenceNumber) throws DatabaseException {
        this.dbenv.log_flush(logSequenceNumber);
    }

    public LogSequenceNumber logPut(DatabaseEntry databaseEntry, boolean bl) throws DatabaseException {
        LogSequenceNumber logSequenceNumber = new LogSequenceNumber();
        this.dbenv.log_put(logSequenceNumber, databaseEntry, bl ? 2 : 0);
        return logSequenceNumber;
    }

    public void logPrint(Transaction transaction, String string) throws DatabaseException {
        this.dbenv.log_print(transaction == null ? null : transaction.txn, string);
    }

    public File[] getArchiveLogFiles(boolean bl) throws DatabaseException {
        String[] stringArray = this.dbenv.log_archive(1 | (bl ? 4 : 0));
        int n = stringArray == null ? 0 : stringArray.length;
        File[] fileArray = new File[n];
        for (int i = 0; i < n; ++i) {
            fileArray[i] = new File(stringArray[i]);
        }
        return fileArray;
    }

    public File[] getArchiveDatabases() throws DatabaseException {
        String string = this.dbenv.get_home();
        String[] stringArray = this.dbenv.log_archive(2);
        int n = stringArray == null ? 0 : stringArray.length;
        File[] fileArray = new File[n];
        for (int i = 0; i < n; ++i) {
            fileArray[i] = new File(string, stringArray[i]);
        }
        return fileArray;
    }

    public void removeOldLogFiles() throws DatabaseException {
        this.dbenv.log_archive(8);
    }

    public PreparedTransaction[] recover(int n, boolean bl) throws DatabaseException {
        return this.dbenv.txn_recover(n, bl ? 16L : 7L);
    }

    public void resetFileID(String string, boolean bl) throws DatabaseException {
        this.dbenv.fileid_reset(string, bl ? 1 : 0);
    }

    public void resetLogSequenceNumber(String string, boolean bl) throws DatabaseException {
        this.dbenv.lsn_reset(string, bl ? 1 : 0);
    }

    public void panic(boolean bl) throws DatabaseException {
        this.dbenv.set_flags(65536, bl);
    }

    public void backup(String string, BackupOptions backupOptions) throws DatabaseException {
        this.dbenv.backup(string, backupOptions.getFlags());
    }

    public void backupDatabase(String string, String string2, boolean bl) throws DatabaseException {
        int n = 0;
        this.dbenv.dbbackup(string, string2, n |= bl ? 4 : 0);
    }

    public static String getVersionString() {
        return DbEnv.get_version_string();
    }

    public static String getVersionFullString() {
        return DbEnv.get_version_full_string();
    }

    public static int getVersionFamily() {
        return DbEnv.get_version_family();
    }

    public static int getVersionRelease() {
        return DbEnv.get_version_release();
    }

    public static int getVersionMajor() {
        return DbEnv.get_version_major();
    }

    public void syncCache(LogSequenceNumber logSequenceNumber) throws DatabaseException {
        this.dbenv.memp_sync(logSequenceNumber);
    }

    public TransactionStatus isTransactionApplied(byte[] byArray, int n) throws DatabaseException {
        if (byArray == null) {
            throw new NullPointerException("token is null");
        }
        if (byArray.length != 20) {
            throw new IllegalArgumentException("token must be 20 bytes");
        }
        return TransactionStatus.fromInt(this.dbenv.txn_applied(byArray, n, 0));
    }

    public static int getVersionMinor() {
        return DbEnv.get_version_minor();
    }

    public static int getVersionPatch() {
        return DbEnv.get_version_patch();
    }

    public void setBlobThreshold(int n) throws DatabaseException {
        this.setExternalFileThreshold(n);
    }

    public void setExternalFileThreshold(int n) throws DatabaseException {
        this.dbenv.set_ext_file_threshold(n, 0);
    }

    public void setMsgfile(File file) throws DatabaseException {
        if (file != null) {
            this.dbenv.set_msgfile(file.toString());
        } else {
            this.dbenv.set_msgfile(null);
        }
    }

    public int getSliceCount() throws DatabaseException {
        return this.dbenv.get_slice_count();
    }

    public Environment[] getSlices() throws DatabaseException {
        if (this.slices != null) {
            return this.slices;
        }
        DbEnv[] dbEnvArray = this.dbenv.get_slices();
        this.slices = new Environment[dbEnvArray.length];
        for (int i = 0; i < this.slices.length; ++i) {
            dbEnvArray[i].slice_init();
            this.slices[i] = new Environment(dbEnvArray[i]);
        }
        return this.slices;
    }

    public static boolean slices_enabled() throws DatabaseException {
        return DbEnv.slices_enabled() != 0;
    }
}

