/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.BackupHandler;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.ErrorHandler;
import com.sleepycat.db.EventHandler;
import com.sleepycat.db.FeedbackHandler;
import com.sleepycat.db.LockDetectMode;
import com.sleepycat.db.LogRecordHandler;
import com.sleepycat.db.MessageHandler;
import com.sleepycat.db.PanicHandler;
import com.sleepycat.db.RegionResourceType;
import com.sleepycat.db.ReplicationManagerAckPolicy;
import com.sleepycat.db.ReplicationManagerSiteConfig;
import com.sleepycat.db.ReplicationTransport;
import com.sleepycat.db.ReplicationViewHandler;
import com.sleepycat.db.VerboseConfig;
import com.sleepycat.db.internal.DbEnv;
import com.sleepycat.db.internal.DbSite;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Vector;

public class EnvironmentConfig
implements Cloneable {
    public static final EnvironmentConfig DEFAULT = new EnvironmentConfig();
    private int mode = 420;
    private int backup_read_count = 0;
    private int backup_read_sleep = 0;
    private int backup_size = 0;
    private boolean backup_write_direct = false;
    private int write_direct = 0;
    private File blobDir = null;
    private int blobThreshold = 0;
    private int cacheCount = 0;
    private long cacheSize = 0L;
    private long cacheMax = 0L;
    private File createDir = null;
    private Vector dataDirs = new Vector();
    private int envid = 0;
    private String errorPrefix = null;
    private String messagePrefix = null;
    private OutputStream errorStream = null;
    private OutputStream messageStream = System.out;
    private byte[][] lockConflicts = null;
    private LockDetectMode lockDetectMode = LockDetectMode.NONE;
    private int initMutexes = 0;
    private int lockTableSize = 0;
    private int maxLocks = 0;
    private int maxLockers = 0;
    private int maxLockObjects = 0;
    private int maxLogFileSize = 0;
    private int logBufferSize = 0;
    private File logDirectory = null;
    private int logFileMode = 0;
    private int logRegionSize = 0;
    private int maxMutexes = 0;
    private int maxOpenFiles = 0;
    private int maxWrite = 0;
    private long maxWriteSleep = 0L;
    private File metadataDir = null;
    private File msgfile = null;
    private String msgfileStr = null;
    private int mutexAlignment = 0;
    private int mutexIncrement = 0;
    private int mutexTestAndSetSpins = 0;
    private long mmapSize = 0L;
    private int mpPageSize = 0;
    private int mpTableSize = 0;
    private int partitionLocks = 0;
    private String password = null;
    private File regionDirectory = null;
    private long regionMemoryMax = 0L;
    private int replicationClockskewFast = 0;
    private int replicationClockskewSlow = 0;
    private long replicationLimit = 0L;
    private int replicationNumSites = 0;
    private int replicationPriority = 100;
    private int replicationRequestMin = 0;
    private int replicationRequestMax = 0;
    private long segmentId = 0L;
    private long lockTimeout = 0L;
    private int txnMaxActive = 0;
    private long txnTimeout = 0L;
    private Date txnTimestamp = null;
    private File temporaryDirectory = null;
    private ReplicationManagerAckPolicy repmgrAckPolicy = ReplicationManagerAckPolicy.QUORUM;
    private long repmgrIncomingQueueMax = 0L;
    private Vector repmgrSitesConfig = new Vector();
    private int initResourceLocks = 0;
    private int initResourceLockObjects = 0;
    private int initResourceLockers = 0;
    private int initResourceLogIds = 0;
    private int initResourceTransactions = 0;
    private int initResourceThreads = 0;
    private boolean allowCreate = false;
    private boolean initializeCache = false;
    private boolean initializeCDB = false;
    private boolean initializeLocking = false;
    private boolean initializeLogging = false;
    private boolean initializeReplication = false;
    private boolean joinEnvironment = false;
    private boolean lockDown = false;
    private boolean isPrivate = false;
    private boolean register = false;
    private boolean runRecovery = false;
    private boolean runFatalRecovery = false;
    private boolean systemMemory = false;
    private boolean threaded = true;
    private boolean transactional = false;
    private boolean useEnvironment = false;
    private boolean useEnvironmentRoot = false;
    private boolean cdbLockAllDatabases = false;
    private boolean directDatabaseIO = false;
    private boolean directLogIO = false;
    private boolean dsyncDatabases = false;
    private boolean dsyncLog = false;
    private boolean hotbackupInProgress = false;
    private boolean initializeRegions = false;
    private boolean logAutoRemove = false;
    private boolean logBlobContent = false;
    private boolean logInMemory = false;
    private boolean logNoSync = false;
    private boolean logZero = false;
    private boolean multiversion = false;
    private boolean noLocking = false;
    private boolean noMMap = false;
    private boolean noPanic = false;
    private boolean overwrite = false;
    private boolean replicationInMemory = false;
    private boolean txnNoSync = false;
    private boolean txnNoWait = false;
    private boolean txnSnapshot = false;
    private boolean txnWriteNoSync = false;
    private boolean yieldCPU = false;
    private boolean verboseBackup = false;
    private boolean verboseDeadlock = false;
    private boolean verboseFileops = false;
    private boolean verboseFileopsAll = false;
    private boolean verboseRecovery = false;
    private boolean verboseRegister = false;
    private boolean verboseReplication = false;
    private boolean verboseReplicationElection = false;
    private boolean verboseReplicationLease = false;
    private boolean verboseReplicationMisc = false;
    private boolean verboseReplicationMsgs = false;
    private boolean verboseReplicationSync = false;
    private boolean verboseReplicationSystem = true;
    private boolean verboseReplicationTest = false;
    private boolean verboseRepmgrConnfail = false;
    private boolean verboseRepmgrMisc = false;
    private boolean verboseSlice = false;
    private boolean verboseWaitsFor = false;
    private BackupHandler backupHandler = null;
    private ErrorHandler errorHandler = null;
    private FeedbackHandler feedbackHandler = null;
    private LogRecordHandler logRecordHandler = null;
    private EventHandler eventHandler = null;
    private MessageHandler messageHandler = null;
    private PanicHandler panicHandler = null;
    private boolean repViewIsSet = false;
    private ReplicationViewHandler replicationViewHandler = null;
    private ReplicationTransport replicationTransport = null;

    static EnvironmentConfig checkNull(EnvironmentConfig environmentConfig) {
        return environmentConfig == null ? DEFAULT : environmentConfig;
    }

    public EnvironmentConfig() {
    }

    public void setAllowCreate(boolean bl) {
        this.allowCreate = bl;
    }

    public boolean getAllowCreate() {
        return this.allowCreate;
    }

    public void setBlobDir(File file) {
        this.setExternalFileDir(file);
    }

    public File getBlobDir() {
        return this.getExternalFileDir();
    }

    public void setBlobThreshold(int n) {
        this.setExternalFileThreshold(n);
    }

    public int getBlobThreshold() {
        return this.getExternalFileThreshold();
    }

    public void setCacheSize(long l) {
        this.cacheSize = l;
    }

    public long getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheMax(long l) {
        this.cacheMax = l;
    }

    public long getCacheMax() {
        return this.cacheMax;
    }

    public void setCacheCount(int n) {
        this.cacheCount = n;
    }

    public int getCacheCount() {
        return this.cacheCount;
    }

    public void setCDBLockAllDatabases(boolean bl) {
        this.cdbLockAllDatabases = bl;
    }

    public boolean getCDBLockAllDatabases() {
        return this.cdbLockAllDatabases;
    }

    public void setCreateDir(File file) {
        this.createDir = file;
    }

    public File getCreateDir() {
        return this.createDir;
    }

    public void addDataDir(File file) {
        this.dataDirs.add(file);
    }

    public void addDataDir(String string) {
        this.addDataDir(new File(string));
    }

    public File[] getDataDirs() {
        Object[] objectArray = new File[this.dataDirs.size()];
        this.dataDirs.copyInto(objectArray);
        return objectArray;
    }

    public void setDirectDatabaseIO(boolean bl) {
        this.directDatabaseIO = bl;
    }

    public boolean getDirectDatabaseIO() {
        return this.directDatabaseIO;
    }

    public void setDirectLogIO(boolean bl) {
        this.directLogIO = bl;
    }

    public boolean getDirectLogIO() {
        return this.directLogIO;
    }

    public void setDsyncDatabases(boolean bl) {
        this.dsyncDatabases = bl;
    }

    public boolean getDsyncDatabases() {
        return this.dsyncDatabases;
    }

    public void setDsyncLog(boolean bl) {
        this.dsyncLog = bl;
    }

    public boolean getDsyncLog() {
        return this.dsyncLog;
    }

    public void setEncrypted(String string) {
        this.password = string;
    }

    public boolean getEncrypted() {
        return this.password != null;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorPrefix(String string) {
        this.errorPrefix = string;
    }

    public String getErrorPrefix() {
        return this.errorPrefix;
    }

    public void setErrorStream(OutputStream outputStream) {
        this.errorStream = outputStream;
    }

    public OutputStream getErrorStream() {
        return this.errorStream;
    }

    public void setExternalFileDir(File file) {
        this.blobDir = file;
    }

    public File getExternalFileDir() {
        return this.blobDir;
    }

    public void setExternalFileThreshold(int n) {
        this.blobThreshold = n;
    }

    public int getExternalFileThreshold() {
        return this.blobThreshold;
    }

    public int getBackupReadCount() {
        return this.backup_read_count;
    }

    public void setBackupReadCount(int n) {
        this.backup_read_count = n;
    }

    public int getBackupReadSleep() {
        return this.backup_read_sleep;
    }

    public void setBackupReadSleep(int n) {
        this.backup_read_sleep = n;
    }

    public int getBackupSize() {
        return this.backup_size;
    }

    public void setBackupSize(int n) {
        this.backup_size = n;
    }

    public boolean getBackupWriteDirect() {
        return this.backup_write_direct;
    }

    public void setBackupWriteDirect(boolean bl) {
        this.backup_write_direct = bl;
    }

    public void setBackupHandler(BackupHandler backupHandler) {
        this.backupHandler = backupHandler;
    }

    public BackupHandler getBackupHandler() {
        return this.backupHandler;
    }

    public void setEventHandler(EventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    public EventHandler getEventHandler() {
        return this.eventHandler;
    }

    public void setFeedbackHandler(FeedbackHandler feedbackHandler) {
        this.feedbackHandler = feedbackHandler;
    }

    public FeedbackHandler getFeedbackHandler() {
        return this.feedbackHandler;
    }

    public void setHotbackupInProgress(boolean bl) {
        this.hotbackupInProgress = bl;
    }

    public boolean getHotbackupInProgress() {
        return this.hotbackupInProgress;
    }

    public void setInitializeCache(boolean bl) {
        this.initializeCache = bl;
    }

    public boolean getInitializeCache() {
        return this.initializeCache;
    }

    public void setInitializeCDB(boolean bl) {
        this.initializeCDB = bl;
    }

    public boolean getInitializeCDB() {
        return this.initializeCDB;
    }

    public void setInitializeLocking(boolean bl) {
        this.initializeLocking = bl;
    }

    public boolean getInitializeLocking() {
        return this.initializeLocking;
    }

    public void setInitializeLogging(boolean bl) {
        this.initializeLogging = bl;
    }

    public boolean getInitializeLogging() {
        return this.initializeLogging;
    }

    public void setInitializeRegions(boolean bl) {
        this.initializeRegions = bl;
    }

    public boolean getInitializeRegions() {
        return this.initializeRegions;
    }

    public void setInitializeReplication(boolean bl) {
        this.initializeReplication = bl;
    }

    public boolean getInitializeReplication() {
        return this.initializeReplication;
    }

    public void setJoinEnvironment(boolean bl) {
        this.joinEnvironment = bl;
    }

    public boolean getJoinEnvironment() {
        return this.joinEnvironment;
    }

    public void setLockConflicts(byte[][] byArray) {
        this.lockConflicts = byArray;
    }

    public byte[][] getLockConflicts() {
        return this.lockConflicts;
    }

    public void setLockDetectMode(LockDetectMode lockDetectMode) {
        this.lockDetectMode = lockDetectMode;
    }

    public LockDetectMode getLockDetectMode() {
        return this.lockDetectMode;
    }

    public void setLockDown(boolean bl) {
        this.lockDown = bl;
    }

    public boolean getLockDown() {
        return this.lockDown;
    }

    public void setLockTimeout(long l) {
        this.lockTimeout = l;
    }

    public long getLockTimeout() {
        return this.lockTimeout;
    }

    public void setLogAutoRemove(boolean bl) {
        this.logAutoRemove = bl;
    }

    public boolean getLogAutoRemove() {
        return this.logAutoRemove;
    }

    public void setLogBlobContent(boolean bl) {
        this.setLogExternalFileContent(bl);
    }

    public boolean getLogBlobContent() {
        return this.getLogExternalFileContent();
    }

    public void setLogExternalFileContent(boolean bl) {
        this.logBlobContent = this.logBlobContent;
    }

    public boolean getLogExternalFileContent() {
        return this.logBlobContent;
    }

    public void setLogInMemory(boolean bl) {
        this.logInMemory = bl;
    }

    public boolean getLogInMemory() {
        return this.logInMemory;
    }

    public void setLogNoSync(boolean bl) {
        this.logNoSync = bl;
    }

    public boolean getLogNoSync() {
        return this.logNoSync;
    }

    public void setLogRecordHandler(LogRecordHandler logRecordHandler) {
        this.logRecordHandler = logRecordHandler;
    }

    public LogRecordHandler getLogRecordHandler() {
        return this.logRecordHandler;
    }

    public void setLogZero(boolean bl) {
        this.logZero = bl;
    }

    public boolean getLogZero() {
        return this.logZero;
    }

    public int getRegionMemoryInitialSize(RegionResourceType regionResourceType) {
        switch (regionResourceType.getFlag()) {
            case 1: {
                return this.initResourceLocks;
            }
            case 2: {
                return this.initResourceLockObjects;
            }
            case 3: {
                return this.initResourceLockers;
            }
            case 4: {
                return this.initResourceLogIds;
            }
            case 5: {
                return this.initResourceTransactions;
            }
            case 6: {
                return this.initResourceThreads;
            }
        }
        return 0;
    }

    public void setRegionMemoryInitialSize(RegionResourceType regionResourceType, int n) {
        switch (regionResourceType.getFlag()) {
            case 1: {
                this.initResourceLocks = n;
                break;
            }
            case 2: {
                this.initResourceLockObjects = n;
                break;
            }
            case 3: {
                this.initResourceLockers = n;
                break;
            }
            case 4: {
                this.initResourceLogIds = n;
                break;
            }
            case 5: {
                this.initResourceTransactions = n;
                break;
            }
            case 6: {
                this.initResourceThreads = n;
            }
        }
    }

    public long getRegionMemoryMax() {
        return this.regionMemoryMax;
    }

    public void setRegionMemoryMax(long l) {
        this.regionMemoryMax = l;
    }

    public void setReplicationInMemory(boolean bl) {
        this.replicationInMemory = bl;
    }

    public boolean getReplicationInMemory() {
        return this.replicationInMemory;
    }

    public void setReplicationManagerAckPolicy(ReplicationManagerAckPolicy replicationManagerAckPolicy) {
        this.repmgrAckPolicy = replicationManagerAckPolicy;
    }

    public ReplicationManagerAckPolicy getReplicationManagerAckPolicy() {
        return this.repmgrAckPolicy;
    }

    public void setReplicationManagerIncomingQueueMax(long l) {
        this.repmgrIncomingQueueMax = l;
    }

    public long getReplicationManagerIncomingQueueMax() {
        return this.repmgrIncomingQueueMax;
    }

    public void addReplicationManagerSite(ReplicationManagerSiteConfig replicationManagerSiteConfig) {
        this.repmgrSitesConfig.add(replicationManagerSiteConfig);
    }

    public void setLockPartitions(int n) {
        this.partitionLocks = n;
    }

    public int getLockPartitions() {
        return this.partitionLocks;
    }

    public void setMaxLocks(int n) {
        this.maxLocks = n;
    }

    public int getMaxLocks() {
        return this.maxLocks;
    }

    public void setLockTableSize(int n) {
        this.lockTableSize = n;
    }

    public int getLockTableSize() {
        return this.lockTableSize;
    }

    public void setMaxLockers(int n) {
        this.maxLockers = n;
    }

    public int getMaxLockers() {
        return this.maxLockers;
    }

    public void setMaxLockObjects(int n) {
        this.maxLockObjects = n;
    }

    public int getMaxLockObjects() {
        return this.maxLockObjects;
    }

    public void setMaxLogFileSize(int n) {
        this.maxLogFileSize = n;
    }

    public int getMaxLogFileSize() {
        return this.maxLogFileSize;
    }

    public void setLogBufferSize(int n) {
        this.logBufferSize = n;
    }

    public int getLogBufferSize() {
        return this.logBufferSize;
    }

    public void setLogDirectory(File file) {
        this.logDirectory = file;
    }

    public File getLogDirectory() {
        return this.logDirectory;
    }

    public void setLogFileMode(int n) {
        this.logFileMode = n;
    }

    public int getLogFileMode() {
        return this.logFileMode;
    }

    public void setLogRegionSize(int n) {
        this.logRegionSize = n;
    }

    public int getLogRegionSize() {
        return this.logRegionSize;
    }

    public void setMaxOpenFiles(int n) {
        this.maxOpenFiles = n;
    }

    public int getMaxOpenFiles() {
        return this.maxOpenFiles;
    }

    public void setMaxWrite(int n, long l) {
        this.maxWrite = n;
        this.maxWriteSleep = l;
    }

    public int getMaxWrite() {
        return this.maxWrite;
    }

    public long getMaxWriteSleep() {
        return this.maxWriteSleep;
    }

    public void setMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public void setMessagePrefix(String string) {
        this.messagePrefix = string;
    }

    public String getMessagePrefix() {
        return this.messagePrefix;
    }

    public void setMessageStream(OutputStream outputStream) {
        this.messageStream = outputStream;
    }

    public OutputStream getMessageStream() {
        return this.messageStream;
    }

    public void setMetadataDir(File file) {
        this.metadataDir = file;
    }

    public File getMetadataDir() {
        return this.metadataDir;
    }

    public void setMMapSize(long l) {
        this.mmapSize = l;
    }

    public long getMMapSize() {
        return this.mmapSize;
    }

    public void setMsgfile(File file) {
        this.msgfile = file;
        this.msgfileStr = file != null ? file.toString() : null;
    }

    public void setCachePageSize(int n) {
        this.mpPageSize = n;
    }

    public int getCachePageSize() {
        return this.mpPageSize;
    }

    public void setCacheTableSize(int n) {
        this.mpTableSize = n;
    }

    public int getCacheTableSize() {
        return this.mpTableSize;
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public long getMode() {
        return this.mode;
    }

    public void setMultiversion(boolean bl) {
        this.multiversion = bl;
    }

    public boolean getMultiversion() {
        return this.multiversion;
    }

    public void setNoLocking(boolean bl) {
        this.noLocking = bl;
    }

    public boolean getNoLocking() {
        return this.noLocking;
    }

    public void setNoMMap(boolean bl) {
        this.noMMap = bl;
    }

    public boolean getNoMMap() {
        return this.noMMap;
    }

    public void setNoPanic(boolean bl) {
        this.noPanic = bl;
    }

    public boolean getNoPanic() {
        return this.noPanic;
    }

    public void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    public void setPanicHandler(PanicHandler panicHandler) {
        this.panicHandler = panicHandler;
    }

    public PanicHandler getPanicHandler() {
        return this.panicHandler;
    }

    public void setRegionDirectory(File file) {
        this.regionDirectory = file;
    }

    public File getRegionDirectory() {
        return this.regionDirectory;
    }

    public void setReplicationView(ReplicationViewHandler replicationViewHandler) {
        this.repViewIsSet = true;
        this.replicationViewHandler = replicationViewHandler;
    }

    public ReplicationViewHandler getReplicationViewHandler() {
        return this.replicationViewHandler;
    }

    public void setPrivate(boolean bl) {
        this.isPrivate = bl;
    }

    public boolean getPrivate() {
        return this.isPrivate;
    }

    public void setReplicationClockskew(int n, int n2) {
        this.replicationClockskewFast = n;
        this.replicationClockskewSlow = n2;
    }

    public int getReplicationClockskewFast() {
        return this.replicationClockskewFast;
    }

    public int getReplicationClockskewSlow() {
        return this.replicationClockskewSlow;
    }

    public void setReplicationLimit(long l) {
        this.replicationLimit = l;
    }

    public long getReplicationLimit() {
        return this.replicationLimit;
    }

    public void setReplicationRequestMin(int n) {
        this.replicationRequestMin = n;
    }

    public int getReplicationRequestMin() {
        return this.replicationRequestMin;
    }

    public void setReplicationRequestMax(int n) {
        this.replicationRequestMax = n;
    }

    public int getReplicationRequestMax() {
        return this.replicationRequestMax;
    }

    public void setReplicationTransport(int n, ReplicationTransport replicationTransport) {
        this.envid = n;
        this.replicationTransport = replicationTransport;
    }

    public ReplicationTransport getReplicationTransport() {
        return this.replicationTransport;
    }

    public void setRegister(boolean bl) {
        this.register = bl;
    }

    public boolean getRegister() {
        return this.register;
    }

    public void setRunFatalRecovery(boolean bl) {
        this.runFatalRecovery = bl;
    }

    public boolean getRunFatalRecovery() {
        return this.runFatalRecovery;
    }

    public void setRunRecovery(boolean bl) {
        this.runRecovery = bl;
    }

    public boolean getRunRecovery() {
        return this.runRecovery;
    }

    public void setSystemMemory(boolean bl) {
        this.systemMemory = bl;
    }

    public boolean getSystemMemory() {
        return this.systemMemory;
    }

    public void setSegmentId(long l) {
        this.segmentId = l;
    }

    public long getSegmentId() {
        return this.segmentId;
    }

    public void setTemporaryDirectory(File file) {
        this.temporaryDirectory = file;
    }

    public void setTemporaryDirectory(String string) {
        this.setTemporaryDirectory(new File(string));
    }

    public File getTemporaryDirectory() {
        return this.temporaryDirectory;
    }

    public void setMutexAlignment(int n) {
        this.mutexAlignment = n;
    }

    public int getMutexAlignment() {
        return this.mutexAlignment;
    }

    public void setMutexIncrement(int n) {
        this.mutexIncrement = n;
    }

    public int getMutexIncrement() {
        return this.mutexIncrement;
    }

    public void setInitialMutexes(int n) {
        this.initMutexes = n;
    }

    public int getInitialMutexes() {
        return this.initMutexes;
    }

    public void setMaxMutexes(int n) {
        this.maxMutexes = n;
    }

    public int getMaxMutexes() {
        return this.maxMutexes;
    }

    public void setMutexTestAndSetSpins(int n) {
        this.mutexTestAndSetSpins = n;
    }

    public int getMutexTestAndSetSpins() {
        return this.mutexTestAndSetSpins;
    }

    public void setReplicationNumSites(int n) {
        if (n == 0) {
            throw new IllegalArgumentException("Can't set the number of sites to 0");
        }
        this.replicationNumSites = n;
    }

    public int getReplicationNumSites() {
        return this.replicationNumSites;
    }

    public void setReplicationPriority(int n) {
        this.replicationPriority = n;
    }

    public int getReplicationPriority() {
        return this.replicationPriority;
    }

    public void setTestAndSetSpins(int n) {
        this.setMutexTestAndSetSpins(n);
    }

    public int getTestAndSetSpins() {
        return this.getMutexTestAndSetSpins();
    }

    public void setThreaded(boolean bl) {
        this.threaded = bl;
    }

    public boolean getThreaded() {
        return this.threaded;
    }

    public void setTransactional(boolean bl) {
        this.transactional = bl;
    }

    public boolean getTransactional() {
        return this.transactional;
    }

    public void setTxnNoSync(boolean bl) {
        this.txnNoSync = bl;
    }

    public boolean getTxnNoSync() {
        return this.txnNoSync;
    }

    public void setTxnNoWait(boolean bl) {
        this.txnNoWait = bl;
    }

    public boolean getTxnNoWait() {
        return this.txnNoWait;
    }

    public void setTxnSnapshot(boolean bl) {
        this.txnSnapshot = bl;
    }

    public boolean getTxnSnapshot() {
        return this.txnSnapshot;
    }

    public void setTxnMaxActive(int n) {
        this.txnMaxActive = n;
    }

    public int getTxnMaxActive() {
        return this.txnMaxActive;
    }

    public void setTxnTimeout(long l) {
        this.txnTimeout = l;
    }

    public long getTxnTimeout() {
        return this.txnTimeout;
    }

    public void setTxnTimestamp(Date date) {
        this.txnTimestamp = date;
    }

    public Date getTxnTimestamp() {
        return this.txnTimestamp;
    }

    public void setTxnWriteNoSync(boolean bl) {
        this.txnWriteNoSync = bl;
    }

    public boolean getTxnWriteNoSync() {
        return this.txnWriteNoSync;
    }

    public void setUseEnvironment(boolean bl) {
        this.useEnvironment = bl;
    }

    public boolean getUseEnvironment() {
        return this.useEnvironment;
    }

    public void setUseEnvironmentRoot(boolean bl) {
        this.useEnvironmentRoot = bl;
    }

    public boolean getUseEnvironmentRoot() {
        return this.useEnvironmentRoot;
    }

    public void setVerbose(VerboseConfig verboseConfig, boolean bl) {
        int n = verboseConfig.getInternalFlag();
        switch (n) {
            case 1: {
                this.verboseBackup = bl;
                break;
            }
            case 2: {
                this.verboseDeadlock = bl;
                break;
            }
            case 4: {
                this.verboseFileops = bl;
                break;
            }
            case 8: {
                this.verboseFileopsAll = bl;
                break;
            }
            case 32: {
                this.verboseRecovery = bl;
                break;
            }
            case 64: {
                this.verboseRegister = bl;
                break;
            }
            case 128: {
                this.verboseReplication = bl;
                break;
            }
            case 256: {
                this.verboseRepmgrConnfail = bl;
                break;
            }
            case 512: {
                this.verboseRepmgrMisc = bl;
                break;
            }
            case 1024: {
                this.verboseReplicationElection = bl;
                break;
            }
            case 2048: {
                this.verboseReplicationLease = bl;
                break;
            }
            case 4096: {
                this.verboseReplicationMisc = bl;
                break;
            }
            case 8192: {
                this.verboseReplicationMsgs = bl;
                break;
            }
            case 16384: {
                this.verboseReplicationSync = bl;
                break;
            }
            case 32768: {
                this.verboseReplicationSystem = bl;
                break;
            }
            case 65536: {
                this.verboseReplicationTest = bl;
                break;
            }
            case 131072: {
                this.verboseSlice = bl;
                break;
            }
            case 262144: {
                this.verboseWaitsFor = bl;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown verbose flag: " + DbEnv.strerror(n));
            }
        }
    }

    public boolean getVerbose(VerboseConfig verboseConfig) {
        int n = verboseConfig.getInternalFlag();
        switch (n) {
            case 1: {
                return this.verboseBackup;
            }
            case 2: {
                return this.verboseDeadlock;
            }
            case 4: {
                return this.verboseFileops;
            }
            case 8: {
                return this.verboseFileopsAll;
            }
            case 32: {
                return this.verboseRecovery;
            }
            case 64: {
                return this.verboseRegister;
            }
            case 128: {
                return this.verboseReplication;
            }
            case 256: {
                return this.verboseRepmgrConnfail;
            }
            case 512: {
                return this.verboseRepmgrMisc;
            }
            case 1024: {
                return this.verboseReplicationElection;
            }
            case 2048: {
                return this.verboseReplicationLease;
            }
            case 4096: {
                return this.verboseReplicationMisc;
            }
            case 8192: {
                return this.verboseReplicationMsgs;
            }
            case 16384: {
                return this.verboseReplicationSync;
            }
            case 32768: {
                return this.verboseReplicationSystem;
            }
            case 65536: {
                return this.verboseReplicationTest;
            }
            case 131072: {
                return this.verboseSlice;
            }
            case 262144: {
                return this.verboseWaitsFor;
            }
        }
        throw new IllegalArgumentException("Unknown verbose flag: " + DbEnv.strerror(n));
    }

    public void setVerboseDeadlock(boolean bl) {
        this.verboseDeadlock = bl;
    }

    public boolean getVerboseDeadlock() {
        return this.verboseDeadlock;
    }

    public void setVerboseRecovery(boolean bl) {
        this.verboseRecovery = bl;
    }

    public boolean getVerboseRecovery() {
        return this.verboseRecovery;
    }

    public void setVerboseRegister(boolean bl) {
        this.verboseRegister = bl;
    }

    public boolean getVerboseRegister() {
        return this.verboseRegister;
    }

    public void setVerboseReplication(boolean bl) {
        this.verboseReplication = bl;
    }

    public boolean getVerboseReplication() {
        return this.verboseReplication;
    }

    public void setVerboseWaitsFor(boolean bl) {
        this.verboseWaitsFor = bl;
    }

    public boolean getVerboseWaitsFor() {
        return this.verboseWaitsFor;
    }

    public void setYieldCPU(boolean bl) {
        this.yieldCPU = bl;
    }

    public boolean getYieldCPU() {
        return this.yieldCPU;
    }

    private boolean lockConflictsEqual(byte[][] byArray, byte[][] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null || byArray2 == null || byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i].length != byArray2[i].length) {
                return false;
            }
            for (int j = 0; j < byArray[i].length; ++j) {
                if (byArray[i][j] == byArray2[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DbEnv openEnvironment(File file) throws DatabaseException, FileNotFoundException {
        DbEnv dbEnv = this.createEnvironment();
        int n = 0;
        n |= this.allowCreate ? 1 : 0;
        n |= this.initializeCache ? 1024 : 0;
        n |= this.initializeCDB ? 128 : 0;
        n |= this.initializeLocking ? 256 : 0;
        n |= this.initializeLogging ? 512 : 0;
        n |= this.initializeReplication ? 4096 : 0;
        n |= this.joinEnvironment ? 0 : 0;
        n |= this.lockDown ? 16384 : 0;
        n |= this.isPrivate ? 65536 : 0;
        n |= this.register ? 262144 : 0;
        n |= this.runRecovery ? 2 : 0;
        n |= this.runFatalRecovery ? 131072 : 0;
        n |= this.systemMemory ? 524288 : 0;
        n |= this.threaded ? 32 : 0;
        n |= this.transactional ? 8192 : 0;
        n |= this.useEnvironment ? 4 : 0;
        n |= this.useEnvironmentRoot ? 8 : 0;
        boolean bl = false;
        try {
            dbEnv.open(file == null ? null : file.toString(), n, this.mode);
            bl = true;
            DbEnv dbEnv2 = dbEnv;
            return dbEnv2;
        }
        finally {
            if (!bl) {
                try {
                    dbEnv.close(0);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    DbEnv createEnvironment() throws DatabaseException {
        int n = 0;
        DbEnv dbEnv = new DbEnv(n);
        this.configureEnvironment(dbEnv, DEFAULT);
        return dbEnv;
    }

    void configureEnvironment(DbEnv dbEnv, EnvironmentConfig environmentConfig) throws DatabaseException {
        Object object;
        if (this.errorHandler != environmentConfig.errorHandler) {
            dbEnv.set_errcall(this.errorHandler);
        }
        if (this.errorPrefix != environmentConfig.errorPrefix && this.errorPrefix != null && !this.errorPrefix.equals(environmentConfig.errorPrefix)) {
            dbEnv.set_errpfx(this.errorPrefix);
        }
        if (this.errorStream != environmentConfig.errorStream) {
            dbEnv.set_error_stream(this.errorStream);
        }
        if (this.messagePrefix != environmentConfig.messagePrefix && this.messagePrefix != null && !this.messagePrefix.equals(environmentConfig.messagePrefix)) {
            dbEnv.set_msgpfx(this.messagePrefix);
        }
        if (this.messageStream != environmentConfig.messageStream) {
            dbEnv.set_message_stream(this.messageStream);
        }
        int n = 262144;
        int n2 = 0;
        if (this.cdbLockAllDatabases && !environmentConfig.cdbLockAllDatabases) {
            n |= 0x40;
        }
        if (!this.cdbLockAllDatabases && environmentConfig.cdbLockAllDatabases) {
            n2 |= 0x40;
        }
        if (this.directDatabaseIO && !environmentConfig.directDatabaseIO) {
            n |= 0x200;
        }
        if (!this.directDatabaseIO && environmentConfig.directDatabaseIO) {
            n2 |= 0x200;
        }
        if (this.dsyncDatabases && !environmentConfig.dsyncDatabases) {
            n |= 0x400;
        }
        if (!this.dsyncDatabases && environmentConfig.dsyncDatabases) {
            n2 |= 0x400;
        }
        if (this.hotbackupInProgress && !environmentConfig.hotbackupInProgress) {
            n |= 0x800;
        }
        if (!this.hotbackupInProgress && environmentConfig.hotbackupInProgress) {
            n2 |= 0x800;
        }
        if (this.initializeRegions && !environmentConfig.initializeRegions) {
            n |= 0x20000;
        }
        if (!this.initializeRegions && environmentConfig.initializeRegions) {
            n2 |= 0x20000;
        }
        if (this.multiversion && !environmentConfig.multiversion) {
            n |= 8;
        }
        if (!this.multiversion && environmentConfig.multiversion) {
            n2 |= 8;
        }
        if (this.noLocking && !environmentConfig.noLocking) {
            n |= 0x2000;
        }
        if (!this.noLocking && environmentConfig.noLocking) {
            n2 |= 0x2000;
        }
        if (this.noMMap && !environmentConfig.noMMap) {
            n |= 0x10;
        }
        if (!this.noMMap && environmentConfig.noMMap) {
            n2 |= 0x10;
        }
        if (this.noPanic && !environmentConfig.noPanic) {
            n |= 0x4000;
        }
        if (!this.noPanic && environmentConfig.noPanic) {
            n2 |= 0x4000;
        }
        if (this.overwrite && !environmentConfig.overwrite) {
            n |= 0x8000;
        }
        if (!this.overwrite && environmentConfig.overwrite) {
            n2 |= 0x8000;
        }
        if (this.txnNoSync && !environmentConfig.txnNoSync) {
            n |= 1;
        }
        if (!this.txnNoSync && environmentConfig.txnNoSync) {
            n2 |= 1;
        }
        if (this.txnNoWait && !environmentConfig.txnNoWait) {
            n |= 2;
        }
        if (!this.txnNoWait && environmentConfig.txnNoWait) {
            n2 |= 2;
        }
        if (this.txnSnapshot && !environmentConfig.txnSnapshot) {
            n |= 4;
        }
        if (!this.txnSnapshot && environmentConfig.txnSnapshot) {
            n2 |= 4;
        }
        if (this.txnWriteNoSync && !environmentConfig.txnWriteNoSync) {
            n |= 0x20;
        }
        if (!this.txnWriteNoSync && environmentConfig.txnWriteNoSync) {
            n2 |= 0x20;
        }
        if (this.yieldCPU && !environmentConfig.yieldCPU) {
            n |= 0x80000;
        }
        if (!this.yieldCPU && environmentConfig.yieldCPU) {
            n2 |= 0x80000;
        }
        if (n != 0) {
            dbEnv.set_flags(n, true);
        }
        if (n2 != 0) {
            dbEnv.set_flags(n2, false);
        }
        if (this.directLogIO != environmentConfig.directLogIO) {
            dbEnv.log_set_config(2, this.directLogIO);
        }
        if (this.dsyncLog != environmentConfig.dsyncLog) {
            dbEnv.log_set_config(4, this.dsyncLog);
        }
        if (this.logAutoRemove != environmentConfig.logAutoRemove) {
            dbEnv.log_set_config(1, this.logAutoRemove);
        }
        if (this.logBlobContent != environmentConfig.logBlobContent) {
            dbEnv.log_set_config(8, this.logBlobContent);
        }
        if (this.logInMemory != environmentConfig.logInMemory) {
            dbEnv.log_set_config(16, this.logInMemory);
        }
        if (this.logNoSync != environmentConfig.logNoSync) {
            dbEnv.log_set_config(32, this.logNoSync);
        }
        if (this.logZero != environmentConfig.logZero) {
            dbEnv.log_set_config(64, this.logZero);
        }
        if (this.verboseBackup != environmentConfig.verboseBackup) {
            dbEnv.set_verbose(1, this.verboseBackup);
        }
        if (this.verboseDeadlock != environmentConfig.verboseDeadlock) {
            dbEnv.set_verbose(2, this.verboseDeadlock);
        }
        if (this.verboseFileops != environmentConfig.verboseFileops) {
            dbEnv.set_verbose(4, this.verboseFileops);
        }
        if (this.verboseFileopsAll != environmentConfig.verboseFileopsAll) {
            dbEnv.set_verbose(8, this.verboseFileopsAll);
        }
        if (this.verboseRecovery != !environmentConfig.verboseRecovery) {
            dbEnv.set_verbose(32, this.verboseRecovery);
        }
        if (this.verboseRegister != environmentConfig.verboseRegister) {
            dbEnv.set_verbose(64, this.verboseRegister);
        }
        if (this.verboseReplication != environmentConfig.verboseReplication) {
            dbEnv.set_verbose(128, this.verboseReplication);
        }
        if (this.verboseReplicationElection != environmentConfig.verboseReplicationElection) {
            dbEnv.set_verbose(1024, this.verboseReplicationElection);
        }
        if (this.verboseReplicationLease != environmentConfig.verboseReplicationLease) {
            dbEnv.set_verbose(2048, this.verboseReplicationLease);
        }
        if (this.verboseReplicationMisc != environmentConfig.verboseReplicationMisc) {
            dbEnv.set_verbose(4096, this.verboseReplicationMisc);
        }
        if (this.verboseReplicationMsgs != environmentConfig.verboseReplicationMsgs) {
            dbEnv.set_verbose(8192, this.verboseReplicationMsgs);
        }
        if (this.verboseReplicationSync != environmentConfig.verboseReplicationSync) {
            dbEnv.set_verbose(16384, this.verboseReplicationSync);
        }
        if (this.verboseReplicationSystem != environmentConfig.verboseReplicationSystem) {
            dbEnv.set_verbose(32768, this.verboseReplicationSystem);
        }
        if (this.verboseReplicationTest != environmentConfig.verboseReplicationTest) {
            dbEnv.set_verbose(65536, this.verboseReplicationTest);
        }
        if (this.verboseRepmgrConnfail != environmentConfig.verboseRepmgrConnfail) {
            dbEnv.set_verbose(256, this.verboseRepmgrConnfail);
        }
        if (this.verboseRepmgrMisc != environmentConfig.verboseRepmgrMisc) {
            dbEnv.set_verbose(512, this.verboseRepmgrMisc);
        }
        if (this.verboseSlice != environmentConfig.verboseSlice) {
            dbEnv.set_verbose(131072, this.verboseSlice);
        }
        if (this.verboseWaitsFor != environmentConfig.verboseWaitsFor) {
            dbEnv.set_verbose(262144, this.verboseWaitsFor);
        }
        if (this.backupHandler != environmentConfig.backupHandler) {
            dbEnv.set_backup_callbacks(this.backupHandler, this.backupHandler, this.backupHandler);
        }
        if (this.feedbackHandler != environmentConfig.feedbackHandler) {
            dbEnv.set_feedback(this.feedbackHandler);
        }
        if (this.logRecordHandler != environmentConfig.logRecordHandler) {
            dbEnv.set_app_dispatch(this.logRecordHandler);
        }
        if (this.eventHandler != environmentConfig.eventHandler) {
            dbEnv.set_event_notify(this.eventHandler);
        }
        if (this.messageHandler != environmentConfig.messageHandler) {
            dbEnv.set_msgcall(this.messageHandler);
        }
        if (this.panicHandler != environmentConfig.panicHandler) {
            dbEnv.set_paniccall(this.panicHandler);
        }
        if (this.repViewIsSet) {
            dbEnv.rep_set_view(this.replicationViewHandler);
        }
        if (this.replicationTransport != environmentConfig.replicationTransport) {
            dbEnv.rep_set_transport(this.envid, this.replicationTransport);
        }
        if (this.backup_read_count != 0) {
            dbEnv.set_backup_config(1, this.backup_read_count);
        }
        if (this.backup_read_sleep != 0) {
            dbEnv.set_backup_config(2, this.backup_read_sleep);
        }
        if (this.backup_size != 0) {
            dbEnv.set_backup_config(3, this.backup_size);
        }
        if (this.backup_write_direct) {
            dbEnv.set_backup_config(4, 1);
        } else {
            dbEnv.set_backup_config(4, 0);
        }
        if (this.blobDir != environmentConfig.blobDir) {
            dbEnv.set_ext_file_dir(this.blobDir.toString());
        }
        if (this.blobThreshold != environmentConfig.blobThreshold) {
            dbEnv.set_ext_file_threshold(this.blobThreshold, 0);
        }
        if (this.cacheSize != environmentConfig.cacheSize || this.cacheCount != environmentConfig.cacheCount) {
            dbEnv.set_cachesize(this.cacheSize, this.cacheCount);
        }
        if (this.cacheMax != environmentConfig.cacheMax) {
            dbEnv.set_cache_max(this.cacheMax);
        }
        Object object2 = this.dataDirs.elements();
        while (object2.hasMoreElements()) {
            object = (File)object2.nextElement();
            if (environmentConfig.dataDirs.contains(object)) continue;
            dbEnv.add_data_dir(((File)object).toString());
        }
        if (this.createDir != environmentConfig.createDir) {
            dbEnv.set_create_dir(this.createDir.toString());
        }
        if (!this.lockConflictsEqual(this.lockConflicts, environmentConfig.lockConflicts)) {
            dbEnv.set_lk_conflicts(this.lockConflicts);
        }
        if (this.lockDetectMode != environmentConfig.lockDetectMode) {
            dbEnv.set_lk_detect(this.lockDetectMode.getFlag());
        }
        if (this.lockTableSize != environmentConfig.lockTableSize) {
            dbEnv.set_lk_tablesize(this.lockTableSize);
        }
        if (this.maxLocks != environmentConfig.maxLocks) {
            dbEnv.set_lk_max_locks(this.maxLocks);
        }
        if (this.maxLockers != environmentConfig.maxLockers) {
            dbEnv.set_lk_max_lockers(this.maxLockers);
        }
        if (this.maxLockObjects != environmentConfig.maxLockObjects) {
            dbEnv.set_lk_max_objects(this.maxLockObjects);
        }
        if (this.partitionLocks != environmentConfig.partitionLocks) {
            dbEnv.set_lk_partitions(this.partitionLocks);
        }
        if (this.maxLogFileSize != environmentConfig.maxLogFileSize) {
            dbEnv.set_lg_max(this.maxLogFileSize);
        }
        if (this.logBufferSize != environmentConfig.logBufferSize) {
            dbEnv.set_lg_bsize(this.logBufferSize);
        }
        if (this.logDirectory != environmentConfig.logDirectory && this.logDirectory != null && !this.logDirectory.equals(environmentConfig.logDirectory)) {
            dbEnv.set_lg_dir(this.logDirectory.toString());
        }
        if (this.logFileMode != environmentConfig.logFileMode) {
            dbEnv.set_lg_filemode(this.logFileMode);
        }
        if (this.logRegionSize != environmentConfig.logRegionSize) {
            dbEnv.set_lg_regionmax(this.logRegionSize);
        }
        if (this.maxOpenFiles != environmentConfig.maxOpenFiles) {
            dbEnv.set_mp_max_openfd(this.maxOpenFiles);
        }
        if (this.maxWrite != environmentConfig.maxWrite || this.maxWriteSleep != environmentConfig.maxWriteSleep) {
            dbEnv.set_mp_max_write(this.maxWrite, this.maxWriteSleep);
        }
        if (this.messageStream != environmentConfig.messageStream) {
            dbEnv.set_message_stream(this.messageStream);
        }
        if (this.metadataDir != environmentConfig.metadataDir) {
            dbEnv.set_metadata_dir(this.metadataDir.toString());
        }
        if (this.mmapSize != environmentConfig.mmapSize) {
            dbEnv.set_mp_mmapsize(this.mmapSize);
        }
        if (this.mpPageSize != environmentConfig.mpPageSize) {
            dbEnv.set_mp_pagesize(this.mpPageSize);
        }
        if (this.mpTableSize != environmentConfig.mpTableSize) {
            dbEnv.set_mp_tablesize(this.mpTableSize);
        }
        if (this.msgfile != environmentConfig.msgfile) {
            dbEnv.set_msgfile(this.msgfile.toString());
        }
        if (this.password != null) {
            dbEnv.set_encrypt(this.password, 1);
        }
        if (this.regionDirectory != environmentConfig.regionDirectory && this.regionDirectory != null && !this.regionDirectory.equals(environmentConfig.regionDirectory)) {
            dbEnv.set_region_dir(this.regionDirectory.toString());
        }
        if (this.replicationClockskewFast != environmentConfig.replicationClockskewFast || this.replicationClockskewSlow != environmentConfig.replicationClockskewSlow) {
            dbEnv.rep_set_clockskew(this.replicationClockskewFast, this.replicationClockskewSlow);
        }
        if (this.replicationLimit != environmentConfig.replicationLimit) {
            dbEnv.rep_set_limit(this.replicationLimit);
        }
        if (this.replicationRequestMin != environmentConfig.replicationRequestMin || this.replicationRequestMax != environmentConfig.replicationRequestMax) {
            dbEnv.rep_set_request(this.replicationRequestMin, this.replicationRequestMax);
        }
        if (this.segmentId != environmentConfig.segmentId) {
            dbEnv.set_shm_key(this.segmentId);
        }
        if (this.mutexAlignment != environmentConfig.mutexAlignment) {
            dbEnv.mutex_set_align(this.mutexAlignment);
        }
        if (this.mutexIncrement != environmentConfig.mutexIncrement) {
            dbEnv.mutex_set_increment(this.mutexIncrement);
        }
        if (this.initMutexes != environmentConfig.initMutexes) {
            dbEnv.mutex_set_max(this.initMutexes);
        }
        if (this.maxMutexes != environmentConfig.maxMutexes) {
            dbEnv.mutex_set_max(this.maxMutexes);
        }
        if (this.mutexTestAndSetSpins != environmentConfig.mutexTestAndSetSpins) {
            dbEnv.mutex_set_tas_spins(this.mutexTestAndSetSpins);
        }
        if (this.replicationNumSites != environmentConfig.replicationNumSites) {
            dbEnv.rep_set_nsites(this.replicationNumSites);
        }
        if (this.replicationPriority != environmentConfig.replicationPriority) {
            dbEnv.rep_set_priority(this.replicationPriority);
        }
        if (this.lockTimeout != environmentConfig.lockTimeout) {
            dbEnv.set_timeout(this.lockTimeout, 1);
        }
        if (this.txnMaxActive != environmentConfig.txnMaxActive) {
            dbEnv.set_tx_max(this.txnMaxActive);
        }
        if (this.txnTimeout != environmentConfig.txnTimeout) {
            dbEnv.set_timeout(this.txnTimeout, 2);
        }
        if (this.txnTimestamp != environmentConfig.txnTimestamp && this.txnTimestamp != null && !this.txnTimestamp.equals(environmentConfig.txnTimestamp)) {
            dbEnv.set_tx_timestamp(this.txnTimestamp);
        }
        if (this.temporaryDirectory != environmentConfig.temporaryDirectory && this.temporaryDirectory != null && !this.temporaryDirectory.equals(environmentConfig.temporaryDirectory)) {
            dbEnv.set_tmp_dir(this.temporaryDirectory.toString());
        }
        if (this.initResourceLocks != environmentConfig.initResourceLocks) {
            dbEnv.set_memory_init(1, this.initResourceLocks);
        }
        if (this.initResourceLockObjects != environmentConfig.initResourceLockObjects) {
            dbEnv.set_memory_init(2, this.initResourceLockObjects);
        }
        if (this.initResourceLockers != environmentConfig.initResourceLockers) {
            dbEnv.set_memory_init(3, this.initResourceLockers);
        }
        if (this.initResourceLogIds != environmentConfig.initResourceLogIds) {
            dbEnv.set_memory_init(4, this.initResourceLogIds);
        }
        if (this.initResourceTransactions != environmentConfig.initResourceTransactions) {
            dbEnv.set_memory_init(5, this.initResourceTransactions);
        }
        if (this.initResourceThreads != environmentConfig.initResourceThreads) {
            dbEnv.set_memory_init(6, this.initResourceThreads);
        }
        if (this.regionMemoryMax != environmentConfig.regionMemoryMax) {
            dbEnv.set_memory_max(this.regionMemoryMax);
        }
        if (this.replicationInMemory != environmentConfig.replicationInMemory) {
            dbEnv.rep_set_config(1024, this.replicationInMemory);
        }
        if (this.repmgrAckPolicy != environmentConfig.repmgrAckPolicy) {
            dbEnv.repmgr_set_ack_policy(this.repmgrAckPolicy.getId());
        }
        if (this.repmgrIncomingQueueMax != environmentConfig.repmgrIncomingQueueMax) {
            dbEnv.repmgr_set_incoming_queue_max(this.repmgrIncomingQueueMax);
        }
        object2 = this.repmgrSitesConfig.listIterator();
        object = environmentConfig.repmgrSitesConfig.listIterator();
        while (object2.hasNext()) {
            Object object3;
            ReplicationManagerSiteConfig replicationManagerSiteConfig = (ReplicationManagerSiteConfig)object2.next();
            Object object4 = null;
            while (object.hasNext()) {
                object3 = (ReplicationManagerSiteConfig)object.next();
                if (!replicationManagerSiteConfig.getAddress().equals(((ReplicationManagerSiteConfig)object3).getAddress())) continue;
                object4 = object3;
                break;
            }
            if (object4 == null) {
                object4 = new ReplicationManagerSiteConfig(replicationManagerSiteConfig.getHost(), replicationManagerSiteConfig.getPort());
            }
            if (object4.equals(replicationManagerSiteConfig)) continue;
            object3 = dbEnv.repmgr_site(replicationManagerSiteConfig.getHost(), replicationManagerSiteConfig.getPort());
            if (replicationManagerSiteConfig.getBootstrapHelper() != ((ReplicationManagerSiteConfig)object4).getBootstrapHelper()) {
                ((DbSite)object3).set_config(1, replicationManagerSiteConfig.getBootstrapHelper());
            }
            if (replicationManagerSiteConfig.getGroupCreator() != ((ReplicationManagerSiteConfig)object4).getGroupCreator()) {
                ((DbSite)object3).set_config(2, replicationManagerSiteConfig.getGroupCreator());
            }
            if (replicationManagerSiteConfig.getLegacy() != ((ReplicationManagerSiteConfig)object4).getLegacy()) {
                ((DbSite)object3).set_config(4, replicationManagerSiteConfig.getLegacy());
            }
            if (replicationManagerSiteConfig.getLocalSite() != ((ReplicationManagerSiteConfig)object4).getLocalSite()) {
                ((DbSite)object3).set_config(8, replicationManagerSiteConfig.getLocalSite());
            }
            if (replicationManagerSiteConfig.getPeer() != ((ReplicationManagerSiteConfig)object4).getPeer()) {
                ((DbSite)object3).set_config(16, replicationManagerSiteConfig.getPeer());
            }
            ((DbSite)object3).close();
        }
    }

    EnvironmentConfig(DbEnv dbEnv) throws DatabaseException {
        String[] stringArray;
        String string;
        int n = dbEnv.get_open_flags();
        this.allowCreate = (n & 1) != 0;
        this.initializeCache = (n & 0x400) != 0;
        this.initializeCDB = (n & 0x80) != 0;
        this.initializeLocking = (n & 0x100) != 0;
        this.initializeLogging = (n & 0x200) != 0;
        this.initializeReplication = (n & 0x1000) != 0;
        this.joinEnvironment = (n & 0) != 0;
        this.lockDown = (n & 0x4000) != 0;
        this.isPrivate = (n & 0x10000) != 0;
        this.register = (n & 0x40000) != 0;
        this.runRecovery = (n & 2) != 0;
        this.runFatalRecovery = (n & 0x20000) != 0;
        this.systemMemory = (n & 0x80000) != 0;
        this.threaded = (n & 0x20) != 0;
        this.transactional = (n & 0x2000) != 0;
        this.useEnvironment = (n & 4) != 0;
        this.useEnvironmentRoot = (n & 8) != 0;
        int n2 = dbEnv.get_flags();
        this.cdbLockAllDatabases = (n2 & 0x40) != 0;
        this.directDatabaseIO = (n2 & 0x200) != 0;
        this.dsyncDatabases = (n2 & 0x400) != 0;
        this.hotbackupInProgress = (n2 & 0x800) != 0;
        this.initializeRegions = (n2 & 0x20000) != 0;
        this.multiversion = (n2 & 8) != 0;
        this.noLocking = (n2 & 0x2000) != 0;
        this.noMMap = (n2 & 0x10) != 0;
        this.noPanic = (n2 & 0x4000) != 0;
        this.overwrite = (n2 & 0x8000) != 0;
        this.txnNoSync = (n2 & 1) != 0;
        this.txnNoWait = (n2 & 2) != 0;
        this.txnSnapshot = (n2 & 4) != 0;
        this.txnWriteNoSync = (n2 & 0x20) != 0;
        boolean bl = this.yieldCPU = (n2 & 0x80000) != 0;
        if (this.initializeLogging) {
            this.directLogIO = dbEnv.log_get_config(2);
            this.dsyncLog = dbEnv.log_get_config(4);
            this.logAutoRemove = dbEnv.log_get_config(1);
            this.logBlobContent = dbEnv.log_get_config(8);
            this.logInMemory = dbEnv.log_get_config(16);
            this.logNoSync = dbEnv.log_get_config(32);
            this.logZero = dbEnv.log_get_config(64);
        }
        this.verboseBackup = dbEnv.get_verbose(1);
        this.verboseDeadlock = dbEnv.get_verbose(2);
        this.verboseFileops = dbEnv.get_verbose(4);
        this.verboseFileopsAll = dbEnv.get_verbose(8);
        this.verboseRecovery = dbEnv.get_verbose(32);
        this.verboseRegister = dbEnv.get_verbose(64);
        this.verboseReplication = dbEnv.get_verbose(128);
        this.verboseReplicationElection = dbEnv.get_verbose(1024);
        this.verboseReplicationLease = dbEnv.get_verbose(2048);
        this.verboseReplicationMisc = dbEnv.get_verbose(4096);
        this.verboseReplicationMsgs = dbEnv.get_verbose(8192);
        this.verboseReplicationSync = dbEnv.get_verbose(16384);
        this.verboseReplicationSystem = dbEnv.get_verbose(32768);
        this.verboseReplicationTest = dbEnv.get_verbose(65536);
        this.verboseRepmgrConnfail = dbEnv.get_verbose(256);
        this.verboseRepmgrMisc = dbEnv.get_verbose(512);
        this.verboseSlice = dbEnv.get_verbose(131072);
        this.verboseWaitsFor = dbEnv.get_verbose(262144);
        this.errorHandler = dbEnv.get_errcall();
        this.feedbackHandler = dbEnv.get_feedback();
        this.logRecordHandler = dbEnv.get_app_dispatch();
        this.eventHandler = dbEnv.get_event_notify();
        this.messageHandler = dbEnv.get_msgcall();
        this.panicHandler = dbEnv.get_paniccall();
        this.backupHandler = dbEnv.get_backup_handler();
        this.backup_read_count = dbEnv.get_backup_config(1);
        this.backup_read_sleep = dbEnv.get_backup_config(2);
        this.backup_size = dbEnv.get_backup_config(3);
        this.write_direct = dbEnv.get_backup_config(4);
        this.backup_write_direct = this.write_direct == 1;
        String string2 = dbEnv.get_ext_file_dir();
        if (string2 != null) {
            this.blobDir = new File(string2);
        }
        this.blobThreshold = dbEnv.get_ext_file_threshold();
        if (this.initializeCache) {
            this.cacheSize = dbEnv.get_cachesize();
            this.cacheMax = dbEnv.get_cache_max();
            this.cacheCount = dbEnv.get_cachesize_ncache();
            this.mmapSize = dbEnv.get_mp_mmapsize();
            this.maxOpenFiles = dbEnv.get_mp_max_openfd();
            this.maxWrite = dbEnv.get_mp_max_write();
            this.maxWriteSleep = dbEnv.get_mp_max_write_sleep();
            this.mpPageSize = dbEnv.get_mp_pagesize();
            this.mpTableSize = dbEnv.get_mp_tablesize();
        }
        if ((string = dbEnv.get_create_dir()) != null) {
            this.createDir = new File(string);
        }
        if ((stringArray = dbEnv.get_data_dirs()) == null) {
            stringArray = new String[]{};
        }
        this.dataDirs = new Vector(stringArray.length);
        this.dataDirs.setSize(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.dataDirs.set(i, new File(stringArray[i]));
        }
        this.regionDirectory = dbEnv.get_region_dir() == null ? null : new File(dbEnv.get_region_dir());
        this.errorPrefix = dbEnv.get_errpfx();
        this.errorStream = dbEnv.get_error_stream();
        this.messagePrefix = dbEnv.get_msgpfx();
        this.messageStream = dbEnv.get_message_stream();
        if (this.initializeLocking) {
            this.lockConflicts = dbEnv.get_lk_conflicts();
            this.lockDetectMode = LockDetectMode.fromFlag(dbEnv.get_lk_detect());
            this.lockTableSize = dbEnv.get_lk_tablesize();
            this.lockTimeout = dbEnv.get_timeout(1);
            this.maxLocks = dbEnv.get_lk_max_locks();
            this.maxLockers = dbEnv.get_lk_max_lockers();
            this.maxLockObjects = dbEnv.get_lk_max_objects();
            this.partitionLocks = dbEnv.get_lk_partitions();
            this.txnTimeout = dbEnv.get_timeout(2);
        } else {
            this.lockConflicts = null;
            this.lockDetectMode = LockDetectMode.NONE;
            this.lockTableSize = 0;
            this.lockTimeout = 0L;
            this.maxLocks = 0;
            this.maxLockers = 0;
            this.maxLockObjects = 0;
            this.txnTimeout = 0L;
        }
        if (this.initializeLogging) {
            this.maxLogFileSize = dbEnv.get_lg_max();
            this.logBufferSize = dbEnv.get_lg_bsize();
            this.logDirectory = dbEnv.get_lg_dir() == null ? null : new File(dbEnv.get_lg_dir());
            this.logFileMode = dbEnv.get_lg_filemode();
            this.logRegionSize = dbEnv.get_lg_regionmax();
        } else {
            this.maxLogFileSize = 0;
            this.logBufferSize = 0;
            this.logDirectory = null;
            this.logRegionSize = 0;
        }
        this.messageStream = dbEnv.get_message_stream();
        if (this.msgfileStr != null) {
            this.msgfile = new File(this.msgfileStr);
        }
        String string3 = this.password = dbEnv.get_encrypt_flags() == 0 ? null : "";
        if (this.initializeLocking) {
            this.initResourceLocks = dbEnv.get_memory_init(1);
            this.initResourceLockObjects = dbEnv.get_memory_init(2);
            this.initResourceLockers = dbEnv.get_memory_init(3);
        }
        if (this.initializeLogging) {
            this.initResourceLogIds = dbEnv.get_memory_init(4);
        }
        if (this.transactional) {
            this.initResourceTransactions = dbEnv.get_memory_init(5);
        }
        this.initResourceThreads = dbEnv.get_memory_init(6);
        this.regionMemoryMax = dbEnv.get_memory_max();
        String string4 = dbEnv.get_metadata_dir();
        if (string4 != null) {
            this.metadataDir = new File(string4);
        }
        if (this.initializeReplication) {
            this.replicationClockskewFast = dbEnv.rep_get_clockskew_fast();
            this.replicationClockskewSlow = dbEnv.rep_get_clockskew_slow();
            this.replicationInMemory = dbEnv.rep_get_config(1024);
            this.replicationLimit = dbEnv.rep_get_limit();
            this.replicationNumSites = 0;
            this.replicationPriority = dbEnv.rep_get_priority();
            this.replicationRequestMin = dbEnv.rep_get_request_min();
            this.replicationRequestMax = dbEnv.rep_get_request_max();
            this.repmgrAckPolicy = ReplicationManagerAckPolicy.fromInt(dbEnv.repmgr_get_ack_policy());
            this.repmgrIncomingQueueMax = dbEnv.repmgr_get_incoming_queue_max();
        } else {
            this.replicationLimit = 0L;
            this.replicationRequestMin = 0;
            this.replicationRequestMax = 0;
            this.repmgrIncomingQueueMax = 0L;
        }
        this.segmentId = dbEnv.get_shm_key();
        this.mutexAlignment = dbEnv.mutex_get_align();
        this.mutexIncrement = dbEnv.mutex_get_increment();
        this.initMutexes = dbEnv.mutex_get_init();
        this.maxMutexes = dbEnv.mutex_get_max();
        this.mutexTestAndSetSpins = dbEnv.mutex_get_tas_spins();
        if (this.transactional) {
            this.txnMaxActive = dbEnv.get_tx_max();
            long l = dbEnv.get_tx_timestamp();
            this.txnTimestamp = l != 0L ? new Date(l * 1000L) : null;
        } else {
            this.txnMaxActive = 0;
            this.txnTimestamp = null;
        }
        this.temporaryDirectory = new File(dbEnv.get_tmp_dir());
    }
}

