/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist;

import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.LockMode;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.ForwardCursor;
import com.sleepycat.util.RuntimeExceptionWrapper;
import java.util.Iterator;
import java.util.NoSuchElementException;

class BasicIterator<V>
implements Iterator<V> {
    private EntityCursor<V> entityCursor;
    private ForwardCursor<V> forwardCursor;
    private LockMode lockMode;
    private V nextValue;

    BasicIterator(EntityCursor<V> entityCursor, LockMode lockMode) {
        this.entityCursor = entityCursor;
        this.forwardCursor = entityCursor;
        this.lockMode = lockMode;
    }

    BasicIterator(ForwardCursor<V> forwardCursor, LockMode lockMode) {
        this.forwardCursor = forwardCursor;
        this.lockMode = lockMode;
    }

    @Override
    public boolean hasNext() {
        if (this.nextValue == null) {
            try {
                this.nextValue = this.forwardCursor.next(this.lockMode);
            }
            catch (DatabaseException databaseException) {
                throw RuntimeExceptionWrapper.wrapIfNeeded(databaseException);
            }
            return this.nextValue != null;
        }
        return true;
    }

    @Override
    public V next() {
        if (this.hasNext()) {
            V v = this.nextValue;
            this.nextValue = null;
            return v;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        if (this.entityCursor == null) {
            throw new UnsupportedOperationException();
        }
        try {
            if (!this.entityCursor.delete()) {
                throw new IllegalStateException("Record at cursor position is already deleted");
            }
        }
        catch (DatabaseException databaseException) {
            throw RuntimeExceptionWrapper.wrapIfNeeded(databaseException);
        }
    }
}

