/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.bind.tuple.TupleBase;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.persist.impl.EnhancedAccessor;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.RecordInput;
import com.sleepycat.persist.impl.RecordOutput;
import com.sleepycat.persist.impl.RefreshException;
import com.sleepycat.persist.model.Persistent;
import com.sleepycat.persist.model.PersistentProxy;
import com.sleepycat.persist.raw.RawObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

@Persistent
abstract class CollectionProxy<E>
implements PersistentProxy<Collection<E>> {
    private E[] elements;

    protected CollectionProxy() {
    }

    @Override
    public final void initializeProxy(Collection<E> collection) {
        this.elements = new Object[collection.size()];
        int n = 0;
        for (E e : collection) {
            this.elements[n] = e;
            ++n;
        }
    }

    @Override
    public final Collection<E> convertProxy() {
        Collection<E> collection = this.newInstance(this.elements.length);
        for (E e : this.elements) {
            collection.add(e);
        }
        return collection;
    }

    protected abstract Collection<E> newInstance(int var1);

    static Object[] getElements(RawObject rawObject) {
        Object object;
        Object object2 = null;
        while (object2 == null && rawObject != null) {
            object = rawObject.getValues();
            if (object == null || (object2 = object.get("elements")) != null) continue;
            rawObject = rawObject.getSuper();
        }
        if (object2 == null || !(object2 instanceof RawObject)) {
            throw new IllegalStateException("Collection proxy for a secondary key field must contain a field named 'elements'");
        }
        object = (RawObject)object2;
        Format format = (Format)((RawObject)object).getType();
        if (!format.isArray() || format.getComponentType().getId() != 1) {
            throw new IllegalStateException("Collection proxy 'elements' field must be an Object array");
        }
        return ((RawObject)object).getElements();
    }

    static void setElements(RawObject rawObject, Object[] objectArray) {
        RawObject rawObject2 = null;
        while (rawObject2 == null && rawObject != null) {
            Map<String, Object> map = rawObject.getValues();
            if (map == null) continue;
            rawObject2 = (RawObject)map.get("elements");
            if (rawObject2 != null) {
                map.put("elements", new RawObject(rawObject2.getType(), objectArray));
                continue;
            }
            rawObject = rawObject.getSuper();
        }
        if (rawObject2 == null) {
            throw DbCompat.unexpectedState();
        }
    }

    static void copyElements(RecordInput recordInput, Format format, Format format2, Set set) throws RefreshException {
        RawObject rawObject = (RawObject)format.newInstance(recordInput, true);
        Object[] objectArray = CollectionProxy.getElements(rawObject = (RawObject)format.readObject(rawObject, recordInput, true));
        if (objectArray != null) {
            for (Object object : objectArray) {
                RecordOutput recordOutput = new RecordOutput(recordInput.getCatalog(), true);
                recordOutput.writeKeyObject(object, format2);
                DatabaseEntry databaseEntry = new DatabaseEntry();
                TupleBase.outputToEntry(recordOutput, databaseEntry);
                set.add(databaseEntry);
            }
        }
    }

    public Object bdbNewInstance() {
        return null;
    }

    public Object bdbNewArray(int n) {
        return null;
    }

    public boolean bdbIsPriKeyFieldNullOrZero() {
        return false;
    }

    public void bdbWritePriKeyField(EntityOutput entityOutput, Format format) {
    }

    public void bdbReadPriKeyField(EntityInput entityInput, Format format) {
    }

    public void bdbWriteSecKeyFields(EntityOutput entityOutput) {
    }

    public void bdbReadSecKeyFields(EntityInput entityInput, int n, int n2, int n3) {
    }

    public void bdbWriteNonKeyFields(EntityOutput entityOutput) {
        entityOutput.writeObject(this.elements, null);
    }

    public void bdbReadNonKeyFields(EntityInput entityInput, int n, int n2, int n3) {
        if (n3 <= 0) {
            switch (n) {
                case 0: {
                    this.elements = (Object[])entityInput.readObject();
                }
            }
        }
    }

    public void bdbWriteCompositeKeyFields(EntityOutput entityOutput, Format[] formatArray) {
    }

    public void bdbReadCompositeKeyFields(EntityInput entityInput, Format[] formatArray) {
    }

    public Object bdbGetField(Object object, int n, int n2, boolean bl) {
        if (n2 <= 0 && !bl) {
            switch (n) {
                case 0: {
                    return this.elements;
                }
            }
        }
        return null;
    }

    public void bdbSetField(Object object, int n, int n2, boolean bl, Object object2) {
        if (n2 > 0) {
            return;
        }
        if (!bl) {
            switch (n) {
                case 0: {
                    this.elements = (Object[])object2;
                    return;
                }
            }
        }
    }

    public void bdbSetPriField(Object object, Object object2) {
    }

    static {
        EnhancedAccessor.registerClass("com.sleepycat.persist.impl.CollectionProxy", null);
    }

    @Persistent(proxyFor=TreeSet.class)
    static class TreeSetProxy<E>
    extends CollectionProxy<E> {
        protected TreeSetProxy() {
        }

        @Override
        protected Collection<E> newInstance(int n) {
            return new TreeSet();
        }

        @Override
        public Object bdbNewInstance() {
            return new TreeSetProxy<E>();
        }

        @Override
        public Object bdbNewArray(int n) {
            return new TreeSetProxy[n];
        }

        @Override
        public boolean bdbIsPriKeyFieldNullOrZero() {
            return super.bdbIsPriKeyFieldNullOrZero();
        }

        @Override
        public void bdbWritePriKeyField(EntityOutput entityOutput, Format format) {
            super.bdbWritePriKeyField(entityOutput, format);
        }

        @Override
        public void bdbReadPriKeyField(EntityInput entityInput, Format format) {
            super.bdbReadPriKeyField(entityInput, format);
        }

        @Override
        public void bdbWriteSecKeyFields(EntityOutput entityOutput) {
            super.bdbWriteSecKeyFields(entityOutput);
        }

        @Override
        public void bdbReadSecKeyFields(EntityInput entityInput, int n, int n2, int n3) {
            if (n3 != 0) {
                super.bdbReadSecKeyFields(entityInput, n, n2, n3 - 1);
            }
        }

        @Override
        public void bdbWriteNonKeyFields(EntityOutput entityOutput) {
            super.bdbWriteNonKeyFields(entityOutput);
        }

        @Override
        public void bdbReadNonKeyFields(EntityInput entityInput, int n, int n2, int n3) {
            if (n3 != 0) {
                super.bdbReadNonKeyFields(entityInput, n, n2, n3 - 1);
            }
        }

        @Override
        public void bdbWriteCompositeKeyFields(EntityOutput entityOutput, Format[] formatArray) {
        }

        @Override
        public void bdbReadCompositeKeyFields(EntityInput entityInput, Format[] formatArray) {
        }

        @Override
        public Object bdbGetField(Object object, int n, int n2, boolean bl) {
            if (n2 > 0) {
                return this.bdbGetField(object, n, n2 - 1, bl);
            }
            if (bl) {
                // empty if block
            }
            return null;
        }

        @Override
        public void bdbSetField(Object object, int n, int n2, boolean bl, Object object2) {
            if (n2 > 0) {
                this.bdbSetField(object, n, n2 - 1, bl, object2);
                return;
            }
            if (bl) {
                // empty if block
            }
        }

        @Override
        public void bdbSetPriField(Object object, Object object2) {
            super.bdbSetPriField(object, object2);
        }

        static {
            EnhancedAccessor.registerClass("com.sleepycat.persist.impl.CollectionProxy$TreeSetProxy", new TreeSetProxy());
        }
    }

    @Persistent(proxyFor=HashSet.class)
    static class HashSetProxy<E>
    extends CollectionProxy<E> {
        protected HashSetProxy() {
        }

        @Override
        protected Collection<E> newInstance(int n) {
            return new HashSet(n);
        }

        @Override
        public Object bdbNewInstance() {
            return new HashSetProxy<E>();
        }

        @Override
        public Object bdbNewArray(int n) {
            return new HashSetProxy[n];
        }

        @Override
        public boolean bdbIsPriKeyFieldNullOrZero() {
            return super.bdbIsPriKeyFieldNullOrZero();
        }

        @Override
        public void bdbWritePriKeyField(EntityOutput entityOutput, Format format) {
            super.bdbWritePriKeyField(entityOutput, format);
        }

        @Override
        public void bdbReadPriKeyField(EntityInput entityInput, Format format) {
            super.bdbReadPriKeyField(entityInput, format);
        }

        @Override
        public void bdbWriteSecKeyFields(EntityOutput entityOutput) {
            super.bdbWriteSecKeyFields(entityOutput);
        }

        @Override
        public void bdbReadSecKeyFields(EntityInput entityInput, int n, int n2, int n3) {
            if (n3 != 0) {
                super.bdbReadSecKeyFields(entityInput, n, n2, n3 - 1);
            }
        }

        @Override
        public void bdbWriteNonKeyFields(EntityOutput entityOutput) {
            super.bdbWriteNonKeyFields(entityOutput);
        }

        @Override
        public void bdbReadNonKeyFields(EntityInput entityInput, int n, int n2, int n3) {
            if (n3 != 0) {
                super.bdbReadNonKeyFields(entityInput, n, n2, n3 - 1);
            }
        }

        @Override
        public void bdbWriteCompositeKeyFields(EntityOutput entityOutput, Format[] formatArray) {
        }

        @Override
        public void bdbReadCompositeKeyFields(EntityInput entityInput, Format[] formatArray) {
        }

        @Override
        public Object bdbGetField(Object object, int n, int n2, boolean bl) {
            if (n2 > 0) {
                return this.bdbGetField(object, n, n2 - 1, bl);
            }
            if (bl) {
                // empty if block
            }
            return null;
        }

        @Override
        public void bdbSetField(Object object, int n, int n2, boolean bl, Object object2) {
            if (n2 > 0) {
                this.bdbSetField(object, n, n2 - 1, bl, object2);
                return;
            }
            if (bl) {
                // empty if block
            }
        }

        @Override
        public void bdbSetPriField(Object object, Object object2) {
            super.bdbSetPriField(object, object2);
        }

        static {
            EnhancedAccessor.registerClass("com.sleepycat.persist.impl.CollectionProxy$HashSetProxy", new HashSetProxy());
        }
    }

    @Persistent(proxyFor=LinkedList.class)
    static class LinkedListProxy<E>
    extends CollectionProxy<E> {
        protected LinkedListProxy() {
        }

        @Override
        protected Collection<E> newInstance(int n) {
            return new LinkedList();
        }

        @Override
        public Object bdbNewInstance() {
            return new LinkedListProxy<E>();
        }

        @Override
        public Object bdbNewArray(int n) {
            return new LinkedListProxy[n];
        }

        @Override
        public boolean bdbIsPriKeyFieldNullOrZero() {
            return super.bdbIsPriKeyFieldNullOrZero();
        }

        @Override
        public void bdbWritePriKeyField(EntityOutput entityOutput, Format format) {
            super.bdbWritePriKeyField(entityOutput, format);
        }

        @Override
        public void bdbReadPriKeyField(EntityInput entityInput, Format format) {
            super.bdbReadPriKeyField(entityInput, format);
        }

        @Override
        public void bdbWriteSecKeyFields(EntityOutput entityOutput) {
            super.bdbWriteSecKeyFields(entityOutput);
        }

        @Override
        public void bdbReadSecKeyFields(EntityInput entityInput, int n, int n2, int n3) {
            if (n3 != 0) {
                super.bdbReadSecKeyFields(entityInput, n, n2, n3 - 1);
            }
        }

        @Override
        public void bdbWriteNonKeyFields(EntityOutput entityOutput) {
            super.bdbWriteNonKeyFields(entityOutput);
        }

        @Override
        public void bdbReadNonKeyFields(EntityInput entityInput, int n, int n2, int n3) {
            if (n3 != 0) {
                super.bdbReadNonKeyFields(entityInput, n, n2, n3 - 1);
            }
        }

        @Override
        public void bdbWriteCompositeKeyFields(EntityOutput entityOutput, Format[] formatArray) {
        }

        @Override
        public void bdbReadCompositeKeyFields(EntityInput entityInput, Format[] formatArray) {
        }

        @Override
        public Object bdbGetField(Object object, int n, int n2, boolean bl) {
            if (n2 > 0) {
                return this.bdbGetField(object, n, n2 - 1, bl);
            }
            if (bl) {
                // empty if block
            }
            return null;
        }

        @Override
        public void bdbSetField(Object object, int n, int n2, boolean bl, Object object2) {
            if (n2 > 0) {
                this.bdbSetField(object, n, n2 - 1, bl, object2);
                return;
            }
            if (bl) {
                // empty if block
            }
        }

        @Override
        public void bdbSetPriField(Object object, Object object2) {
            super.bdbSetPriField(object, object2);
        }

        static {
            EnhancedAccessor.registerClass("com.sleepycat.persist.impl.CollectionProxy$LinkedListProxy", new LinkedListProxy());
        }
    }

    @Persistent(proxyFor=ArrayList.class)
    static class ArrayListProxy<E>
    extends CollectionProxy<E> {
        protected ArrayListProxy() {
        }

        @Override
        protected Collection<E> newInstance(int n) {
            return new ArrayList(n);
        }

        @Override
        public Object bdbNewInstance() {
            return new ArrayListProxy<E>();
        }

        @Override
        public Object bdbNewArray(int n) {
            return new ArrayListProxy[n];
        }

        @Override
        public boolean bdbIsPriKeyFieldNullOrZero() {
            return super.bdbIsPriKeyFieldNullOrZero();
        }

        @Override
        public void bdbWritePriKeyField(EntityOutput entityOutput, Format format) {
            super.bdbWritePriKeyField(entityOutput, format);
        }

        @Override
        public void bdbReadPriKeyField(EntityInput entityInput, Format format) {
            super.bdbReadPriKeyField(entityInput, format);
        }

        @Override
        public void bdbWriteSecKeyFields(EntityOutput entityOutput) {
            super.bdbWriteSecKeyFields(entityOutput);
        }

        @Override
        public void bdbReadSecKeyFields(EntityInput entityInput, int n, int n2, int n3) {
            if (n3 != 0) {
                super.bdbReadSecKeyFields(entityInput, n, n2, n3 - 1);
            }
        }

        @Override
        public void bdbWriteNonKeyFields(EntityOutput entityOutput) {
            super.bdbWriteNonKeyFields(entityOutput);
        }

        @Override
        public void bdbReadNonKeyFields(EntityInput entityInput, int n, int n2, int n3) {
            if (n3 != 0) {
                super.bdbReadNonKeyFields(entityInput, n, n2, n3 - 1);
            }
        }

        @Override
        public void bdbWriteCompositeKeyFields(EntityOutput entityOutput, Format[] formatArray) {
        }

        @Override
        public void bdbReadCompositeKeyFields(EntityInput entityInput, Format[] formatArray) {
        }

        @Override
        public Object bdbGetField(Object object, int n, int n2, boolean bl) {
            if (n2 > 0) {
                return this.bdbGetField(object, n, n2 - 1, bl);
            }
            if (bl) {
                // empty if block
            }
            return null;
        }

        @Override
        public void bdbSetField(Object object, int n, int n2, boolean bl, Object object2) {
            if (n2 > 0) {
                this.bdbSetField(object, n, n2 - 1, bl, object2);
                return;
            }
            if (bl) {
                // empty if block
            }
        }

        @Override
        public void bdbSetPriField(Object object, Object object2) {
            super.bdbSetPriField(object, object2);
        }

        static {
            EnhancedAccessor.registerClass("com.sleepycat.persist.impl.CollectionProxy$ArrayListProxy", new ArrayListProxy());
        }
    }
}

