/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.compat.DbCompat;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.Evolver;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.KeyLocation;
import com.sleepycat.persist.impl.RawArrayInput;
import com.sleepycat.persist.impl.RecordInput;
import com.sleepycat.persist.impl.RefreshException;
import com.sleepycat.persist.model.EntityModel;
import com.sleepycat.persist.raw.RawObject;
import com.sleepycat.persist.raw.RawType;
import java.lang.reflect.Array;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public class ObjectArrayFormat
extends Format {
    private static final long serialVersionUID = 4317004346690441892L;
    private Format componentFormat;
    private int nDimensions;
    private transient Format useComponentFormat;

    ObjectArrayFormat(Catalog catalog, Class clazz) {
        super(catalog, clazz);
        String string = this.getClassName();
        this.nDimensions = 0;
        while (string.charAt(this.nDimensions) == '[') {
            ++this.nDimensions;
        }
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public int getDimensions() {
        return this.nDimensions;
    }

    @Override
    public Format getComponentType() {
        return this.useComponentFormat != null ? this.useComponentFormat : this.componentFormat;
    }

    @Override
    void collectRelatedFormats(Catalog catalog, Map<String, Format> map) {
        Class<?> clazz = this.getType().getComponentType();
        catalog.createFormat(clazz, map);
    }

    @Override
    void initialize(Catalog catalog, EntityModel entityModel, int n) {
        if (this.componentFormat == null) {
            Class<?> clazz = this.getType().getComponentType();
            this.componentFormat = catalog.getFormat(clazz.getName());
        }
        this.useComponentFormat = this.componentFormat.getLatestVersion();
    }

    @Override
    boolean isAssignableTo(Format format) {
        if (super.isAssignableTo(format)) {
            return true;
        }
        if (format instanceof ObjectArrayFormat) {
            ObjectArrayFormat objectArrayFormat = (ObjectArrayFormat)format;
            if (this.useComponentFormat.isAssignableTo(objectArrayFormat.useComponentFormat)) {
                return true;
            }
        }
        return false;
    }

    @Override
    Object newArray(int n) {
        return Array.newInstance(this.getType(), n);
    }

    @Override
    public Object newInstance(EntityInput entityInput, boolean bl) {
        int n = entityInput.readArrayLength();
        if (bl) {
            return new RawObject((RawType)this, new Object[n]);
        }
        return this.useComponentFormat.newArray(n);
    }

    @Override
    public Object readObject(Object object, EntityInput entityInput, boolean bl) throws RefreshException {
        Object[] objectArray = bl ? ((RawObject)object).getElements() : (Object[])object;
        if (this.useComponentFormat.getId() == 18) {
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = entityInput.readStringObject();
            }
        } else {
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = entityInput.readObject();
            }
        }
        return object;
    }

    @Override
    void writeObject(Object object, EntityOutput entityOutput, boolean bl) throws RefreshException {
        Object[] objectArray = bl ? ((RawObject)object).getElements() : (Object[])object;
        entityOutput.writeArrayLength(objectArray.length);
        if (this.useComponentFormat.getId() == 18) {
            for (int i = 0; i < objectArray.length; ++i) {
                entityOutput.writeString((String)objectArray[i]);
            }
        } else {
            for (int i = 0; i < objectArray.length; ++i) {
                entityOutput.writeObject(objectArray[i], this.useComponentFormat);
            }
        }
    }

    @Override
    Object convertRawObject(Catalog catalog, boolean bl, RawObject rawObject, IdentityHashMap identityHashMap) throws RefreshException {
        RawArrayInput rawArrayInput = new RawArrayInput(catalog, bl, identityHashMap, rawObject, this.useComponentFormat);
        Object object = this.newInstance(rawArrayInput, bl);
        identityHashMap.put(rawObject, object);
        return this.readObject(object, rawArrayInput, bl);
    }

    @Override
    void skipContents(RecordInput recordInput) throws RefreshException {
        int n = recordInput.readPackedInt();
        for (int i = 0; i < n; ++i) {
            recordInput.skipField(this.useComponentFormat);
        }
    }

    @Override
    void copySecMultiKey(RecordInput recordInput, Format format, Set set) throws RefreshException {
        int n = recordInput.readPackedInt();
        for (int i = 0; i < n; ++i) {
            KeyLocation keyLocation = recordInput.getKeyLocation(this.useComponentFormat);
            if (keyLocation == null) {
                throw new IllegalArgumentException("Secondary key values in array may not be null");
            }
            if (keyLocation.format != this.useComponentFormat) {
                throw DbCompat.unexpectedState(this.useComponentFormat.getClassName());
            }
            int n2 = keyLocation.input.getBufferOffset();
            this.useComponentFormat.skipContents(keyLocation.input);
            int n3 = keyLocation.input.getBufferOffset();
            DatabaseEntry databaseEntry = new DatabaseEntry(keyLocation.input.getBufferBytes(), n2, n3 - n2);
            set.add(databaseEntry);
        }
    }

    @Override
    boolean evolve(Format format, Evolver evolver) {
        Format format2 = this.componentFormat.getLatestVersion();
        if (format2 != this.componentFormat && !format2.getClassName().equals(this.componentFormat.getClassName())) {
            evolver.useEvolvedFormat(this, format, format);
        } else {
            evolver.useOldFormat(this, format);
        }
        return true;
    }
}

