/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.bind.tuple.TupleBase;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.ForeignMultiKeyNullifier;
import com.sleepycat.db.SecondaryDatabase;
import com.sleepycat.db.SecondaryKeyCreator;
import com.sleepycat.db.SecondaryMultiKeyCreator;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.KeyLocation;
import com.sleepycat.persist.impl.PersistCatalog;
import com.sleepycat.persist.impl.PersistEntityBinding;
import com.sleepycat.persist.impl.PersistKeyBinding;
import com.sleepycat.persist.impl.RecordInput;
import com.sleepycat.persist.impl.RecordOutput;
import com.sleepycat.persist.impl.RefreshException;
import com.sleepycat.persist.model.EntityMetadata;
import com.sleepycat.persist.model.Relationship;
import com.sleepycat.persist.model.SecondaryKeyMetadata;
import com.sleepycat.persist.raw.RawObject;
import java.util.Collection;
import java.util.Set;

public class PersistKeyCreator
implements SecondaryKeyCreator,
SecondaryMultiKeyCreator,
ForeignMultiKeyNullifier {
    private volatile Catalog catalog;
    private volatile Format priKeyFormat;
    private final String keyName;
    private volatile Format keyFormat;
    private final boolean toMany;

    static boolean isManyType(Class clazz) {
        return clazz.isArray() || Collection.class.isAssignableFrom(clazz);
    }

    public PersistKeyCreator(Catalog catalog, EntityMetadata entityMetadata, String string, SecondaryKeyMetadata secondaryKeyMetadata, boolean bl) {
        this.catalog = catalog;
        try {
            this.getFormats(entityMetadata, string, secondaryKeyMetadata, bl);
        }
        catch (RefreshException refreshException) {
            this.catalog = refreshException.refresh();
            try {
                this.getFormats(entityMetadata, string, secondaryKeyMetadata, bl);
            }
            catch (RefreshException refreshException2) {
                throw DbCompat.unexpectedException(refreshException2);
            }
        }
        this.keyName = secondaryKeyMetadata.getKeyName();
        Relationship relationship = secondaryKeyMetadata.getRelationship();
        this.toMany = relationship == Relationship.ONE_TO_MANY || relationship == Relationship.MANY_TO_MANY;
    }

    private void getFormats(EntityMetadata entityMetadata, String string, SecondaryKeyMetadata secondaryKeyMetadata, boolean bl) throws RefreshException {
        this.priKeyFormat = PersistEntityBinding.getOrCreateFormat(this.catalog, entityMetadata.getPrimaryKey().getClassName(), bl);
        this.keyFormat = PersistEntityBinding.getOrCreateFormat(this.catalog, string, bl);
        if (this.keyFormat == null) {
            throw new IllegalArgumentException("Not a key class: " + string);
        }
        if (this.keyFormat.isPrimitive()) {
            throw new IllegalArgumentException("Use a primitive wrapper class instead of class: " + this.keyFormat.getClassName());
        }
    }

    @Override
    public boolean createSecondaryKey(SecondaryDatabase secondaryDatabase, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3) {
        try {
            return this.createSecondaryKeyInternal(secondaryDatabase, databaseEntry, databaseEntry2, databaseEntry3);
        }
        catch (RefreshException refreshException) {
            refreshException.refresh();
            try {
                return this.createSecondaryKeyInternal(secondaryDatabase, databaseEntry, databaseEntry2, databaseEntry3);
            }
            catch (RefreshException refreshException2) {
                throw DbCompat.unexpectedException(refreshException2);
            }
        }
    }

    private boolean createSecondaryKeyInternal(SecondaryDatabase secondaryDatabase, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3) throws RefreshException {
        if (this.toMany) {
            throw DbCompat.unexpectedState();
        }
        KeyLocation keyLocation = this.moveToKey(databaseEntry, databaseEntry2);
        if (keyLocation != null) {
            RecordOutput recordOutput = new RecordOutput(this.catalog, true);
            keyLocation.format.copySecKey(keyLocation.input, recordOutput);
            TupleBase.outputToEntry(recordOutput, databaseEntry3);
            return true;
        }
        return false;
    }

    @Override
    public void createSecondaryKeys(SecondaryDatabase secondaryDatabase, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, Set set) {
        try {
            this.createSecondaryKeysInternal(secondaryDatabase, databaseEntry, databaseEntry2, set);
        }
        catch (RefreshException refreshException) {
            refreshException.refresh();
            try {
                this.createSecondaryKeysInternal(secondaryDatabase, databaseEntry, databaseEntry2, set);
            }
            catch (RefreshException refreshException2) {
                throw DbCompat.unexpectedException(refreshException2);
            }
        }
    }

    private void createSecondaryKeysInternal(SecondaryDatabase secondaryDatabase, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, Set set) throws RefreshException {
        if (!this.toMany) {
            throw DbCompat.unexpectedState();
        }
        KeyLocation keyLocation = this.moveToKey(databaseEntry, databaseEntry2);
        if (keyLocation != null) {
            keyLocation.format.copySecMultiKey(keyLocation.input, this.keyFormat, set);
        }
    }

    @Override
    public boolean nullifyForeignKey(SecondaryDatabase secondaryDatabase, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3) {
        try {
            return this.nullifyForeignKeyInternal(secondaryDatabase, databaseEntry, databaseEntry2, databaseEntry3);
        }
        catch (RefreshException refreshException) {
            refreshException.refresh();
            try {
                return this.nullifyForeignKeyInternal(secondaryDatabase, databaseEntry, databaseEntry2, databaseEntry3);
            }
            catch (RefreshException refreshException2) {
                throw DbCompat.unexpectedException(refreshException2);
            }
        }
    }

    private boolean nullifyForeignKeyInternal(SecondaryDatabase secondaryDatabase, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3) throws RefreshException {
        RawObject rawObject = (RawObject)PersistEntityBinding.readEntity(this.catalog, databaseEntry, null, databaseEntry2, true);
        Format format = (Format)rawObject.getType();
        Object object = null;
        if (this.toMany) {
            object = PersistKeyBinding.readKey(this.keyFormat, this.catalog, databaseEntry3.getData(), databaseEntry3.getOffset(), databaseEntry3.getSize(), true);
        }
        if (format.nullifySecKey(this.catalog, rawObject, this.keyName, object)) {
            PersistEntityBinding.writeEntity(format, this.catalog, rawObject, databaseEntry2, true);
            return true;
        }
        return false;
    }

    private KeyLocation moveToKey(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws RefreshException {
        RecordInput recordInput = new RecordInput(this.catalog, true, databaseEntry, this.priKeyFormat.getId(), databaseEntry2.getData(), databaseEntry2.getOffset(), databaseEntry2.getSize());
        int n = recordInput.readPackedInt();
        Format format = this.catalog.getFormat(n, true);
        recordInput.registerEntityFormat(format);
        Format format2 = format.skipToSecKey(recordInput, this.keyName);
        if (format2 != null) {
            return recordInput.getKeyLocation(format2);
        }
        return null;
    }

    void refresh(PersistCatalog persistCatalog) {
        this.catalog = persistCatalog;
        this.keyFormat = this.catalog.getFormat(this.keyFormat.getClassName());
        this.priKeyFormat = this.catalog.getFormat(this.priKeyFormat.getClassName());
    }
}

