/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.db.DatabaseEntry;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigIntegerBinding
extends TupleBinding<BigInteger> {
    @Override
    public BigInteger entryToObject(TupleInput tupleInput) {
        return tupleInput.readBigInteger();
    }

    @Override
    public void objectToEntry(BigInteger bigInteger, TupleOutput tupleOutput) {
        tupleOutput.writeBigInteger(bigInteger);
    }

    @Override
    protected TupleOutput getTupleOutput(BigInteger bigInteger) {
        return BigIntegerBinding.sizedOutput(bigInteger);
    }

    public static BigInteger entryToBigInteger(DatabaseEntry databaseEntry) {
        return BigIntegerBinding.entryToInput(databaseEntry).readBigInteger();
    }

    public static void bigIntegerToEntry(BigInteger bigInteger, DatabaseEntry databaseEntry) {
        BigIntegerBinding.outputToEntry(BigIntegerBinding.sizedOutput(bigInteger).writeBigInteger(bigInteger), databaseEntry);
    }

    private static TupleOutput sizedOutput(BigInteger bigInteger) {
        int n = TupleOutput.getBigIntegerByteLength(bigInteger);
        return new TupleOutput(new byte[n]);
    }
}

