/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.db.DatabaseEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackedIntegerBinding
extends TupleBinding<Integer> {
    @Override
    public Integer entryToObject(TupleInput tupleInput) {
        return tupleInput.readPackedInt();
    }

    @Override
    public void objectToEntry(Integer n, TupleOutput tupleOutput) {
        tupleOutput.writePackedInt(n);
    }

    @Override
    protected TupleOutput getTupleOutput(Integer n) {
        return PackedIntegerBinding.sizedOutput();
    }

    public static int entryToInt(DatabaseEntry databaseEntry) {
        return PackedIntegerBinding.entryToInput(databaseEntry).readPackedInt();
    }

    public static void intToEntry(int n, DatabaseEntry databaseEntry) {
        PackedIntegerBinding.outputToEntry(PackedIntegerBinding.sizedOutput().writePackedInt(n), databaseEntry);
    }

    private static TupleOutput sizedOutput() {
        return new TupleOutput(new byte[5]);
    }
}

