/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.compat;

import com.sleepycat.db.Cursor;
import com.sleepycat.db.CursorConfig;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseConfig;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.DatabaseType;
import com.sleepycat.db.Environment;
import com.sleepycat.db.EnvironmentConfig;
import com.sleepycat.db.ErrorHandler;
import com.sleepycat.db.LockDetectMode;
import com.sleepycat.db.LockMode;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.db.SecondaryConfig;
import com.sleepycat.db.SecondaryCursor;
import com.sleepycat.db.SecondaryDatabase;
import com.sleepycat.db.Transaction;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Comparator;
import java.util.regex.Pattern;

public class DbCompat {
    public static final boolean CDB = true;
    public static final boolean JOIN = true;
    public static final boolean NESTED_TRANSACTIONS = true;
    public static final boolean INSERTION_ORDERED_DUPLICATES = true;
    public static final boolean SEPARATE_DATABASE_FILES = true;
    public static final boolean MEMORY_SUBSYSTEM = true;
    public static final boolean LOCK_SUBSYSTEM = true;
    public static final boolean HASH_METHOD = true;
    public static final boolean RECNO_METHOD = true;
    public static final boolean QUEUE_METHOD = true;
    public static final boolean BTREE_RECNUM_METHOD = true;
    public static final boolean OPTIONAL_READ_UNCOMMITTED = true;
    public static final boolean SECONDARIES = true;
    public static boolean TRANSACTION_RUNNER_PRINT_STACK_TRACES = true;
    public static final boolean DATABASE_COUNT = false;
    public static final boolean NEW_JE_EXCEPTIONS = false;
    public static final boolean POPULATE_ENFORCES_CONSTRAINTS = false;
    private static boolean fSystemCaseSensitive = true;

    public static ClassLoader getClassLoader(Environment environment) {
        return null;
    }

    public static boolean getInitializeCache(EnvironmentConfig environmentConfig) {
        return environmentConfig.getInitializeCache();
    }

    public static boolean getInitializeLocking(EnvironmentConfig environmentConfig) {
        return environmentConfig.getInitializeLocking();
    }

    public static boolean getInitializeCDB(EnvironmentConfig environmentConfig) {
        return environmentConfig.getInitializeCDB();
    }

    public static boolean isTypeBtree(DatabaseConfig databaseConfig) {
        return databaseConfig.getType() == DatabaseType.BTREE;
    }

    public static boolean isTypeHash(DatabaseConfig databaseConfig) {
        return databaseConfig.getType() == DatabaseType.HASH;
    }

    public static boolean isTypeQueue(DatabaseConfig databaseConfig) {
        return databaseConfig.getType() == DatabaseType.QUEUE;
    }

    public static boolean isTypeRecno(DatabaseConfig databaseConfig) {
        return databaseConfig.getType() == DatabaseType.RECNO;
    }

    public static boolean getBtreeRecordNumbers(DatabaseConfig databaseConfig) {
        return databaseConfig.getBtreeRecordNumbers();
    }

    public static boolean getReadUncommitted(DatabaseConfig databaseConfig) {
        return databaseConfig.getReadUncommitted();
    }

    public static boolean getRenumbering(DatabaseConfig databaseConfig) {
        return databaseConfig.getRenumbering();
    }

    public static boolean getSortedDuplicates(DatabaseConfig databaseConfig) {
        return databaseConfig.getSortedDuplicates();
    }

    public static boolean getUnsortedDuplicates(DatabaseConfig databaseConfig) {
        return databaseConfig.getUnsortedDuplicates();
    }

    public static boolean getDeferredWrite(DatabaseConfig databaseConfig) {
        return false;
    }

    public static CursorConfig cloneCursorConfig(CursorConfig cursorConfig) {
        CursorConfig cursorConfig2 = new CursorConfig();
        cursorConfig2.setReadCommitted(cursorConfig.getReadCommitted());
        cursorConfig2.setReadUncommitted(cursorConfig.getReadUncommitted());
        cursorConfig2.setWriteCursor(cursorConfig.getWriteCursor());
        return cursorConfig2;
    }

    public static boolean getWriteCursor(CursorConfig cursorConfig) {
        return cursorConfig.getWriteCursor();
    }

    public static void setWriteCursor(CursorConfig cursorConfig, boolean bl) {
        cursorConfig.setWriteCursor(bl);
    }

    public static void setRecordNumber(DatabaseEntry databaseEntry, int n) {
        databaseEntry.setRecordNumber(n);
    }

    public static int getRecordNumber(DatabaseEntry databaseEntry) {
        return databaseEntry.getRecordNumber();
    }

    public static String getDatabaseFile(Database database) throws DatabaseException {
        return database.getDatabaseFile();
    }

    public static long getDatabaseCount(Database database) throws DatabaseException {
        throw new UnsupportedOperationException();
    }

    public static void syncDeferredWrite(Database database, boolean bl) throws DatabaseException {
    }

    public static OperationStatus getCurrentRecordNumber(Cursor cursor, DatabaseEntry databaseEntry, LockMode lockMode) throws DatabaseException {
        return cursor.getRecordNumber(databaseEntry, lockMode);
    }

    public static OperationStatus getSearchRecordNumber(Cursor cursor, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, LockMode lockMode) throws DatabaseException {
        return cursor.getSearchRecordNumber(databaseEntry, databaseEntry2, lockMode);
    }

    public static OperationStatus getSearchRecordNumber(SecondaryCursor secondaryCursor, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, LockMode lockMode) throws DatabaseException {
        return secondaryCursor.getSearchRecordNumber(databaseEntry, databaseEntry2, databaseEntry3, lockMode);
    }

    public static OperationStatus putAfter(Cursor cursor, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws DatabaseException {
        return cursor.putAfter(databaseEntry, databaseEntry2);
    }

    public static OperationStatus putBefore(Cursor cursor, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws DatabaseException {
        return cursor.putBefore(databaseEntry, databaseEntry2);
    }

    public static OperationStatus append(Database database, Transaction transaction, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws DatabaseException {
        return database.append(transaction, databaseEntry, databaseEntry2);
    }

    public static Transaction getThreadTransaction(Environment environment) throws DatabaseException {
        return null;
    }

    public static void setInitializeCache(EnvironmentConfig environmentConfig, boolean bl) {
        environmentConfig.setInitializeCache(bl);
    }

    public static void setInitializeLocking(EnvironmentConfig environmentConfig, boolean bl) {
        environmentConfig.setInitializeLocking(bl);
    }

    public static void setInitializeCDB(EnvironmentConfig environmentConfig, boolean bl) {
        environmentConfig.setInitializeCDB(bl);
    }

    public static void setLockDetectModeOldest(EnvironmentConfig environmentConfig) {
        environmentConfig.setLockDetectMode(LockDetectMode.OLDEST);
    }

    public static void setBtreeComparator(DatabaseConfig databaseConfig, Comparator comparator) {
        databaseConfig.setBtreeComparator(comparator);
    }

    public static void setTypeBtree(DatabaseConfig databaseConfig) {
        databaseConfig.setType(DatabaseType.BTREE);
    }

    public static void setTypeHash(DatabaseConfig databaseConfig) {
        databaseConfig.setType(DatabaseType.HASH);
    }

    public static void setTypeRecno(DatabaseConfig databaseConfig) {
        databaseConfig.setType(DatabaseType.RECNO);
    }

    public static void setTypeQueue(DatabaseConfig databaseConfig) {
        databaseConfig.setType(DatabaseType.QUEUE);
    }

    public static void setBtreeRecordNumbers(DatabaseConfig databaseConfig, boolean bl) {
        databaseConfig.setBtreeRecordNumbers(bl);
    }

    public static void setReadUncommitted(DatabaseConfig databaseConfig, boolean bl) {
        databaseConfig.setReadUncommitted(bl);
    }

    public static void setRenumbering(DatabaseConfig databaseConfig, boolean bl) {
        databaseConfig.setRenumbering(bl);
    }

    public static void setSortedDuplicates(DatabaseConfig databaseConfig, boolean bl) {
        databaseConfig.setSortedDuplicates(bl);
    }

    public static void setUnsortedDuplicates(DatabaseConfig databaseConfig, boolean bl) {
        databaseConfig.setUnsortedDuplicates(bl);
    }

    public static void setDeferredWrite(DatabaseConfig databaseConfig, boolean bl) {
    }

    public static void setRecordLength(DatabaseConfig databaseConfig, int n) {
        databaseConfig.setRecordLength(n);
    }

    public static void setRecordPad(DatabaseConfig databaseConfig, int n) {
        databaseConfig.setRecordPad(n);
    }

    public static boolean databaseExists(Environment environment, String string, String string2) {
        assert (string != null);
        assert (string2 == null);
        try {
            Database database = environment.openDatabase(null, string, string2, null);
            database.close();
            return true;
        }
        catch (DatabaseException databaseException) {
            throw new RuntimeException(databaseException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
    }

    public static Database openDatabase(Environment environment, Transaction transaction, String string, String string2, DatabaseConfig databaseConfig) throws DatabaseException {
        assert (string != null);
        assert (string2 == null);
        try {
            return environment.openDatabase(transaction, string, string2, databaseConfig);
        }
        catch (DatabaseException databaseException) {
            if (DbCompat.isFileExistsError(databaseException)) {
                return null;
            }
            throw databaseException;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public static SecondaryDatabase openSecondaryDatabase(Environment environment, Transaction transaction, String string, String string2, Database database, SecondaryConfig secondaryConfig) throws DatabaseException {
        assert (string != null);
        assert (string2 == null);
        try {
            return environment.openSecondaryDatabase(transaction, string, string2, database, secondaryConfig);
        }
        catch (DatabaseException databaseException) {
            if (DbCompat.isFileExistsError(databaseException)) {
                return null;
            }
            throw databaseException;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean truncateDatabase(Environment environment, Transaction transaction, String string, String string2) throws DatabaseException {
        Database database;
        assert (string != null);
        assert (string2 == null);
        try {
            database = environment.openDatabase(transaction, string, string2, null);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        try {
            database.truncate(transaction, false);
            boolean bl = true;
            return bl;
        }
        finally {
            database.close();
        }
    }

    public static boolean removeDatabase(Environment environment, Transaction transaction, String string, String string2) throws DatabaseException {
        assert (string != null);
        assert (string2 == null);
        try {
            environment.removeDatabase(transaction, string, string2);
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
    }

    public static boolean renameDatabase(Environment environment, Transaction transaction, String string, String string2, String string3, String string4) throws DatabaseException {
        assert (string != null);
        assert (string3 != null);
        assert (string2 == null);
        assert (string4 == null);
        try {
            File file = new File(string);
            File file2 = new File(string3);
            if (!file.equals(file2)) {
                environment.renameDatabase(transaction, string, null, string3);
            }
            if (string2 != null && !string2.equals(string4)) {
                environment.renameDatabase(transaction, string3, string2, string4);
            }
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
    }

    public static Database testOpenDatabase(Environment environment, Transaction transaction, String string, String string2, DatabaseConfig databaseConfig) throws DatabaseException {
        assert (string != null);
        assert (string2 == null);
        try {
            return environment.openDatabase(transaction, string, string2, databaseConfig);
        }
        catch (DatabaseException databaseException) {
            if (DbCompat.isFileExistsError(databaseException)) {
                assert (false);
                return null;
            }
            throw databaseException;
        }
        catch (FileNotFoundException fileNotFoundException) {
            assert (false);
            return null;
        }
    }

    public static SecondaryDatabase testOpenSecondaryDatabase(Environment environment, Transaction transaction, String string, String string2, Database database, SecondaryConfig secondaryConfig) throws DatabaseException {
        assert (string != null);
        assert (string2 == null);
        try {
            return environment.openSecondaryDatabase(transaction, string, string2, database, secondaryConfig);
        }
        catch (DatabaseException databaseException) {
            if (DbCompat.isFileExistsError(databaseException)) {
                assert (false);
                return null;
            }
            throw databaseException;
        }
        catch (FileNotFoundException fileNotFoundException) {
            assert (false);
            return null;
        }
    }

    private static boolean isFileExistsError(DatabaseException databaseException) {
        return databaseException.getMessage().contains("File exists") || databaseException.getMessage().contains("Do not specify an existing file");
    }

    public static boolean isDalvik() {
        return false;
    }

    public static boolean setImportunate(Transaction transaction, boolean bl) {
        return false;
    }

    public static RuntimeException unexpectedException(Exception exception) {
        if (!(exception instanceof DatabaseException)) {
            exception = new DatabaseException(exception);
        }
        throw new RuntimeException(new DatabaseException(exception));
    }

    public static RuntimeException unexpectedException(String string, Exception exception) {
        if (!(exception instanceof DatabaseException)) {
            exception = new DatabaseException(exception);
        }
        throw new RuntimeException(new DatabaseException(exception));
    }

    public static RuntimeException unexpectedState(String string) {
        throw new RuntimeException(new DatabaseException(string));
    }

    public static RuntimeException unexpectedState() {
        throw new RuntimeException();
    }

    public static boolean hasCaseInsensitiveOnDiskDbFile() {
        return !fSystemCaseSensitive;
    }

    public static void enableDeadlockDetection(EnvironmentConfig environmentConfig, boolean bl) {
        if (bl) {
            environmentConfig.setCDBLockAllDatabases(true);
        } else {
            environmentConfig.setLockDetectMode(LockDetectMode.MAXWRITE);
        }
    }

    public static Object getErrorHandler(Environment environment) throws DatabaseException {
        return environment.getConfig().getErrorHandler();
    }

    public static void setErrorHandler(Environment environment, Object object) throws DatabaseException {
        EnvironmentConfig environmentConfig = environment.getConfig();
        environmentConfig.setErrorHandler((ErrorHandler)object);
        environment.setConfig(environmentConfig);
    }

    public static void suppressError(Environment environment, final Pattern pattern) throws DatabaseException {
        if (pattern != null) {
            final EnvironmentConfig environmentConfig = environment.getConfig();
            ErrorHandler errorHandler = new ErrorHandler(){

                public void error(Environment environment, String string, String string2) {
                    if (!pattern.matcher(string2).matches()) {
                        try {
                            environmentConfig.getErrorStream().write(string2.getBytes());
                            environmentConfig.getErrorStream().write("\n".getBytes());
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                }
            };
            environmentConfig.setErrorHandler(errorHandler);
            environment.setConfig(environmentConfig);
        }
    }

    static {
        File file = new File("no_such_file");
        File file2 = new File("NO_SUCH_FILE");
        fSystemCaseSensitive = !file.equals(file2);
    }

    public static class OpWriteOptions {
        public static final OpWriteOptions EMPTY = new OpWriteOptions();

        private OpWriteOptions() {
        }
    }

    public static class OpReadOptions {
        public static final OpReadOptions EMPTY = new OpReadOptions(null);
        private LockMode lockMode;

        private OpReadOptions(LockMode lockMode) {
            this.lockMode = lockMode;
        }

        public LockMode getLockMode() {
            return this.lockMode;
        }

        public static OpReadOptions make(LockMode lockMode) {
            return lockMode != null ? new OpReadOptions(lockMode) : EMPTY;
        }
    }

    public static class OpResult {
        public static final OpResult SUCCESS = new OpResult(OperationStatus.SUCCESS);
        public static final OpResult FAILURE = new OpResult(OperationStatus.NOTFOUND);
        private OperationStatus status;

        private OpResult(OperationStatus operationStatus) {
            this.status = operationStatus;
        }

        public boolean isSuccess() {
            return this == SUCCESS;
        }

        public OperationStatus status() {
            return this.status;
        }

        public static OpResult make(OperationStatus operationStatus) {
            return operationStatus == OperationStatus.SUCCESS ? SUCCESS : FAILURE;
        }
    }
}

