/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.internal.DbUtil;
import java.nio.ByteBuffer;

public class DatabaseEntry {
    byte[] data;
    ByteBuffer data_nio;
    int dlen = 0;
    int doff = 0;
    int flags = 0;
    int offset = 0;
    int size = 0;
    int ulen = 0;
    static final DatabaseEntry IGNORE = new DatabaseEntry();
    static final DatabaseEntry UNUSED;
    static final int INT32SZ = 4;

    public DatabaseEntry() {
    }

    public DatabaseEntry(byte[] byArray) {
        this.data = byArray;
        if (byArray != null) {
            this.size = byArray.length;
        }
        this.data_nio = null;
    }

    public DatabaseEntry(byte[] byArray, int n, int n2) {
        this.data = byArray;
        this.offset = n;
        this.size = n2;
        this.data_nio = null;
    }

    public DatabaseEntry(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            this.data = null;
            this.data_nio = null;
        } else if (byteBuffer.isDirect()) {
            this.data = null;
            this.data_nio = byteBuffer;
            this.offset = byteBuffer.position();
            this.size = byteBuffer.limit() - byteBuffer.position();
            this.setUserBuffer(byteBuffer.capacity() - byteBuffer.position(), true);
        } else if (byteBuffer.hasArray()) {
            this.data = byteBuffer.array();
            this.offset = byteBuffer.arrayOffset() + byteBuffer.position();
            this.size = byteBuffer.limit() - byteBuffer.position();
            this.data_nio = null;
        } else {
            throw new IllegalArgumentException("Attempting to use a non-direct ByteBuffer without a backing byte array.");
        }
    }

    public void setBlob(boolean bl) {
        this.setExternalFile(bl);
    }

    public boolean getBlob() {
        return this.getExternalFile();
    }

    public byte[] getData() {
        return this.data;
    }

    public ByteBuffer getDataNIO() {
        return this.data_nio;
    }

    public void setData(byte[] byArray, int n, int n2) {
        this.data = byArray;
        this.offset = n;
        this.size = n2;
        this.data_nio = null;
    }

    public void setData(byte[] byArray) {
        this.setData(byArray, 0, byArray == null ? 0 : byArray.length);
    }

    public void setDataNIO(ByteBuffer byteBuffer, int n, int n2) {
        if (byteBuffer == null) {
            this.data_nio = null;
            this.data = null;
            this.offset = 0;
            this.size = 0;
            this.flags = 0;
        } else if (byteBuffer.hasArray()) {
            this.setData(byteBuffer.array(), n + byteBuffer.arrayOffset(), n2);
        } else {
            this.data_nio = byteBuffer;
            this.offset = n;
            this.size = n2;
            this.flags = 0;
            this.setUserBuffer(byteBuffer.capacity() - n, true);
            this.data = null;
        }
    }

    public void setDataNIO(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            this.setDataNIO(null, 0, 0);
        } else {
            this.setDataNIO(byteBuffer, byteBuffer.position(), byteBuffer.limit() - byteBuffer.position());
        }
    }

    public void setExternalFile(boolean bl) {
        this.flags = bl ? (this.flags |= 0x1000) : (this.flags &= 0xFFFFEFFF);
    }

    public boolean getExternalFile() {
        return (this.flags & 0x1000) != 0;
    }

    int getMultiFlag() {
        return 0;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    public int getPartialLength() {
        return this.dlen;
    }

    public int getPartialOffset() {
        return this.doff;
    }

    public boolean getPartial() {
        return (this.flags & 0x40) != 0;
    }

    public void setPartialOffset(int n) {
        this.doff = n;
    }

    public void setPartialLength(int n) {
        this.dlen = n;
    }

    public void setPartial(boolean bl) {
        this.flags = bl ? (this.flags |= 0x40) : (this.flags &= 0xFFFFFFBF);
    }

    public void setPartial(int n, int n2, boolean bl) {
        this.setPartialOffset(n);
        this.setPartialLength(n2);
        this.setPartial(bl);
    }

    public boolean getReadOnly() {
        return (this.flags & 0x100) != 0;
    }

    public void setReadOnly(boolean bl) {
        this.flags = bl ? (this.flags |= 0x100) : (this.flags &= 0xFFFFFEFF);
    }

    public int getRecordNumber() {
        return DbUtil.array2int(this.data, this.offset);
    }

    public void setRecordNumber(int n) {
        if (this.data == null || this.data.length < 4) {
            this.data = new byte[4];
            this.size = 4;
            this.ulen = 0;
            this.offset = 0;
        }
        DbUtil.int2array(n, this.data, 0);
    }

    public boolean getReuseBuffer() {
        return 0 == (this.flags & 0x810);
    }

    public void setReuseBuffer(boolean bl) {
        if (this.data_nio != null) {
            throw new IllegalArgumentException("Can only set the reuse flag on DatabaseEntry classes with a underlying byte[] data");
        }
        if (bl) {
            this.flags &= 0xFFFFF7EF;
        } else {
            this.flags &= 0xFFFFF7FF;
            this.flags |= 0x10;
        }
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public boolean getUserBuffer() {
        return (this.flags & 0x800) != 0;
    }

    public int getUserBufferLength() {
        return this.ulen;
    }

    public void setUserBuffer(int n, boolean bl) {
        this.ulen = n;
        if (bl) {
            this.flags &= 0xFFFFFFEF;
            this.flags |= 0x800;
        } else {
            this.flags &= 0xFFFFF7FF;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof DatabaseEntry)) {
            return false;
        }
        DatabaseEntry databaseEntry = (DatabaseEntry)object;
        if ((this.getPartial() || databaseEntry.getPartial()) && (this.getPartial() != databaseEntry.getPartial() || this.dlen != databaseEntry.dlen || this.doff != databaseEntry.doff)) {
            return false;
        }
        if (this.data == null && databaseEntry.data == null) {
            return true;
        }
        if (this.data == null || databaseEntry.data == null) {
            return false;
        }
        if (this.size != databaseEntry.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.data[this.offset + i] == databaseEntry.data[databaseEntry.offset + i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        if (this.data != null) {
            for (int i = 0; i < this.size; ++i) {
                n += this.data[this.offset + i];
            }
        }
        return n;
    }

    static {
        IGNORE.setUserBuffer(0, true);
        IGNORE.setPartial(0, 0, true);
        UNUSED = new DatabaseEntry();
    }
}

