/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.internal.DbUtil;
import java.nio.ByteBuffer;

public abstract class MultipleEntry
extends DatabaseEntry {
    int pos;

    MultipleEntry(byte[] byArray, int n, int n2) {
        super(byArray, n, n2);
        this.setUserBuffer(byArray != null ? byArray.length - n : 0, true);
        this.flags |= 2;
    }

    MultipleEntry(ByteBuffer byteBuffer) {
        super(byteBuffer);
        this.flags |= 2;
    }

    public void setUserBuffer(int n, boolean bl) {
        if (!bl) {
            throw new IllegalArgumentException("User buffer required");
        }
        super.setUserBuffer(n, bl);
    }

    protected boolean append_internal(byte[] byArray, int n, int n2, int n3) throws DatabaseException {
        int n4;
        if (this.pos == 0) {
            this.pos = this.ulen;
            n4 = 0;
        } else {
            n4 = DbUtil.array2int(this.data, this.pos + 4);
            n4 += DbUtil.array2int(this.data, this.pos);
        }
        if (n4 + n2 > this.pos - 12 - (n3 > 0 ? 4 : 0)) {
            return false;
        }
        if (n3 > 0) {
            this.pos -= 4;
            DbUtil.int2array(n3, this.data, this.pos);
        }
        this.pos -= 4;
        DbUtil.int2array(n4, this.data, this.pos);
        this.pos -= 4;
        DbUtil.int2array(n2, this.data, this.pos);
        DbUtil.int2array(n3 > 0 ? 0 : -1, this.data, this.pos - 4);
        for (int i = 0; i < n2; ++i) {
            this.data[n4 + i] = byArray[i + n];
        }
        return true;
    }

    protected boolean append_internal(byte[] byArray, int n, int n2) throws DatabaseException {
        return this.append_internal(byArray, n, n2, 0);
    }
}

