/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

public final class ReplicationConfig
implements Cloneable {
    public static final ReplicationConfig BULK = new ReplicationConfig("BULK", 128);
    public static final ReplicationConfig DELAYCLIENT = new ReplicationConfig("DELAYCLIENT", 256);
    public static final ReplicationConfig AUTOINIT = new ReplicationConfig("AUTOINIT", 32);
    public static final ReplicationConfig NOWAIT = new ReplicationConfig("NOWAIT", 4096);
    public static final ReplicationConfig STRICT_2SITE = new ReplicationConfig("STRICT_2SITE", 1);
    public static final ReplicationConfig ELECTIONS = new ReplicationConfig("ELECTIONS", 2);
    public static final ReplicationConfig LEASE = new ReplicationConfig("LEASE", 2048);
    public static final ReplicationConfig PREFMAS_MASTER = new ReplicationConfig("PREFMAS_MASTER", 16);
    public static final ReplicationConfig PREFMAS_CLIENT = new ReplicationConfig("PREFMAS_CLIENT", 8);
    public static final ReplicationConfig FORWARD_WRITES = new ReplicationConfig("FORWARD_WRITES", 4);
    private String configName;
    private int flag;

    static ReplicationConfig fromInt(int n) {
        switch (n) {
            case 128: {
                return BULK;
            }
            case 256: {
                return DELAYCLIENT;
            }
            case 32: {
                return AUTOINIT;
            }
            case 4096: {
                return NOWAIT;
            }
            case 1: {
                return STRICT_2SITE;
            }
            case 2: {
                return ELECTIONS;
            }
            case 2048: {
                return LEASE;
            }
            case 16: {
                return PREFMAS_MASTER;
            }
            case 8: {
                return PREFMAS_CLIENT;
            }
            case 4: {
                return FORWARD_WRITES;
            }
        }
        throw new IllegalArgumentException("Unknown replication config: " + n);
    }

    private ReplicationConfig(String string, int n) {
        this.configName = string;
        this.flag = n;
    }

    int getFlag() {
        return this.flag;
    }

    public String toString() {
        return "ReplicationConfig." + this.configName;
    }
}

