/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

public final class ReplicationTimeoutType {
    public static final ReplicationTimeoutType ACK_TIMEOUT = new ReplicationTimeoutType("ACK_TIMEOUT", 1);
    public static final ReplicationTimeoutType CHECKPOINT_DELAY = new ReplicationTimeoutType("CHECKPOINT_DELAY", 2);
    public static final ReplicationTimeoutType CONNECTION_RETRY = new ReplicationTimeoutType("CONNECTION_RETRY", 3);
    public static final ReplicationTimeoutType ELECTION_TIMEOUT = new ReplicationTimeoutType("ELECTION_TIMEOUT", 5);
    public static final ReplicationTimeoutType ELECTION_RETRY = new ReplicationTimeoutType("ELECTION_RETRY", 4);
    public static final ReplicationTimeoutType HEARTBEAT_MONITOR = new ReplicationTimeoutType("HEARTBEAT_MONITOR", 7);
    public static final ReplicationTimeoutType HEARTBEAT_SEND = new ReplicationTimeoutType("HEARTBEAT_SEND", 8);
    public static final ReplicationTimeoutType FULL_ELECTION_TIMEOUT = new ReplicationTimeoutType("FULL_ELECTION_TIMEOUT", 6);
    public static final ReplicationTimeoutType LEASE_TIMEOUT = new ReplicationTimeoutType("LEASE_TIMEOUT", 9);
    public static final ReplicationTimeoutType WRITE_FORWARD_TIMEOUT = new ReplicationTimeoutType("WRITE_FORWARD_TIMEOUT", 10);
    private String statusName;
    private int id;

    static ReplicationTimeoutType fromInt(int n) {
        switch (n) {
            case 1: {
                return ACK_TIMEOUT;
            }
            case 5: {
                return ELECTION_TIMEOUT;
            }
            case 4: {
                return ELECTION_RETRY;
            }
            case 3: {
                return CONNECTION_RETRY;
            }
            case 9: {
                return LEASE_TIMEOUT;
            }
            case 10: {
                return WRITE_FORWARD_TIMEOUT;
            }
        }
        throw new IllegalArgumentException("Unknown timeout type: " + n);
    }

    private ReplicationTimeoutType(String string, int n) {
        this.statusName = string;
        this.id = n;
    }

    int getId() {
        return this.id;
    }

    public String toString() {
        return "ReplicationTimeoutType." + this.statusName;
    }
}

