/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.SequenceConfig;
import com.sleepycat.db.SequenceStats;
import com.sleepycat.db.StatsConfig;
import com.sleepycat.db.Transaction;
import com.sleepycat.db.internal.DbSequence;

public class Sequence {
    private DbSequence seq;
    private int autoCommitFlag;

    Sequence(DbSequence dbSequence, SequenceConfig sequenceConfig) throws DatabaseException {
        this.seq = dbSequence;
        dbSequence.wrapper = this;
        if (dbSequence.get_db().get_transactional()) {
            this.autoCommitFlag = 0x100 | (SequenceConfig.checkNull(sequenceConfig).getAutoCommitNoSync() ? 1 : 0);
        }
    }

    public void close() throws DatabaseException {
        this.seq.close(0);
    }

    public long get(Transaction transaction, int n) throws DatabaseException {
        return this.seq.get(transaction == null ? null : transaction.txn, n, transaction == null ? this.autoCommitFlag : 0);
    }

    public Database getDatabase() throws DatabaseException {
        return this.seq.get_db().wrapper;
    }

    public DatabaseEntry getKey() throws DatabaseException {
        DatabaseEntry databaseEntry = new DatabaseEntry();
        this.seq.get_key(databaseEntry);
        return databaseEntry;
    }

    public SequenceStats getStats(StatsConfig statsConfig) throws DatabaseException {
        return this.seq.stat(statsConfig.getFlags());
    }

    public int printStats(StatsConfig statsConfig) throws DatabaseException {
        return this.seq.stat_print(statsConfig.getFlags());
    }
}

