/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.evolve;

import com.sleepycat.compat.DbCompat;
import com.sleepycat.persist.evolve.Conversion;
import com.sleepycat.persist.evolve.Mutation;
import java.lang.reflect.Method;

public class Converter
extends Mutation {
    private static final long serialVersionUID = 4558176842096181863L;
    private Conversion conversion;

    public Converter(String string, int n, Conversion conversion) {
        this(string, n, null, conversion);
    }

    public Converter(String string, int n, String string2, Conversion conversion) {
        super(string, n, string2);
        this.conversion = conversion;
        Class<?> clazz = conversion.getClass();
        try {
            Method method = clazz.getMethod("equals", Object.class);
            if (method.getDeclaringClass() == Object.class) {
                throw new IllegalArgumentException("Conversion class does not implement the equals method explicitly (Object.equals is not sufficient): " + clazz.getName());
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw DbCompat.unexpectedException(noSuchMethodException);
        }
    }

    public Conversion getConversion() {
        return this.conversion;
    }

    public boolean equals(Object object) {
        if (object instanceof Converter) {
            Converter converter = (Converter)object;
            return ((Object)this.conversion).equals(converter.conversion) && super.equals(object);
        }
        return false;
    }

    public int hashCode() {
        return this.conversion.hashCode() + super.hashCode();
    }

    public String toString() {
        return "[Converter " + super.toString() + " Conversion: " + this.conversion + ']';
    }
}

