/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.bind.tuple.IntegerBinding;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseConfig;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.DeadlockException;
import com.sleepycat.db.Environment;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.db.Transaction;
import com.sleepycat.persist.DatabaseNamer;
import com.sleepycat.persist.StoreExistsException;
import com.sleepycat.persist.StoreNotFoundException;
import com.sleepycat.persist.evolve.Converter;
import com.sleepycat.persist.evolve.IncompatibleClassException;
import com.sleepycat.persist.evolve.Mutations;
import com.sleepycat.persist.evolve.Renamer;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.CollectionProxy;
import com.sleepycat.persist.impl.ComplexFormat;
import com.sleepycat.persist.impl.CompositeKeyFormat;
import com.sleepycat.persist.impl.EnumFormat;
import com.sleepycat.persist.impl.Evolver;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.MapProxy;
import com.sleepycat.persist.impl.NonPersistentFormat;
import com.sleepycat.persist.impl.ObjectArrayFormat;
import com.sleepycat.persist.impl.PrimitiveArrayFormat;
import com.sleepycat.persist.impl.ProxiedFormat;
import com.sleepycat.persist.impl.ReadOnlyCatalog;
import com.sleepycat.persist.impl.RefreshException;
import com.sleepycat.persist.impl.SimpleCatalog;
import com.sleepycat.persist.impl.Store;
import com.sleepycat.persist.impl.StoredModel;
import com.sleepycat.persist.model.AnnotationModel;
import com.sleepycat.persist.model.ClassMetadata;
import com.sleepycat.persist.model.EntityMetadata;
import com.sleepycat.persist.model.EntityModel;
import com.sleepycat.persist.model.ModelInternal;
import com.sleepycat.persist.raw.RawObject;
import com.sleepycat.persist.raw.RawType;
import com.sleepycat.util.RuntimeExceptionWrapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistCatalog
implements Catalog {
    private static final int MAX_TXN_RETRIES = 10;
    private static final byte[] DATA_KEY = PersistCatalog.getIntBytes(-1);
    private static final byte[] BETA_MUTATIONS_KEY = PersistCatalog.getIntBytes(-2);
    public static boolean expectNoClassChanges;
    public static boolean unevolvedFormatsEncountered;
    private volatile List<Format> formatList;
    private volatile Map<String, Format> formatMap;
    private volatile Map<String, Format> latestFormatMap;
    private Map<String, String> proxyClassMap;
    private final Environment env;
    private final boolean rawAccess;
    private EntityModel model;
    private StoredModel storedModel;
    private Mutations mutations;
    private final Database db;
    private int openCount;
    private boolean readOnly;
    private final boolean transactional;
    private volatile int nStoredFormats;
    private final Store store;
    private Evolver initEvolver;
    private Data initData;

    private static byte[] getIntBytes(int n) {
        DatabaseEntry databaseEntry = new DatabaseEntry();
        IntegerBinding.intToEntry(n, databaseEntry);
        assert (databaseEntry.getSize() == 4 && databaseEntry.getData().length == 4);
        return databaseEntry.getData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistCatalog(Environment environment, String string, String string2, DatabaseConfig databaseConfig, EntityModel entityModel, Mutations mutations, boolean bl, Store store) throws StoreExistsException, StoreNotFoundException, IncompatibleClassException, DatabaseException {
        this.env = environment;
        this.rawAccess = bl;
        this.store = store;
        this.transactional = databaseConfig.getTransactional();
        String[] stringArray = store != null ? store.parseDbName(string2) : Store.parseDbName(string2, DatabaseNamer.DEFAULT);
        this.db = DbCompat.openDatabase(environment, null, stringArray[0], stringArray[1], databaseConfig);
        if (this.db == null) {
            String string3 = store.getDbNameMessage(stringArray);
            if (databaseConfig.getExclusiveCreate()) {
                throw new StoreExistsException("Catalog DB already exists and ExclusiveCreate=true, " + string3);
            }
            assert (!databaseConfig.getAllowCreate());
            throw new StoreNotFoundException("Catalog DB does not exist and AllowCreate=false, " + string3);
        }
        this.openCount = 1;
        boolean bl2 = false;
        try {
            this.initAndRetry(string, entityModel, mutations);
            bl2 = true;
        }
        finally {
            if (!bl2) {
                this.close();
            }
        }
    }

    PersistCatalog(PersistCatalog persistCatalog, String string) throws DatabaseException {
        this.db = persistCatalog.db;
        this.store = persistCatalog.store;
        this.env = persistCatalog.env;
        this.rawAccess = persistCatalog.rawAccess;
        this.openCount = persistCatalog.openCount;
        this.transactional = persistCatalog.transactional;
        this.initAndRetry(string, persistCatalog.model, persistCatalog.mutations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAndRetry(String string, EntityModel entityModel, Mutations mutations) throws DatabaseException {
        int n = 0;
        while (true) {
            Transaction transaction = null;
            if (this.transactional && DbCompat.getThreadTransaction(this.env) == null) {
                transaction = this.env.beginTransaction(null, this.store.getAutoCommitTxnConfig());
            }
            boolean bl = false;
            try {
                this.init(transaction, string, entityModel, mutations);
                bl = true;
                return;
            }
            catch (DeadlockException deadlockException) {
                if (n >= 10) {
                    throw deadlockException;
                }
            }
            finally {
                if (transaction != null) {
                    if (bl && !this.isReadOnly()) {
                        transaction.commit();
                    } else {
                        transaction.abort();
                    }
                }
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Transaction transaction, String string, EntityModel entityModel, Mutations mutations) throws DatabaseException {
        try {
            Iterator<Format> iterator;
            boolean bl;
            this.initData = this.readData(transaction);
            this.mutations = this.initData.mutations;
            if (this.mutations == null) {
                this.mutations = new Mutations();
            }
            boolean bl2 = bl = this.initData.version == -1;
            boolean bl3 = bl;
            boolean bl4 = false;
            if (mutations != null && !this.mutations.equals(mutations)) {
                this.mutations = mutations;
                bl2 = true;
                bl4 = true;
            }
            ClassLoader classLoader = DbCompat.getClassLoader(this.env);
            this.formatList = this.initData.formatList;
            if (this.formatList == null) {
                this.formatList = SimpleCatalog.getAllSimpleFormats(classLoader);
                iterator = new NonPersistentFormat((Catalog)this, Object.class);
                ((Format)((Object)iterator)).setId(1);
                this.formatList.set(1, (Format)((Object)iterator));
                iterator = new NonPersistentFormat((Catalog)this, Number.class);
                ((Format)((Object)iterator)).setId(22);
                this.formatList.set(22, (Format)((Object)iterator));
            } else {
                if (SimpleCatalog.addMissingSimpleFormats(classLoader, this.formatList)) {
                    bl2 = true;
                }
                this.nStoredFormats = this.formatList.size();
            }
            for (Format object22 : this.formatList) {
                if (object22 == null) continue;
                object22.initCatalog(this);
            }
            if (bl) {
                iterator = new HashMap();
                for (Format format : this.formatList) {
                    if (format == null) continue;
                    iterator.put(format.getClassName(), format);
                }
                for (Format format : this.formatList) {
                    if (format == null) continue;
                    format.migrateFromBeta((Map<String, Format>)((Object)iterator));
                }
            }
            this.formatMap = new HashMap<String, Format>(this.formatList.size());
            this.latestFormatMap = new HashMap<String, Format>(this.formatList.size());
            if (this.rawAccess) {
                for (Format format : this.formatList) {
                    if (format == null) continue;
                    String string2 = format.getClassName();
                    if (format.isCurrentVersion()) {
                        this.formatMap.put(string2, format);
                    }
                    if (format != format.getLatestVersion()) continue;
                    this.latestFormatMap.put(string2, format);
                }
                if (entityModel != null) {
                    this.model = entityModel;
                    this.storedModel = (StoredModel)entityModel;
                } else {
                    this.storedModel = new StoredModel(this);
                    this.model = this.storedModel;
                }
                ModelInternal.setClassLoader(this.model, classLoader);
                for (Format format : this.formatList) {
                    if (format == null) continue;
                    format.initializeIfNeeded(this, this.model);
                }
                this.initModelAndMutations();
                return;
            }
            this.model = entityModel != null ? entityModel : new AnnotationModel();
            ModelInternal.setClassLoader(this.model, classLoader);
            this.storedModel = null;
            for (int i = 0; i <= 30; ++i) {
                Format format = this.formatList.get(i);
                if (format == null) continue;
                this.formatMap.put(format.getClassName(), format);
            }
            ArrayList<String> arrayList = new ArrayList<String>(this.model.getKnownClasses());
            arrayList.addAll(this.model.getKnownSpecialClasses());
            this.addPredefinedProxies(arrayList);
            this.proxyClassMap = new HashMap<String, String>();
            for (Format format : this.formatList) {
                if (format == null || Format.isPredefined(format)) continue;
                String string3 = format.getClassName();
                Renamer renamer = this.mutations.getRenamer(string3, format.getVersion(), null);
                String string4 = renamer != null ? renamer.getNewName() : string3;
                this.addProxiedClass(string4, false);
            }
            for (String string5 : arrayList) {
                this.addProxiedClass(string5, true);
            }
            HashMap<String, Format> hashMap = new HashMap<String, Format>();
            for (String string6 : arrayList) {
                this.createFormat(string6, hashMap);
            }
            this.initEvolver = new Evolver(this, string, this.mutations, hashMap, bl4, bl3);
            for (Format format : this.formatList) {
                if (format == null || Format.isPredefined(format)) continue;
                if (format.isEntity()) {
                    this.initEvolver.evolveFormat(format);
                    continue;
                }
                this.initEvolver.addNonEntityFormat(format);
            }
            this.initEvolver.finishEvolution();
            String string7 = this.initEvolver.getErrors();
            if (string7 != null) {
                throw new IncompatibleClassException(string7);
            }
            for (Format format : hashMap.values()) {
                this.addFormat(format);
            }
            for (Format format : this.formatList) {
                if (format == null) continue;
                format.initializeIfNeeded(this, this.model);
                if (format != format.getLatestVersion()) continue;
                this.latestFormatMap.put(format.getClassName(), format);
            }
            boolean bl5 = hashMap.size() > 0 || this.initEvolver.areFormatsChanged();
            bl2 |= bl5;
            if (expectNoClassChanges && bl5) {
                throw new IllegalStateException("Unexpected changes  newFormats.size=" + hashMap.size() + " areFormatsChanged=" + this.initEvolver.areFormatsChanged());
            }
            this.readOnly = this.db.getConfig().getReadOnly();
            if (bl2 && !this.readOnly) {
                this.initEvolver.renameAndRemoveDatabases(this.store, transaction);
                this.initData.formatList = this.formatList;
                this.initData.mutations = this.mutations;
                this.writeData(transaction, this.initData);
            }
            this.initModelAndMutations();
        }
        finally {
            this.proxyClassMap = null;
            this.initData = null;
            this.initEvolver = null;
        }
    }

    private void initModelAndMutations() {
        ModelInternal.setCatalog(this.model, this);
        for (Converter converter : this.mutations.getConverters()) {
            converter.getConversion().initialize(this.model);
        }
    }

    public void getEntityFormats(Collection<Format> collection) {
        for (Format format : this.formatMap.values()) {
            if (!format.isEntity()) continue;
            collection.add(format);
        }
    }

    private void addProxiedClass(String string, boolean bl) {
        String string2;
        ClassMetadata classMetadata = this.model.getClassMetadata(string);
        if (classMetadata != null && (string2 = classMetadata.getProxiedClassName()) != null) {
            if (bl) {
                try {
                    Class clazz = this.resolveClass(string2);
                    if (!SimpleCatalog.allowRegisterProxy(clazz)) {
                        throw new IllegalArgumentException("Registering proxy is not allowed for " + string2 + ", which is a built-in simple type.");
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw DbCompat.unexpectedState("Class does not exist: " + string2);
                }
            }
            this.proxyClassMap.put(string2, string);
        }
    }

    private void addPredefinedProxies(List<String> list) {
        list.add(CollectionProxy.ArrayListProxy.class.getName());
        list.add(CollectionProxy.LinkedListProxy.class.getName());
        list.add(CollectionProxy.HashSetProxy.class.getName());
        list.add(CollectionProxy.TreeSetProxy.class.getName());
        list.add(MapProxy.HashMapProxy.class.getName());
        list.add(MapProxy.TreeMapProxy.class.getName());
        list.add(MapProxy.LinkedHashMapProxy.class.getName());
    }

    Map<Format, Set<Format>> getSubclassMap() {
        HashMap<Format, Set<Format>> hashMap = new HashMap<Format, Set<Format>>();
        for (Format format : this.formatList) {
            Format format2;
            if (format == null || Format.isPredefined(format) || (format2 = format.getSuperFormat()) == null) continue;
            HashSet<Format> hashSet = (HashSet<Format>)hashMap.get(format2);
            if (hashSet == null) {
                hashSet = new HashSet<Format>();
                hashMap.put(format2, hashSet);
            }
            hashSet.add(format);
        }
        return hashMap;
    }

    public EntityModel getResolvedModel() {
        return this.model;
    }

    public void openExisting() {
        ++this.openCount;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean close() throws DatabaseException {
        if (this.openCount == 0) {
            throw DbCompat.unexpectedState("Catalog is not open");
        }
        --this.openCount;
        if (this.openCount == 0) {
            this.db.close();
            return true;
        }
        return false;
    }

    public Mutations getMutations() {
        return this.mutations;
    }

    @Override
    public Format createFormat(String string, Map<String, Format> map) {
        Class clazz;
        try {
            clazz = this.resolveClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw DbCompat.unexpectedState("Class does not exist: " + string);
        }
        return this.createFormat(clazz, map);
    }

    @Override
    public Format createFormat(Class clazz, Map<String, Format> map) {
        String string = clazz.getName();
        Format format = this.getFormatFromMap(clazz, map);
        if (format != null) {
            return format;
        }
        format = this.getFormatFromMap(clazz, this.formatMap);
        if (format != null) {
            return format;
        }
        assert (!SimpleCatalog.isSimpleType(clazz)) : string;
        ClassMetadata classMetadata = this.model.getClassMetadata(string);
        String string2 = null;
        if (this.proxyClassMap != null) {
            string2 = this.proxyClassMap.get(string);
        }
        if (string2 != null) {
            format = new ProxiedFormat(this, clazz, string2);
        } else if (clazz.isArray()) {
            format = clazz.getComponentType().isPrimitive() ? new PrimitiveArrayFormat((Catalog)this, clazz) : new ObjectArrayFormat((Catalog)this, clazz);
        } else if (clazz.isEnum()) {
            format = new EnumFormat((Catalog)this, clazz);
        } else if (clazz.getEnclosingClass() != null && clazz.getEnclosingClass().isEnum()) {
            format = new EnumFormat((Catalog)this, clazz.getEnclosingClass());
        } else if (clazz == Object.class || clazz.isInterface()) {
            format = new NonPersistentFormat((Catalog)this, clazz);
        } else {
            if (classMetadata == null) {
                throw new IllegalArgumentException("Class could not be loaded or is not persistent: " + string);
            }
            if (classMetadata.getCompositeKeyFields() != null && (classMetadata.getPrimaryKey() != null || classMetadata.getSecondaryKeys() != null)) {
                throw new IllegalArgumentException("A composite key class may not have primary or secondary key fields: " + clazz.getName());
            }
            if (clazz.getEnclosingClass() != null && !Modifier.isStatic(clazz.getModifiers())) {
                throw new IllegalArgumentException("Inner classes not allowed: " + clazz.getName());
            }
            try {
                clazz.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalArgumentException("No default constructor: " + clazz.getName(), noSuchMethodException);
            }
            if (classMetadata.getCompositeKeyFields() != null) {
                format = new CompositeKeyFormat((Catalog)this, clazz, classMetadata, classMetadata.getCompositeKeyFields());
            } else {
                EntityMetadata entityMetadata = this.model.getEntityMetadata(string);
                format = new ComplexFormat(this, clazz, classMetadata, entityMetadata);
            }
        }
        map.put(string, format);
        format.collectRelatedFormats(this, map);
        return format;
    }

    private Format getFormatFromMap(Class clazz, Map<String, Format> map) {
        Format format = map.get(clazz.getName());
        if (format != null) {
            return format;
        }
        if (clazz.getEnclosingClass() != null && clazz.getEnclosingClass().isEnum() && (format = map.get(clazz.getEnclosingClass().getName())) != null) {
            return format;
        }
        return null;
    }

    private void addFormat(Format format) {
        this.addFormat(format, this.formatList, this.formatMap);
    }

    private void addFormat(Format format, List<Format> list, Map<String, Format> map) {
        format.setId(list.size());
        list.add(format);
        map.put(format.getClassName(), format);
    }

    void useExistingFormat(Format format) {
        assert (format.isCurrentVersion());
        this.formatMap.put(format.getClassName(), format);
    }

    Set<String> getModelClasses() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Format format : this.formatMap.values()) {
            if (!format.isModelClass()) continue;
            hashSet.add(format.getClassName());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public List<RawType> getAllRawTypes() {
        ArrayList<Format> arrayList = new ArrayList<Format>();
        for (Format format : this.formatList) {
            if (format == null) continue;
            arrayList.add(format);
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public int getInitVersion(Format format, boolean bl) {
        if (this.initData == null || this.initData.formatList == null || format.getId() >= this.initData.formatList.size()) {
            return 1;
        }
        assert (this.initData != null);
        if (bl) {
            return this.initEvolver != null && this.initEvolver.isFormatChanged(format) ? 1 : this.initData.version;
        }
        return this.initData.version;
    }

    @Override
    public Format getFormat(int n, boolean bl) throws RefreshException {
        if (n < 0) {
            throw DbCompat.unexpectedState("Format ID " + n + " is negative," + " may indicate data corruption.");
        }
        if (bl && n >= this.nStoredFormats) {
            assert (this.store != null);
            throw new RefreshException(this.store, this, n);
        }
        Format format = this.formatList.get(n);
        if (format == null) {
            throw DbCompat.unexpectedState("Format ID " + n + " has null format," + " may indicate data corruption.");
        }
        return format;
    }

    @Override
    public Format getFormat(Class clazz, boolean bl) throws RefreshException {
        Format format = this.formatMap.get(clazz.getName());
        if (format == null) {
            if (this.model != null) {
                ComplexFormat complexFormat;
                format = this.addNewFormat(clazz);
                if (bl && this.store != null && (complexFormat = format.getEntityFormat()) != null && complexFormat != format) {
                    try {
                        this.store.checkEntitySubclassSecondaries(((Format)complexFormat).getEntityMetadata(), clazz.getName());
                    }
                    catch (DatabaseException databaseException) {
                        throw RuntimeExceptionWrapper.wrapIfNeeded(databaseException);
                    }
                }
            }
            if (format == null) {
                throw new IllegalArgumentException("Class is not persistent: " + clazz.getName());
            }
        }
        return format;
    }

    @Override
    public Format getFormat(String string) {
        return this.formatMap.get(string);
    }

    public Format getLatestVersion(String string) {
        return this.latestFormatMap.get(string);
    }

    public String getDatabaseClassName(String string) {
        Format format = this.getStoredFormat(string);
        if (format == null) {
            return null;
        }
        return format.getClassName();
    }

    public String getDatabaseKeyName(String string, String string2) {
        Format format = this.getStoredFormat(string);
        if (format == null) {
            return null;
        }
        return format.getOldKeyName(string2);
    }

    private Format getStoredFormat(String string) {
        Format format;
        for (format = this.getFormat(string); format != null && format.getId() >= this.nStoredFormats; format = format.getPreviousVersion()) {
        }
        return format;
    }

    void checkWriteInReplicaUpgradeMode() throws RefreshException {
        if (this.nStoredFormats < this.formatList.size()) {
            throw new RefreshException(this.store, this, -1);
        }
    }

    boolean isReplicaUpgradeMode() {
        return this.nStoredFormats < this.formatList.size();
    }

    private synchronized Format addNewFormat(Class clazz) throws RefreshException {
        Format format = this.getFormatFromMap(clazz, this.formatMap);
        if (format != null) {
            return format;
        }
        ArrayList<Format> arrayList = new ArrayList<Format>(this.formatList);
        HashMap<String, Format> hashMap = new HashMap<String, Format>(this.formatMap);
        HashMap<String, Format> hashMap2 = new HashMap<String, Format>(this.latestFormatMap);
        HashMap<String, Format> hashMap3 = new HashMap<String, Format>();
        format = this.createFormat(clazz, hashMap3);
        for (Object object : hashMap3.values()) {
            this.addFormat((Format)object, arrayList, hashMap);
        }
        ReadOnlyCatalog readOnlyCatalog = new ReadOnlyCatalog(ModelInternal.getClassLoader(this.model), arrayList, hashMap);
        for (Format format2 : hashMap3.values()) {
            format2.initializeIfNeeded(readOnlyCatalog, this.model);
            hashMap2.put(format2.getClassName(), format2);
        }
        if (!this.readOnly) {
            try {
                Object object;
                object = new Data();
                ((Data)object).formatList = arrayList;
                ((Data)object).mutations = this.mutations;
                this.writeDataCheckStale((Data)object);
            }
            catch (DatabaseException databaseException) {
                throw RuntimeExceptionWrapper.wrapIfNeeded(databaseException);
            }
        }
        this.formatList = arrayList;
        this.formatMap = hashMap;
        this.latestFormatMap = hashMap2;
        return format;
    }

    public synchronized void flush(Transaction transaction) throws DatabaseException {
        Data data = new Data();
        data.formatList = this.formatList;
        data.mutations = this.mutations;
        this.writeData(transaction, data);
    }

    int getNFormats() {
        return this.nStoredFormats;
    }

    private Data readData(Transaction transaction) throws DatabaseException {
        DatabaseEntry databaseEntry = new DatabaseEntry(DATA_KEY);
        DatabaseEntry databaseEntry2 = new DatabaseEntry();
        OperationStatus operationStatus = this.db.get(transaction, databaseEntry, databaseEntry2, null);
        if (operationStatus == OperationStatus.SUCCESS) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(databaseEntry2.getData(), databaseEntry2.getOffset(), databaseEntry2.getSize());
            try {
                Data data;
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                Object object = objectInputStream.readObject();
                assert (objectInputStream.available() == 0);
                if (object instanceof Data) {
                    data = (Data)object;
                } else {
                    if (!(object instanceof List)) {
                        throw DbCompat.unexpectedState(object.getClass().getName());
                    }
                    data = new Data();
                    data.formatList = (List)object;
                    data.version = -1;
                }
                return data;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw DbCompat.unexpectedException(classNotFoundException);
            }
            catch (IOException iOException) {
                throw DbCompat.unexpectedException(iOException);
            }
        }
        Data data = new Data();
        data.version = 1;
        return data;
    }

    boolean isMetadataStale(Transaction transaction) throws DatabaseException {
        Data data = this.readData(transaction);
        return data.formatList != null && data.formatList.size() > this.nStoredFormats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDataCheckStale(Data data) throws DatabaseException, RefreshException {
        int n = 0;
        while (true) {
            Transaction transaction = null;
            if (this.transactional && DbCompat.getThreadTransaction(this.env) == null) {
                transaction = this.env.beginTransaction(null, this.store.getAutoCommitTxnConfig());
            }
            boolean bl = false;
            try {
                if (this.isMetadataStale(transaction)) {
                    throw new RefreshException(this.store, this, -1);
                }
                this.writeData(transaction, data);
                bl = true;
                return;
            }
            catch (DeadlockException deadlockException) {
                if (n >= 10) {
                    throw deadlockException;
                }
            }
            finally {
                if (transaction != null) {
                    if (bl && !this.isReadOnly()) {
                        transaction.commit();
                    } else {
                        transaction.abort();
                    }
                }
            }
            ++n;
        }
    }

    private void writeData(Transaction transaction, Data data) throws DatabaseException {
        Object object;
        boolean bl = data.version == -1;
        data.version = 1;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            object = new ObjectOutputStream(byteArrayOutputStream);
            ((ObjectOutputStream)object).writeObject(data);
        }
        catch (IOException iOException) {
            throw DbCompat.unexpectedException(iOException);
        }
        object = new DatabaseEntry(DATA_KEY);
        DatabaseEntry databaseEntry = new DatabaseEntry(byteArrayOutputStream.toByteArray());
        this.db.put(transaction, (DatabaseEntry)object, databaseEntry);
        if (bl) {
            ((DatabaseEntry)object).setData(BETA_MUTATIONS_KEY);
            this.db.delete(transaction, (DatabaseEntry)object);
        }
        this.nStoredFormats = data.formatList.size();
    }

    @Override
    public boolean isRawAccess() {
        return this.rawAccess;
    }

    @Override
    public Object convertRawObject(RawObject rawObject, IdentityHashMap identityHashMap) throws RefreshException {
        Object object;
        Object object2 = (Format)rawObject.getType();
        if (this == ((Format)object2).getCatalog()) {
            object2 = this.getFormat(((Format)object2).getId(), false);
        } else {
            object = ((Format)object2).getClassName();
            try {
                Class clazz = this.resolveClass((String)object);
                object2 = this.getFormat(clazz, true);
            }
            catch (ClassNotFoundException classNotFoundException) {
                object2 = null;
            }
            if (object2 == null) {
                throw new IllegalArgumentException("External raw type not found: " + (String)object);
            }
        }
        object = ((Format)object2).getProxiedFormat();
        if (object != null) {
            object2 = object;
        }
        if (identityHashMap == null) {
            identityHashMap = new IdentityHashMap();
        }
        return ((Format)object2).convertRawObject(this, false, rawObject, identityHashMap);
    }

    @Override
    public Class resolveClass(String string) throws ClassNotFoundException {
        return SimpleCatalog.resolveClass(string, ModelInternal.getClassLoader(this.model));
    }

    @Override
    public Class resolveKeyClass(String string) {
        return SimpleCatalog.resolveKeyClass(string, ModelInternal.getClassLoader(this.model));
    }

    private static class Data
    implements Serializable {
        static final long serialVersionUID = 7515058069137413261L;
        List<Format> formatList;
        Mutations mutations;
        int version;

        private Data() {
        }
    }
}

