/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.compat.DbCompat;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.Evolver;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.RecordInput;
import com.sleepycat.persist.impl.RecordOutput;
import com.sleepycat.persist.impl.RefreshException;
import com.sleepycat.persist.model.EntityModel;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleFormat
extends Format {
    private static final long serialVersionUID = 4595245575868697702L;
    private final boolean primitive;
    private SimpleFormat wrapperFormat;

    SimpleFormat(Catalog catalog, Class clazz, boolean bl) {
        super(catalog, clazz);
        this.primitive = bl;
    }

    void setWrapperFormat(SimpleFormat simpleFormat) {
        this.wrapperFormat = simpleFormat;
    }

    @Override
    Format getWrapperFormat() {
        return this.wrapperFormat;
    }

    @Override
    public boolean isSimple() {
        return true;
    }

    @Override
    public boolean isPrimitive() {
        return this.primitive;
    }

    @Override
    void collectRelatedFormats(Catalog catalog, Map<String, Format> map) {
    }

    @Override
    void initialize(Catalog catalog, EntityModel entityModel, int n) {
    }

    @Override
    public Object readObject(Object object, EntityInput entityInput, boolean bl) {
        return object;
    }

    @Override
    boolean evolve(Format format, Evolver evolver) {
        evolver.useOldFormat(this, format);
        return true;
    }

    Object newPrimitiveArray(int n, EntityInput entityInput) throws RefreshException {
        throw DbCompat.unexpectedState();
    }

    void writePrimitiveArray(Object object, EntityOutput entityOutput) {
        throw DbCompat.unexpectedState();
    }

    int getPrimitiveLength() {
        throw DbCompat.unexpectedState();
    }

    void readPrimitiveField(Object object, EntityInput entityInput, Field field) throws IllegalAccessException, RefreshException {
        throw DbCompat.unexpectedState();
    }

    void writePrimitiveField(Object object, EntityOutput entityOutput, Field field) throws IllegalAccessException {
        throw DbCompat.unexpectedState();
    }

    void skipPrimitiveArray(int n, RecordInput recordInput) {
        recordInput.skipFast(n * this.getPrimitiveLength());
    }

    void copySecMultiKeyPrimitiveArray(int n, RecordInput recordInput, Set set) {
        int n2 = this.getPrimitiveLength();
        for (int i = 0; i < n; ++i) {
            DatabaseEntry databaseEntry = new DatabaseEntry(recordInput.getBufferBytes(), recordInput.getBufferOffset(), n2);
            set.add(databaseEntry);
            recordInput.skipFast(n2);
        }
    }

    public static class FDate
    extends SimpleFormat {
        private static final long serialVersionUID = -5665773229869034145L;

        FDate(Catalog catalog) {
            super(catalog, Date.class, false);
        }

        Object newArray(int n) {
            return new Date[n];
        }

        public Object newInstance(EntityInput entityInput, boolean bl) throws RefreshException {
            return new Date(entityInput.readLong());
        }

        void writeObject(Object object, EntityOutput entityOutput, boolean bl) {
            entityOutput.writeLong(((Date)object).getTime());
        }

        void skipContents(RecordInput recordInput) {
            recordInput.skipFast(8);
        }

        void copySecKey(RecordInput recordInput, RecordOutput recordOutput) {
            recordOutput.writeFast(recordInput.getBufferBytes(), recordInput.getBufferOffset(), 8);
            recordInput.skipFast(8);
        }
    }

    public static class FBigDec
    extends SimpleFormat {
        private static final long serialVersionUID = 6108874887143696463L;

        FBigDec(Catalog catalog) {
            super(catalog, BigDecimal.class, false);
        }

        Object newArray(int n) {
            return new BigDecimal[n];
        }

        public Object newInstance(EntityInput entityInput, boolean bl) throws RefreshException {
            return entityInput.readSortedBigDecimal();
        }

        void writeObject(Object object, EntityOutput entityOutput, boolean bl) {
            entityOutput.writeSortedBigDecimal((BigDecimal)object);
        }

        void skipContents(RecordInput recordInput) {
            recordInput.skipFast(recordInput.getSortedBigDecimalByteLength());
        }

        void copySecKey(RecordInput recordInput, RecordOutput recordOutput) {
            int n = recordInput.getSortedBigDecimalByteLength();
            recordOutput.writeFast(recordInput.getBufferBytes(), recordInput.getBufferOffset(), n);
            recordInput.skipFast(n);
        }

        public boolean allowEvolveFromProxy() {
            return true;
        }
    }

    public static class FBigInt
    extends SimpleFormat {
        private static final long serialVersionUID = -5027098112507644563L;

        FBigInt(Catalog catalog) {
            super(catalog, BigInteger.class, false);
        }

        Object newArray(int n) {
            return new BigInteger[n];
        }

        public Object newInstance(EntityInput entityInput, boolean bl) throws RefreshException {
            return entityInput.readBigInteger();
        }

        void writeObject(Object object, EntityOutput entityOutput, boolean bl) {
            entityOutput.writeBigInteger((BigInteger)object);
        }

        void skipContents(RecordInput recordInput) {
            recordInput.skipFast(recordInput.getBigIntegerByteLength());
        }

        void copySecKey(RecordInput recordInput, RecordOutput recordOutput) {
            int n = recordInput.getBigIntegerByteLength();
            recordOutput.writeFast(recordInput.getBufferBytes(), recordInput.getBufferOffset(), n);
            recordInput.skipFast(n);
        }
    }

    public static class FString
    extends SimpleFormat {
        private static final long serialVersionUID = 5710392786480064612L;

        FString(Catalog catalog) {
            super(catalog, String.class, false);
        }

        Object newArray(int n) {
            return new String[n];
        }

        public Object newInstance(EntityInput entityInput, boolean bl) throws RefreshException {
            return entityInput.readString();
        }

        void writeObject(Object object, EntityOutput entityOutput, boolean bl) {
            entityOutput.writeString((String)object);
        }

        void skipContents(RecordInput recordInput) {
            recordInput.skipFast(recordInput.getStringByteLength());
        }

        void copySecKey(RecordInput recordInput, RecordOutput recordOutput) {
            int n = recordInput.getStringByteLength();
            recordOutput.writeFast(recordInput.getBufferBytes(), recordInput.getBufferOffset(), n);
            recordInput.skipFast(n);
        }
    }

    public static class FChar
    extends SimpleFormat {
        private static final long serialVersionUID = -7609118195770005374L;

        FChar(Catalog catalog, boolean bl) {
            super(catalog, bl ? Character.TYPE : Character.class, bl);
        }

        Object newArray(int n) {
            return new Character[n];
        }

        public Object newInstance(EntityInput entityInput, boolean bl) throws RefreshException {
            return Character.valueOf(entityInput.readChar());
        }

        void writeObject(Object object, EntityOutput entityOutput, boolean bl) {
            entityOutput.writeChar(((Character)object).charValue());
        }

        void skipContents(RecordInput recordInput) {
            recordInput.skipFast(2);
        }

        void copySecKey(RecordInput recordInput, RecordOutput recordOutput) {
            recordOutput.writeFast(recordInput.readFast());
            recordOutput.writeFast(recordInput.readFast());
        }

        Object newPrimitiveArray(int n, EntityInput entityInput) throws RefreshException {
            char[] cArray = new char[n];
            for (int i = 0; i < n; ++i) {
                cArray[i] = entityInput.readChar();
            }
            return cArray;
        }

        void writePrimitiveArray(Object object, EntityOutput entityOutput) {
            char[] cArray = (char[])object;
            int n = cArray.length;
            entityOutput.writeArrayLength(n);
            for (int i = 0; i < n; ++i) {
                entityOutput.writeChar(cArray[i]);
            }
        }

        int getPrimitiveLength() {
            return 2;
        }

        void readPrimitiveField(Object object, EntityInput entityInput, Field field) throws IllegalAccessException, RefreshException {
            field.setChar(object, entityInput.readChar());
        }

        void writePrimitiveField(Object object, EntityOutput entityOutput, Field field) throws IllegalAccessException {
            entityOutput.writeChar(field.getChar(object));
        }
    }

    public static class FDouble
    extends SimpleFormat {
        private static final long serialVersionUID = 646904456811041423L;

        FDouble(Catalog catalog, boolean bl) {
            super(catalog, bl ? Double.TYPE : Double.class, bl);
        }

        Object newArray(int n) {
            return new Double[n];
        }

        public Object newInstance(EntityInput entityInput, boolean bl) throws RefreshException {
            return entityInput.readSortedDouble();
        }

        void writeObject(Object object, EntityOutput entityOutput, boolean bl) {
            entityOutput.writeSortedDouble(((Number)object).doubleValue());
        }

        void skipContents(RecordInput recordInput) {
            recordInput.skipFast(8);
        }

        void copySecKey(RecordInput recordInput, RecordOutput recordOutput) {
            recordOutput.writeFast(recordInput.getBufferBytes(), recordInput.getBufferOffset(), 8);
            recordInput.skipFast(8);
        }

        Object newPrimitiveArray(int n, EntityInput entityInput) throws RefreshException {
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = entityInput.readSortedDouble();
            }
            return dArray;
        }

        void writePrimitiveArray(Object object, EntityOutput entityOutput) {
            double[] dArray = (double[])object;
            int n = dArray.length;
            entityOutput.writeArrayLength(n);
            for (int i = 0; i < n; ++i) {
                entityOutput.writeSortedDouble(dArray[i]);
            }
        }

        int getPrimitiveLength() {
            return 8;
        }

        void readPrimitiveField(Object object, EntityInput entityInput, Field field) throws IllegalAccessException, RefreshException {
            field.setDouble(object, entityInput.readSortedDouble());
        }

        void writePrimitiveField(Object object, EntityOutput entityOutput, Field field) throws IllegalAccessException {
            entityOutput.writeSortedDouble(field.getDouble(object));
        }
    }

    public static class FFloat
    extends SimpleFormat {
        private static final long serialVersionUID = 1033413049495053602L;

        FFloat(Catalog catalog, boolean bl) {
            super(catalog, bl ? Float.TYPE : Float.class, bl);
        }

        Object newArray(int n) {
            return new Float[n];
        }

        public Object newInstance(EntityInput entityInput, boolean bl) throws RefreshException {
            return Float.valueOf(entityInput.readSortedFloat());
        }

        void writeObject(Object object, EntityOutput entityOutput, boolean bl) {
            entityOutput.writeSortedFloat(((Number)object).floatValue());
        }

        void skipContents(RecordInput recordInput) {
            recordInput.skipFast(4);
        }

        void copySecKey(RecordInput recordInput, RecordOutput recordOutput) {
            recordOutput.writeFast(recordInput.readFast());
            recordOutput.writeFast(recordInput.readFast());
            recordOutput.writeFast(recordInput.readFast());
            recordOutput.writeFast(recordInput.readFast());
        }

        Object newPrimitiveArray(int n, EntityInput entityInput) throws RefreshException {
            float[] fArray = new float[n];
            for (int i = 0; i < n; ++i) {
                fArray[i] = entityInput.readSortedFloat();
            }
            return fArray;
        }

        void writePrimitiveArray(Object object, EntityOutput entityOutput) {
            float[] fArray = (float[])object;
            int n = fArray.length;
            entityOutput.writeArrayLength(n);
            for (int i = 0; i < n; ++i) {
                entityOutput.writeSortedFloat(fArray[i]);
            }
        }

        int getPrimitiveLength() {
            return 4;
        }

        void readPrimitiveField(Object object, EntityInput entityInput, Field field) throws IllegalAccessException, RefreshException {
            field.setFloat(object, entityInput.readSortedFloat());
        }

        void writePrimitiveField(Object object, EntityOutput entityOutput, Field field) throws IllegalAccessException {
            entityOutput.writeSortedFloat(field.getFloat(object));
        }
    }

    public static class FLong
    extends SimpleFormat {
        private static final long serialVersionUID = 1872661106534776520L;

        FLong(Catalog catalog, boolean bl) {
            super(catalog, bl ? Long.TYPE : Long.class, bl);
        }

        Object newArray(int n) {
            return new Long[n];
        }

        public Object newInstance(EntityInput entityInput, boolean bl) throws RefreshException {
            return entityInput.readLong();
        }

        void writeObject(Object object, EntityOutput entityOutput, boolean bl) {
            entityOutput.writeLong(((Number)object).longValue());
        }

        void skipContents(RecordInput recordInput) {
            recordInput.skipFast(8);
        }

        void copySecKey(RecordInput recordInput, RecordOutput recordOutput) {
            recordOutput.writeFast(recordInput.getBufferBytes(), recordInput.getBufferOffset(), 8);
            recordInput.skipFast(8);
        }

        Object newPrimitiveArray(int n, EntityInput entityInput) throws RefreshException {
            long[] lArray = new long[n];
            for (int i = 0; i < n; ++i) {
                lArray[i] = entityInput.readLong();
            }
            return lArray;
        }

        void writePrimitiveArray(Object object, EntityOutput entityOutput) {
            long[] lArray = (long[])object;
            int n = lArray.length;
            entityOutput.writeArrayLength(n);
            for (int i = 0; i < n; ++i) {
                entityOutput.writeLong(lArray[i]);
            }
        }

        int getPrimitiveLength() {
            return 8;
        }

        void readPrimitiveField(Object object, EntityInput entityInput, Field field) throws IllegalAccessException, RefreshException {
            field.setLong(object, entityInput.readLong());
        }

        void writePrimitiveField(Object object, EntityOutput entityOutput, Field field) throws IllegalAccessException {
            entityOutput.writeLong(field.getLong(object));
        }

        Format getSequenceKeyFormat() {
            return this;
        }
    }

    public static class FInt
    extends SimpleFormat {
        private static final long serialVersionUID = 2695910006049980013L;

        FInt(Catalog catalog, boolean bl) {
            super(catalog, bl ? Integer.TYPE : Integer.class, bl);
        }

        Object newArray(int n) {
            return new Integer[n];
        }

        public Object newInstance(EntityInput entityInput, boolean bl) throws RefreshException {
            return entityInput.readInt();
        }

        void writeObject(Object object, EntityOutput entityOutput, boolean bl) {
            entityOutput.writeInt(((Number)object).intValue());
        }

        void skipContents(RecordInput recordInput) {
            recordInput.skipFast(4);
        }

        void copySecKey(RecordInput recordInput, RecordOutput recordOutput) {
            recordOutput.writeFast(recordInput.readFast());
            recordOutput.writeFast(recordInput.readFast());
            recordOutput.writeFast(recordInput.readFast());
            recordOutput.writeFast(recordInput.readFast());
        }

        Object newPrimitiveArray(int n, EntityInput entityInput) throws RefreshException {
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = entityInput.readInt();
            }
            return nArray;
        }

        void writePrimitiveArray(Object object, EntityOutput entityOutput) {
            int[] nArray = (int[])object;
            int n = nArray.length;
            entityOutput.writeArrayLength(n);
            for (int i = 0; i < n; ++i) {
                entityOutput.writeInt(nArray[i]);
            }
        }

        int getPrimitiveLength() {
            return 4;
        }

        void readPrimitiveField(Object object, EntityInput entityInput, Field field) throws IllegalAccessException, RefreshException {
            field.setInt(object, entityInput.readInt());
        }

        void writePrimitiveField(Object object, EntityOutput entityOutput, Field field) throws IllegalAccessException {
            entityOutput.writeInt(field.getInt(object));
        }

        Format getSequenceKeyFormat() {
            return this;
        }
    }

    public static class FShort
    extends SimpleFormat {
        private static final long serialVersionUID = -4909138198491785624L;

        FShort(Catalog catalog, boolean bl) {
            super(catalog, bl ? Short.TYPE : Short.class, bl);
        }

        Object newArray(int n) {
            return new Short[n];
        }

        public Object newInstance(EntityInput entityInput, boolean bl) throws RefreshException {
            return entityInput.readShort();
        }

        void writeObject(Object object, EntityOutput entityOutput, boolean bl) {
            entityOutput.writeShort(((Number)object).shortValue());
        }

        void skipContents(RecordInput recordInput) {
            recordInput.skipFast(2);
        }

        void copySecKey(RecordInput recordInput, RecordOutput recordOutput) {
            recordOutput.writeFast(recordInput.readFast());
            recordOutput.writeFast(recordInput.readFast());
        }

        Object newPrimitiveArray(int n, EntityInput entityInput) throws RefreshException {
            short[] sArray = new short[n];
            for (int i = 0; i < n; ++i) {
                sArray[i] = entityInput.readShort();
            }
            return sArray;
        }

        void writePrimitiveArray(Object object, EntityOutput entityOutput) {
            short[] sArray = (short[])object;
            int n = sArray.length;
            entityOutput.writeArrayLength(n);
            for (int i = 0; i < n; ++i) {
                entityOutput.writeShort(sArray[i]);
            }
        }

        int getPrimitiveLength() {
            return 2;
        }

        void readPrimitiveField(Object object, EntityInput entityInput, Field field) throws IllegalAccessException, RefreshException {
            field.setShort(object, entityInput.readShort());
        }

        void writePrimitiveField(Object object, EntityOutput entityOutput, Field field) throws IllegalAccessException {
            entityOutput.writeShort(field.getShort(object));
        }

        Format getSequenceKeyFormat() {
            return this;
        }
    }

    public static class FByte
    extends SimpleFormat {
        private static final long serialVersionUID = 3651752958101447257L;

        FByte(Catalog catalog, boolean bl) {
            super(catalog, bl ? Byte.TYPE : Byte.class, bl);
        }

        Object newArray(int n) {
            return new Byte[n];
        }

        public Object newInstance(EntityInput entityInput, boolean bl) throws RefreshException {
            return entityInput.readByte();
        }

        void writeObject(Object object, EntityOutput entityOutput, boolean bl) {
            entityOutput.writeByte(((Number)object).byteValue());
        }

        void skipContents(RecordInput recordInput) {
            recordInput.skipFast(1);
        }

        void copySecKey(RecordInput recordInput, RecordOutput recordOutput) {
            recordOutput.writeFast(recordInput.readFast());
        }

        Object newPrimitiveArray(int n, EntityInput entityInput) throws RefreshException {
            byte[] byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray[i] = entityInput.readByte();
            }
            return byArray;
        }

        void writePrimitiveArray(Object object, EntityOutput entityOutput) {
            byte[] byArray = (byte[])object;
            int n = byArray.length;
            entityOutput.writeArrayLength(n);
            for (int i = 0; i < n; ++i) {
                entityOutput.writeByte(byArray[i]);
            }
        }

        int getPrimitiveLength() {
            return 1;
        }

        void readPrimitiveField(Object object, EntityInput entityInput, Field field) throws IllegalAccessException, RefreshException {
            field.setByte(object, entityInput.readByte());
        }

        void writePrimitiveField(Object object, EntityOutput entityOutput, Field field) throws IllegalAccessException {
            entityOutput.writeByte(field.getByte(object));
        }

        Format getSequenceKeyFormat() {
            return this;
        }
    }

    public static class FBool
    extends SimpleFormat {
        private static final long serialVersionUID = -7724949525068533451L;

        FBool(Catalog catalog, boolean bl) {
            super(catalog, bl ? Boolean.TYPE : Boolean.class, bl);
        }

        Object newArray(int n) {
            return new Boolean[n];
        }

        public Object newInstance(EntityInput entityInput, boolean bl) throws RefreshException {
            return entityInput.readBoolean();
        }

        void writeObject(Object object, EntityOutput entityOutput, boolean bl) {
            entityOutput.writeBoolean((Boolean)object);
        }

        void skipContents(RecordInput recordInput) {
            recordInput.skipFast(1);
        }

        void copySecKey(RecordInput recordInput, RecordOutput recordOutput) {
            recordOutput.writeFast(recordInput.readFast());
        }

        Object newPrimitiveArray(int n, EntityInput entityInput) throws RefreshException {
            boolean[] blArray = new boolean[n];
            for (int i = 0; i < n; ++i) {
                blArray[i] = entityInput.readBoolean();
            }
            return blArray;
        }

        void writePrimitiveArray(Object object, EntityOutput entityOutput) {
            boolean[] blArray = (boolean[])object;
            int n = blArray.length;
            entityOutput.writeArrayLength(n);
            for (int i = 0; i < n; ++i) {
                entityOutput.writeBoolean(blArray[i]);
            }
        }

        int getPrimitiveLength() {
            return 1;
        }

        void readPrimitiveField(Object object, EntityInput entityInput, Field field) throws IllegalAccessException, RefreshException {
            field.setBoolean(object, entityInput.readBoolean());
        }

        void writePrimitiveField(Object object, EntityOutput entityOutput, Field field) throws IllegalAccessException {
            entityOutput.writeBoolean(field.getBoolean(object));
        }
    }
}

