/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.util.keyrange;

import com.sleepycat.compat.DbCompat;
import com.sleepycat.db.Cursor;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.db.SecondaryCursor;
import com.sleepycat.util.keyrange.KeyRange;

public class RangeCursor
implements Cloneable {
    private Cursor cursor;
    private SecondaryCursor secCursor;
    private KeyRange range;
    private KeyRange pkRange;
    private boolean sortedDups;
    private DatabaseEntry privKey;
    private DatabaseEntry privPKey;
    private DatabaseEntry privData;
    private boolean initialized;

    public RangeCursor(KeyRange keyRange, KeyRange keyRange2, boolean bl, Cursor cursor) {
        if (keyRange2 != null && !keyRange.singleKey) {
            throw new IllegalArgumentException();
        }
        this.range = keyRange;
        this.pkRange = keyRange2;
        this.sortedDups = bl;
        this.cursor = cursor;
        this.init();
        if (keyRange2 != null && this.secCursor == null) {
            throw new IllegalArgumentException();
        }
    }

    public RangeCursor dup(boolean bl) throws DatabaseException {
        try {
            RangeCursor rangeCursor = (RangeCursor)super.clone();
            rangeCursor.cursor = this.dupCursor(this.cursor, bl);
            rangeCursor.init();
            return rangeCursor;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    private void init() {
        this.secCursor = this.cursor instanceof SecondaryCursor ? (SecondaryCursor)this.cursor : null;
        if (this.range.hasBound()) {
            this.privKey = new DatabaseEntry();
            this.privPKey = new DatabaseEntry();
            this.privData = new DatabaseEntry();
        } else {
            this.privKey = null;
            this.privPKey = null;
            this.privData = null;
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    private void setParams(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3) {
        this.privKey = databaseEntry;
        this.privPKey = databaseEntry2;
        this.privData = databaseEntry3;
    }

    private Cursor beginOperation() throws DatabaseException {
        Cursor cursor = this.cursor;
        if (this.initialized) {
            this.cursor = this.dupCursor(this.cursor, true);
            if (this.secCursor != null) {
                this.secCursor = (SecondaryCursor)this.cursor;
            }
        } else {
            return this.cursor;
        }
        return cursor;
    }

    private void endOperation(Cursor cursor, DbCompat.OpResult opResult, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3) throws DatabaseException {
        if (opResult.isSuccess()) {
            if (cursor != null && cursor != this.cursor) {
                this.closeCursor(cursor);
            }
            if (databaseEntry != null) {
                RangeCursor.swapData(databaseEntry, this.privKey);
            }
            if (databaseEntry2 != null && this.secCursor != null) {
                RangeCursor.swapData(databaseEntry2, this.privPKey);
            }
            if (databaseEntry3 != null) {
                RangeCursor.swapData(databaseEntry3, this.privData);
            }
            this.initialized = true;
        } else if (cursor != null && cursor != this.cursor) {
            this.closeCursor(this.cursor);
            this.cursor = cursor;
            if (this.secCursor != null) {
                this.secCursor = (SecondaryCursor)this.cursor;
            }
        }
    }

    private static void swapData(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) {
        byte[] byArray = databaseEntry.getData();
        int n = databaseEntry.getOffset();
        int n2 = databaseEntry.getSize();
        databaseEntry.setData(databaseEntry2.getData(), databaseEntry2.getOffset(), databaseEntry2.getSize());
        databaseEntry2.setData(byArray, n, n2);
    }

    private static void shareData(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) {
        if (databaseEntry != null) {
            databaseEntry2.setData(databaseEntry.getData(), databaseEntry.getOffset(), databaseEntry.getSize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DbCompat.OpResult getFirst(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, DbCompat.OpReadOptions opReadOptions) throws DatabaseException {
        DbCompat.OpResult opResult;
        if (!this.range.hasBound()) {
            this.setParams(databaseEntry, databaseEntry2, databaseEntry3);
            DbCompat.OpResult opResult2 = this.doGetFirst(opReadOptions);
            this.endOperation(null, opResult2, null, null, null);
            return opResult2;
        }
        if (this.pkRange != null && this.pkRange.isSingleKey()) {
            KeyRange.copy(this.range.beginKey, this.privKey);
            KeyRange.copy(this.pkRange.beginKey, this.privPKey);
            DbCompat.OpResult opResult3 = this.doGetSearchBoth(opReadOptions);
            this.endOperation(null, opResult3, databaseEntry, databaseEntry2, databaseEntry3);
            return opResult3;
        }
        if (this.pkRange != null) {
            KeyRange.copy(this.range.beginKey, this.privKey);
            opResult = DbCompat.OpResult.FAILURE;
            Cursor cursor = this.beginOperation();
            try {
                if (this.pkRange.beginKey == null || !this.sortedDups) {
                    opResult = this.doGetSearchKey(opReadOptions);
                } else {
                    KeyRange.copy(this.pkRange.beginKey, this.privPKey);
                    opResult = this.doGetSearchBothRange(opReadOptions);
                    if (opResult.isSuccess() && !this.pkRange.beginInclusive && this.pkRange.compare(this.privPKey, this.pkRange.beginKey) == 0) {
                        opResult = this.doGetNextDup(opReadOptions);
                    }
                }
                if (!opResult.isSuccess() || this.pkRange.check(this.privPKey)) return opResult;
                opResult = DbCompat.OpResult.FAILURE;
                return opResult;
            }
            finally {
                this.endOperation(cursor, opResult, databaseEntry, databaseEntry2, databaseEntry3);
            }
        }
        if (this.range.singleKey) {
            KeyRange.copy(this.range.beginKey, this.privKey);
            opResult = this.doGetSearchKey(opReadOptions);
            this.endOperation(null, opResult, databaseEntry, databaseEntry2, databaseEntry3);
            return opResult;
        }
        opResult = DbCompat.OpResult.FAILURE;
        Cursor cursor = this.beginOperation();
        try {
            if (this.range.beginKey == null) {
                opResult = this.doGetFirst(opReadOptions);
            } else {
                KeyRange.copy(this.range.beginKey, this.privKey);
                opResult = this.doGetSearchKeyRange(opReadOptions);
                if (opResult.isSuccess() && !this.range.beginInclusive && this.range.compare(this.privKey, this.range.beginKey) == 0) {
                    opResult = this.doGetNextNoDup(opReadOptions);
                }
            }
            if (!opResult.isSuccess() || this.range.check(this.privKey)) return opResult;
            opResult = DbCompat.OpResult.FAILURE;
            return opResult;
        }
        finally {
            this.endOperation(cursor, opResult, databaseEntry, databaseEntry2, databaseEntry3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbCompat.OpResult getLast(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, DbCompat.OpReadOptions opReadOptions) throws DatabaseException {
        DbCompat.OpResult opResult = DbCompat.OpResult.FAILURE;
        if (!this.range.hasBound()) {
            this.setParams(databaseEntry, databaseEntry2, databaseEntry3);
            opResult = this.doGetLast(opReadOptions);
            this.endOperation(null, opResult, null, null, null);
            return opResult;
        }
        Cursor cursor = this.beginOperation();
        try {
            if (this.pkRange != null) {
                opResult = this.getLastInPKeyRange(opReadOptions);
                if (!(!opResult.isSuccess() || this.range.check(this.privKey) && this.pkRange.check(this.privPKey))) {
                    opResult = DbCompat.OpResult.FAILURE;
                }
            } else {
                opResult = this.getLastInKeyRange(opReadOptions);
                if (opResult.isSuccess() && !this.range.check(this.privKey)) {
                    opResult = DbCompat.OpResult.FAILURE;
                }
            }
            DbCompat.OpResult opResult2 = opResult;
            return opResult2;
        }
        finally {
            this.endOperation(cursor, opResult, databaseEntry, databaseEntry2, databaseEntry3);
        }
    }

    private DbCompat.OpResult getLastInKeyRange(DbCompat.OpReadOptions opReadOptions) throws DatabaseException {
        DbCompat.OpResult opResult;
        if (this.range.endKey == null) {
            return this.doGetLast(opReadOptions);
        }
        do {
            KeyRange.copy(this.range.endKey, this.privKey);
            opResult = this.doGetSearchKeyRange(opReadOptions);
            if (opResult.isSuccess()) {
                if (this.range.endInclusive && this.range.compare(this.range.endKey, this.privKey) == 0) {
                    if (!this.sortedDups) {
                        return opResult;
                    }
                    opResult = this.doGetNextNoDup(opReadOptions);
                    opResult = opResult.isSuccess() ? this.doGetPrev(opReadOptions) : this.doGetLast(opReadOptions);
                } else {
                    opResult = this.doGetPrev(opReadOptions);
                }
            } else {
                opResult = this.doGetLast(opReadOptions);
            }
            if (opResult.isSuccess()) continue;
            return opResult;
        } while (!this.range.checkEnd(this.privKey, true));
        return opResult;
    }

    private DbCompat.OpResult getLastInPKeyRange(DbCompat.OpReadOptions opReadOptions) throws DatabaseException {
        DbCompat.OpResult opResult;
        if (this.pkRange.isSingleKey()) {
            KeyRange.copy(this.range.beginKey, this.privKey);
            KeyRange.copy(this.pkRange.beginKey, this.privPKey);
            return this.doGetSearchBoth(opReadOptions);
        }
        if (!this.sortedDups) {
            KeyRange.copy(this.range.beginKey, this.privKey);
            return this.doGetSearchKey(opReadOptions);
        }
        while (true) {
            if (this.pkRange.endKey != null) {
                KeyRange.copy(this.range.beginKey, this.privKey);
                KeyRange.copy(this.pkRange.endKey, this.privPKey);
                opResult = this.doGetSearchBothRange(opReadOptions);
                if (opResult.isSuccess()) {
                    if (!this.pkRange.endInclusive || this.pkRange.compare(this.pkRange.endKey, this.privPKey) != 0) {
                        opResult = this.doGetPrevDup(opReadOptions);
                        if (!opResult.isSuccess()) {
                            return opResult;
                        }
                        if (!this.pkRange.checkEnd(this.privPKey, true)) continue;
                    }
                    return opResult;
                }
            }
            KeyRange.copy(this.range.beginKey, this.privKey);
            opResult = this.doGetSearchKey(opReadOptions);
            if (!opResult.isSuccess()) {
                return opResult;
            }
            opResult = this.doGetNextNoDup(opReadOptions);
            opResult = opResult.isSuccess() ? this.doGetPrev(opReadOptions) : this.doGetLast(opReadOptions);
            if (!opResult.isSuccess()) {
                return opResult;
            }
            if (this.range.checkEnd(this.privKey, true)) break;
        }
        return opResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DbCompat.OpResult getNext(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, DbCompat.OpReadOptions opReadOptions) throws DatabaseException {
        DbCompat.OpResult opResult;
        if (!this.initialized) {
            return this.getFirst(databaseEntry, databaseEntry2, databaseEntry3, opReadOptions);
        }
        if (!this.range.hasBound()) {
            this.setParams(databaseEntry, databaseEntry2, databaseEntry3);
            DbCompat.OpResult opResult2 = this.doGetNext(opReadOptions);
            this.endOperation(null, opResult2, null, null, null);
            return opResult2;
        }
        if (this.pkRange != null) {
            if (this.pkRange.endKey == null) {
                opResult = this.doGetNextDup(opReadOptions);
                this.endOperation(null, opResult, databaseEntry, databaseEntry2, databaseEntry3);
                return opResult;
            } else {
                opResult = DbCompat.OpResult.FAILURE;
                Cursor cursor = this.beginOperation();
                try {
                    opResult = this.doGetNextDup(opReadOptions);
                    if (!opResult.isSuccess() || this.pkRange.checkEnd(this.privPKey, true)) return opResult;
                    opResult = DbCompat.OpResult.FAILURE;
                    return opResult;
                }
                finally {
                    this.endOperation(cursor, opResult, databaseEntry, databaseEntry2, databaseEntry3);
                }
            }
        }
        if (this.range.singleKey) {
            opResult = this.doGetNextDup(opReadOptions);
            this.endOperation(null, opResult, databaseEntry, databaseEntry2, databaseEntry3);
            return opResult;
        }
        opResult = DbCompat.OpResult.FAILURE;
        Cursor cursor = this.beginOperation();
        try {
            opResult = this.doGetNext(opReadOptions);
            if (!opResult.isSuccess() || this.range.check(this.privKey)) return opResult;
            opResult = DbCompat.OpResult.FAILURE;
            return opResult;
        }
        finally {
            this.endOperation(cursor, opResult, databaseEntry, databaseEntry2, databaseEntry3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbCompat.OpResult getNextNoDup(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, DbCompat.OpReadOptions opReadOptions) throws DatabaseException {
        DbCompat.OpResult opResult;
        if (!this.initialized) {
            return this.getFirst(databaseEntry, databaseEntry2, databaseEntry3, opReadOptions);
        }
        if (!this.range.hasBound()) {
            this.setParams(databaseEntry, databaseEntry2, databaseEntry3);
            DbCompat.OpResult opResult2 = this.doGetNextNoDup(opReadOptions);
            this.endOperation(null, opResult2, null, null, null);
            return opResult2;
        }
        if (this.range.singleKey) {
            opResult = DbCompat.OpResult.FAILURE;
        } else {
            opResult = DbCompat.OpResult.FAILURE;
            Cursor cursor = this.beginOperation();
            try {
                opResult = this.doGetNextNoDup(opReadOptions);
                if (opResult.isSuccess() && !this.range.check(this.privKey)) {
                    opResult = DbCompat.OpResult.FAILURE;
                }
            }
            finally {
                this.endOperation(cursor, opResult, databaseEntry, databaseEntry2, databaseEntry3);
            }
        }
        return opResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DbCompat.OpResult getPrev(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, DbCompat.OpReadOptions opReadOptions) throws DatabaseException {
        DbCompat.OpResult opResult;
        if (!this.initialized) {
            return this.getLast(databaseEntry, databaseEntry2, databaseEntry3, opReadOptions);
        }
        if (!this.range.hasBound()) {
            this.setParams(databaseEntry, databaseEntry2, databaseEntry3);
            DbCompat.OpResult opResult2 = this.doGetPrev(opReadOptions);
            this.endOperation(null, opResult2, null, null, null);
            return opResult2;
        }
        if (this.pkRange != null) {
            if (this.pkRange.beginKey == null) {
                opResult = this.doGetPrevDup(opReadOptions);
                this.endOperation(null, opResult, databaseEntry, databaseEntry2, databaseEntry3);
                return opResult;
            } else {
                opResult = DbCompat.OpResult.FAILURE;
                Cursor cursor = this.beginOperation();
                try {
                    opResult = this.doGetPrevDup(opReadOptions);
                    if (!opResult.isSuccess() || this.pkRange.checkBegin(this.privPKey, true)) return opResult;
                    opResult = DbCompat.OpResult.FAILURE;
                    return opResult;
                }
                finally {
                    this.endOperation(cursor, opResult, databaseEntry, databaseEntry2, databaseEntry3);
                }
            }
        }
        if (this.range.singleKey) {
            opResult = this.doGetPrevDup(opReadOptions);
            this.endOperation(null, opResult, databaseEntry, databaseEntry2, databaseEntry3);
            return opResult;
        }
        opResult = DbCompat.OpResult.FAILURE;
        Cursor cursor = this.beginOperation();
        try {
            opResult = this.doGetPrev(opReadOptions);
            if (!opResult.isSuccess() || this.range.check(this.privKey)) return opResult;
            opResult = DbCompat.OpResult.FAILURE;
            return opResult;
        }
        finally {
            this.endOperation(cursor, opResult, databaseEntry, databaseEntry2, databaseEntry3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbCompat.OpResult getPrevNoDup(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, DbCompat.OpReadOptions opReadOptions) throws DatabaseException {
        DbCompat.OpResult opResult;
        if (!this.initialized) {
            return this.getLast(databaseEntry, databaseEntry2, databaseEntry3, opReadOptions);
        }
        if (!this.range.hasBound()) {
            this.setParams(databaseEntry, databaseEntry2, databaseEntry3);
            DbCompat.OpResult opResult2 = this.doGetPrevNoDup(opReadOptions);
            this.endOperation(null, opResult2, null, null, null);
            return opResult2;
        }
        if (this.range.singleKey) {
            opResult = DbCompat.OpResult.FAILURE;
        } else {
            opResult = DbCompat.OpResult.FAILURE;
            Cursor cursor = this.beginOperation();
            try {
                opResult = this.doGetPrevNoDup(opReadOptions);
                if (opResult.isSuccess() && !this.range.check(this.privKey)) {
                    opResult = DbCompat.OpResult.FAILURE;
                }
            }
            finally {
                this.endOperation(cursor, opResult, databaseEntry, databaseEntry2, databaseEntry3);
            }
        }
        return opResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DbCompat.OpResult getSearchKey(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, DbCompat.OpReadOptions opReadOptions) throws DatabaseException {
        DbCompat.OpResult opResult;
        if (!this.range.hasBound()) {
            this.setParams(databaseEntry, databaseEntry2, databaseEntry3);
            DbCompat.OpResult opResult2 = this.doGetSearchKey(opReadOptions);
            this.endOperation(null, opResult2, null, null, null);
            return opResult2;
        }
        if (!this.range.check(databaseEntry)) {
            return DbCompat.OpResult.FAILURE;
        }
        if (this.pkRange != null) {
            opResult = DbCompat.OpResult.FAILURE;
            Cursor cursor = this.beginOperation();
            try {
                RangeCursor.shareData(databaseEntry, this.privKey);
                opResult = this.doGetSearchKey(opReadOptions);
                if (!opResult.isSuccess()) return opResult;
                if (this.pkRange.check(this.privPKey)) return opResult;
                opResult = DbCompat.OpResult.FAILURE;
                return opResult;
            }
            finally {
                this.endOperation(cursor, opResult, databaseEntry, databaseEntry2, databaseEntry3);
            }
        } else {
            RangeCursor.shareData(databaseEntry, this.privKey);
            opResult = this.doGetSearchKey(opReadOptions);
            this.endOperation(null, opResult, databaseEntry, databaseEntry2, databaseEntry3);
        }
        return opResult;
    }

    public DbCompat.OpResult getSearchBoth(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, DbCompat.OpReadOptions opReadOptions) throws DatabaseException {
        DbCompat.OpResult opResult;
        if (!this.range.hasBound()) {
            this.setParams(databaseEntry, databaseEntry2, databaseEntry3);
            DbCompat.OpResult opResult2 = this.doGetSearchBoth(opReadOptions);
            this.endOperation(null, opResult2, null, null, null);
            return opResult2;
        }
        if (!this.range.check(databaseEntry) || this.pkRange != null && !this.pkRange.check(databaseEntry2)) {
            opResult = DbCompat.OpResult.FAILURE;
        } else {
            RangeCursor.shareData(databaseEntry, this.privKey);
            if (this.secCursor != null) {
                RangeCursor.shareData(databaseEntry2, this.privPKey);
            } else {
                RangeCursor.shareData(databaseEntry3, this.privData);
            }
            opResult = this.doGetSearchBoth(opReadOptions);
            this.endOperation(null, opResult, databaseEntry, databaseEntry2, databaseEntry3);
        }
        return opResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbCompat.OpResult getSearchKeyRange(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, DbCompat.OpReadOptions opReadOptions) throws DatabaseException {
        DbCompat.OpResult opResult = DbCompat.OpResult.FAILURE;
        if (!this.range.hasBound()) {
            this.setParams(databaseEntry, databaseEntry2, databaseEntry3);
            opResult = this.doGetSearchKeyRange(opReadOptions);
            this.endOperation(null, opResult, null, null, null);
            return opResult;
        }
        Cursor cursor = this.beginOperation();
        try {
            RangeCursor.shareData(databaseEntry, this.privKey);
            opResult = this.doGetSearchKeyRange(opReadOptions);
            if (opResult.isSuccess() && (!this.range.check(this.privKey) || this.pkRange != null && !this.pkRange.check(databaseEntry2))) {
                opResult = DbCompat.OpResult.FAILURE;
            }
        }
        finally {
            this.endOperation(cursor, opResult, databaseEntry, databaseEntry2, databaseEntry3);
        }
        return opResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbCompat.OpResult getSearchBothRange(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, DbCompat.OpReadOptions opReadOptions) throws DatabaseException {
        DbCompat.OpResult opResult = DbCompat.OpResult.FAILURE;
        if (!this.range.hasBound()) {
            this.setParams(databaseEntry, databaseEntry2, databaseEntry3);
            opResult = this.doGetSearchBothRange(opReadOptions);
            this.endOperation(null, opResult, null, null, null);
            return opResult;
        }
        Cursor cursor = this.beginOperation();
        try {
            RangeCursor.shareData(databaseEntry, this.privKey);
            if (this.secCursor != null) {
                RangeCursor.shareData(databaseEntry2, this.privPKey);
            } else {
                RangeCursor.shareData(databaseEntry3, this.privData);
            }
            opResult = this.doGetSearchBothRange(opReadOptions);
            if (opResult.isSuccess() && (!this.range.check(this.privKey) || this.pkRange != null && !this.pkRange.check(databaseEntry2))) {
                opResult = DbCompat.OpResult.FAILURE;
            }
        }
        finally {
            this.endOperation(cursor, opResult, databaseEntry, databaseEntry2, databaseEntry3);
        }
        return opResult;
    }

    public DbCompat.OpResult getSearchRecordNumber(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, DbCompat.OpReadOptions opReadOptions) throws DatabaseException {
        DbCompat.OpResult opResult;
        if (!this.range.hasBound()) {
            this.setParams(databaseEntry, databaseEntry2, databaseEntry3);
            DbCompat.OpResult opResult2 = this.doGetSearchRecordNumber(opReadOptions);
            this.endOperation(null, opResult2, null, null, null);
            return opResult2;
        }
        if (!this.range.check(databaseEntry)) {
            opResult = DbCompat.OpResult.FAILURE;
        } else {
            RangeCursor.shareData(databaseEntry, this.privKey);
            opResult = this.doGetSearchRecordNumber(opReadOptions);
            this.endOperation(null, opResult, databaseEntry, databaseEntry2, databaseEntry3);
        }
        return opResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DbCompat.OpResult getNextDup(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, DbCompat.OpReadOptions opReadOptions) throws DatabaseException {
        DbCompat.OpResult opResult;
        if (!this.initialized) {
            throw new IllegalStateException("Cursor not initialized");
        }
        if (!this.range.hasBound()) {
            this.setParams(databaseEntry, databaseEntry2, databaseEntry3);
            opResult = this.doGetNextDup(opReadOptions);
            this.endOperation(null, opResult, null, null, null);
            return opResult;
        } else if (this.pkRange != null && this.pkRange.endKey != null) {
            opResult = DbCompat.OpResult.FAILURE;
            Cursor cursor = this.beginOperation();
            try {
                opResult = this.doGetNextDup(opReadOptions);
                if (!opResult.isSuccess() || this.pkRange.checkEnd(this.privPKey, true)) return opResult;
                opResult = DbCompat.OpResult.FAILURE;
                return opResult;
            }
            finally {
                this.endOperation(cursor, opResult, databaseEntry, databaseEntry2, databaseEntry3);
            }
        } else {
            opResult = this.doGetNextDup(opReadOptions);
            this.endOperation(null, opResult, databaseEntry, databaseEntry2, databaseEntry3);
        }
        return opResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DbCompat.OpResult getPrevDup(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, DbCompat.OpReadOptions opReadOptions) throws DatabaseException {
        DbCompat.OpResult opResult;
        if (!this.initialized) {
            throw new IllegalStateException("Cursor not initialized");
        }
        if (!this.range.hasBound()) {
            this.setParams(databaseEntry, databaseEntry2, databaseEntry3);
            opResult = this.doGetPrevDup(opReadOptions);
            this.endOperation(null, opResult, null, null, null);
            return opResult;
        } else if (this.pkRange != null && this.pkRange.beginKey != null) {
            opResult = DbCompat.OpResult.FAILURE;
            Cursor cursor = this.beginOperation();
            try {
                opResult = this.doGetPrevDup(opReadOptions);
                if (!opResult.isSuccess() || this.pkRange.checkBegin(this.privPKey, true)) return opResult;
                opResult = DbCompat.OpResult.FAILURE;
                return opResult;
            }
            finally {
                this.endOperation(cursor, opResult, databaseEntry, databaseEntry2, databaseEntry3);
            }
        } else {
            opResult = this.doGetPrevDup(opReadOptions);
            this.endOperation(null, opResult, databaseEntry, databaseEntry2, databaseEntry3);
        }
        return opResult;
    }

    public DbCompat.OpResult getCurrent(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, DbCompat.OpReadOptions opReadOptions) throws DatabaseException {
        if (!this.initialized) {
            throw new IllegalStateException("Cursor not initialized");
        }
        if (this.secCursor != null && databaseEntry2 != null) {
            return DbCompat.OpResult.make(this.secCursor.getCurrent(databaseEntry, databaseEntry2, databaseEntry3, opReadOptions.getLockMode()));
        }
        return DbCompat.OpResult.make(this.cursor.getCurrent(databaseEntry, databaseEntry3, opReadOptions.getLockMode()));
    }

    public void close() throws DatabaseException {
        this.closeCursor(this.cursor);
    }

    public int count() throws DatabaseException {
        return this.cursor.count();
    }

    public OperationStatus delete() throws DatabaseException {
        return this.cursor.delete();
    }

    public OperationStatus put(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws DatabaseException {
        return this.cursor.put(databaseEntry, databaseEntry2);
    }

    public OperationStatus putNoOverwrite(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws DatabaseException {
        return this.cursor.putNoOverwrite(databaseEntry, databaseEntry2);
    }

    public OperationStatus putNoDupData(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws DatabaseException {
        return this.cursor.putNoDupData(databaseEntry, databaseEntry2);
    }

    public OperationStatus putCurrent(DatabaseEntry databaseEntry) throws DatabaseException {
        return this.cursor.putCurrent(databaseEntry);
    }

    public OperationStatus putAfter(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws DatabaseException {
        return DbCompat.putAfter(this.cursor, databaseEntry, databaseEntry2);
    }

    public OperationStatus putBefore(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws DatabaseException {
        return DbCompat.putBefore(this.cursor, databaseEntry, databaseEntry2);
    }

    private DbCompat.OpResult doGetFirst(DbCompat.OpReadOptions opReadOptions) throws DatabaseException {
        if (this.secCursor != null && this.privPKey != null) {
            return DbCompat.OpResult.make(this.secCursor.getFirst(this.privKey, this.privPKey, this.privData, opReadOptions.getLockMode()));
        }
        return DbCompat.OpResult.make(this.cursor.getFirst(this.privKey, this.privData, opReadOptions.getLockMode()));
    }

    private DbCompat.OpResult doGetLast(DbCompat.OpReadOptions opReadOptions) throws DatabaseException {
        if (this.secCursor != null && this.privPKey != null) {
            return DbCompat.OpResult.make(this.secCursor.getLast(this.privKey, this.privPKey, this.privData, opReadOptions.getLockMode()));
        }
        return DbCompat.OpResult.make(this.cursor.getLast(this.privKey, this.privData, opReadOptions.getLockMode()));
    }

    private DbCompat.OpResult doGetNext(DbCompat.OpReadOptions opReadOptions) throws DatabaseException {
        if (this.secCursor != null && this.privPKey != null) {
            return DbCompat.OpResult.make(this.secCursor.getNext(this.privKey, this.privPKey, this.privData, opReadOptions.getLockMode()));
        }
        return DbCompat.OpResult.make(this.cursor.getNext(this.privKey, this.privData, opReadOptions.getLockMode()));
    }

    private DbCompat.OpResult doGetNextDup(DbCompat.OpReadOptions opReadOptions) throws DatabaseException {
        if (this.secCursor != null && this.privPKey != null) {
            return DbCompat.OpResult.make(this.secCursor.getNextDup(this.privKey, this.privPKey, this.privData, opReadOptions.getLockMode()));
        }
        return DbCompat.OpResult.make(this.cursor.getNextDup(this.privKey, this.privData, opReadOptions.getLockMode()));
    }

    private DbCompat.OpResult doGetNextNoDup(DbCompat.OpReadOptions opReadOptions) throws DatabaseException {
        if (this.secCursor != null && this.privPKey != null) {
            return DbCompat.OpResult.make(this.secCursor.getNextNoDup(this.privKey, this.privPKey, this.privData, opReadOptions.getLockMode()));
        }
        return DbCompat.OpResult.make(this.cursor.getNextNoDup(this.privKey, this.privData, opReadOptions.getLockMode()));
    }

    private DbCompat.OpResult doGetPrev(DbCompat.OpReadOptions opReadOptions) throws DatabaseException {
        if (this.secCursor != null && this.privPKey != null) {
            return DbCompat.OpResult.make(this.secCursor.getPrev(this.privKey, this.privPKey, this.privData, opReadOptions.getLockMode()));
        }
        return DbCompat.OpResult.make(this.cursor.getPrev(this.privKey, this.privData, opReadOptions.getLockMode()));
    }

    private DbCompat.OpResult doGetPrevDup(DbCompat.OpReadOptions opReadOptions) throws DatabaseException {
        if (this.secCursor != null && this.privPKey != null) {
            return DbCompat.OpResult.make(this.secCursor.getPrevDup(this.privKey, this.privPKey, this.privData, opReadOptions.getLockMode()));
        }
        return DbCompat.OpResult.make(this.cursor.getPrevDup(this.privKey, this.privData, opReadOptions.getLockMode()));
    }

    private DbCompat.OpResult doGetPrevNoDup(DbCompat.OpReadOptions opReadOptions) throws DatabaseException {
        if (this.secCursor != null && this.privPKey != null) {
            return DbCompat.OpResult.make(this.secCursor.getPrevNoDup(this.privKey, this.privPKey, this.privData, opReadOptions.getLockMode()));
        }
        return DbCompat.OpResult.make(this.cursor.getPrevNoDup(this.privKey, this.privData, opReadOptions.getLockMode()));
    }

    private DbCompat.OpResult doGetSearchKey(DbCompat.OpReadOptions opReadOptions) throws DatabaseException {
        if (this.checkRecordNumber() && DbCompat.getRecordNumber(this.privKey) <= 0) {
            return DbCompat.OpResult.FAILURE;
        }
        if (this.secCursor != null && this.privPKey != null) {
            return DbCompat.OpResult.make(this.secCursor.getSearchKey(this.privKey, this.privPKey, this.privData, opReadOptions.getLockMode()));
        }
        return DbCompat.OpResult.make(this.cursor.getSearchKey(this.privKey, this.privData, opReadOptions.getLockMode()));
    }

    private DbCompat.OpResult doGetSearchKeyRange(DbCompat.OpReadOptions opReadOptions) throws DatabaseException {
        if (this.checkRecordNumber() && DbCompat.getRecordNumber(this.privKey) <= 0) {
            return DbCompat.OpResult.FAILURE;
        }
        if (this.secCursor != null && this.privPKey != null) {
            return DbCompat.OpResult.make(this.secCursor.getSearchKeyRange(this.privKey, this.privPKey, this.privData, opReadOptions.getLockMode()));
        }
        return DbCompat.OpResult.make(this.cursor.getSearchKeyRange(this.privKey, this.privData, opReadOptions.getLockMode()));
    }

    private DbCompat.OpResult doGetSearchBoth(DbCompat.OpReadOptions opReadOptions) throws DatabaseException {
        if (this.checkRecordNumber() && DbCompat.getRecordNumber(this.privKey) <= 0) {
            return DbCompat.OpResult.FAILURE;
        }
        if (this.secCursor != null && this.privPKey != null) {
            return DbCompat.OpResult.make(this.secCursor.getSearchBoth(this.privKey, this.privPKey, this.privData, opReadOptions.getLockMode()));
        }
        return DbCompat.OpResult.make(this.cursor.getSearchBoth(this.privKey, this.privData, opReadOptions.getLockMode()));
    }

    private DbCompat.OpResult doGetSearchBothRange(DbCompat.OpReadOptions opReadOptions) throws DatabaseException {
        if (this.checkRecordNumber() && DbCompat.getRecordNumber(this.privKey) <= 0) {
            return DbCompat.OpResult.FAILURE;
        }
        if (this.secCursor != null && this.privPKey != null) {
            return DbCompat.OpResult.make(this.secCursor.getSearchBothRange(this.privKey, this.privPKey, this.privData, opReadOptions.getLockMode()));
        }
        return DbCompat.OpResult.make(this.cursor.getSearchBothRange(this.privKey, this.privData, opReadOptions.getLockMode()));
    }

    private DbCompat.OpResult doGetSearchRecordNumber(DbCompat.OpReadOptions opReadOptions) throws DatabaseException {
        if (DbCompat.getRecordNumber(this.privKey) <= 0) {
            return DbCompat.OpResult.FAILURE;
        }
        if (this.secCursor != null && this.privPKey != null) {
            return DbCompat.OpResult.make(DbCompat.getSearchRecordNumber(this.secCursor, this.privKey, this.privPKey, this.privData, opReadOptions.getLockMode()));
        }
        return DbCompat.OpResult.make(DbCompat.getSearchRecordNumber(this.cursor, this.privKey, this.privData, opReadOptions.getLockMode()));
    }

    protected Cursor dupCursor(Cursor cursor, boolean bl) throws DatabaseException {
        return cursor.dup(bl);
    }

    protected void closeCursor(Cursor cursor) throws DatabaseException {
        cursor.close();
    }

    protected boolean checkRecordNumber() {
        return false;
    }
}

