/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.data;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Calendar;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.utils.BeanUtils;

public class OracleTimestampConverter {
    private static final String TO_TIMESTAMP_METHOD_NAME = "timestampValue";

    private OracleTimestampConverter() {
    }

    public static Timestamp toTimestamp(@NotNull Object object, @NotNull Connection connection) throws Exception {
        Class<?> aClass = object.getClass();
        return switch (aClass.getName()) {
            case "oracle.sql.TIMESTAMP" -> (Timestamp)OracleTimestampConverter.invokeNativeMethod(object, TO_TIMESTAMP_METHOD_NAME, null, null);
            case "oracle.sql.TIMESTAMPTZ" -> (Timestamp)OracleTimestampConverter.invokeNativeMethod(object, TO_TIMESTAMP_METHOD_NAME, new Class[]{Connection.class}, new Object[]{connection});
            case "oracle.sql.TIMESTAMPLTZ" -> (Timestamp)OracleTimestampConverter.invokeNativeMethod(object, TO_TIMESTAMP_METHOD_NAME, new Class[]{Connection.class, Calendar.class}, new Object[]{connection, Calendar.getInstance()});
            default -> throw new DBException("Unsupported Oracle TIMESTAMP type: " + aClass.getName());
        };
    }

    private static Object invokeNativeMethod(Object object, String name, Class<?>[] classes, Object[] args) throws Exception {
        try {
            return BeanUtils.invokeObjectMethod((Object)object, (String)name, (Class[])classes, (Object[])args);
        }
        catch (Throwable e) {
            throw new DBException("Cannot invoke method " + name + " on " + String.valueOf(object.getClass()), e);
        }
    }
}

