/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.snowflake.model;

import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericExecutionContext;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionBootstrap;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCCachedContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

class SnowflakeExecutionContext
extends GenericExecutionContext {
    private static final Log log = Log.getLog(SnowflakeExecutionContext.class);
    @Nullable
    private String activeDatabaseName;
    @Nullable
    private String activeSchemaName;

    SnowflakeExecutionContext(JDBCRemoteInstance instance, String purpose) {
        super(instance, purpose);
    }

    @Nullable
    public GenericCatalog getDefaultCatalog() {
        if (CommonUtils.isEmpty((String)this.activeDatabaseName)) {
            return null;
        }
        return this.getDataSource().getCatalog(this.activeDatabaseName);
    }

    @Nullable
    public GenericSchema getDefaultSchema() {
        if (CommonUtils.isEmpty((String)this.activeSchemaName)) {
            return null;
        }
        GenericCatalog defaultCatalog = this.getDefaultCatalog();
        if (defaultCatalog == null) {
            return null;
        }
        try {
            return defaultCatalog.getSchema((DBRProgressMonitor)new VoidProgressMonitor(), this.activeSchemaName);
        }
        catch (DBException e) {
            log.error((Object)"Unable to retrieve active schema by its name", (Throwable)e);
            return null;
        }
    }

    public boolean supportsCatalogChange() {
        return true;
    }

    public boolean supportsSchemaChange() {
        return true;
    }

    public void setDefaultCatalog(DBRProgressMonitor monitor, @NotNull GenericCatalog catalog, @Nullable GenericSchema schema) throws DBCException {
        this.setDefaultCatalog(monitor, catalog, (DBSObject)schema, false);
    }

    void setDefaultCatalog(DBRProgressMonitor monitor, @NotNull GenericCatalog catalog, @Nullable DBSObject schema, boolean force) throws DBCException {
        String catalogName = catalog.getName();
        if (!force && catalogName.equals(this.activeDatabaseName) && (schema == null || schema.getName().equals(this.activeSchemaName))) {
            return;
        }
        GenericCatalog oldActiveDatabase = this.getDefaultCatalog();
        this.setActiveDatabase(monitor, catalogName);
        try {
            catalog.getSchemas(monitor);
        }
        catch (DBException e) {
            log.debug((Object)"Error caching database schemas", (Throwable)e);
        }
        this.activeDatabaseName = catalogName;
        DBUtils.fireObjectSelectionChange((DBSObject)oldActiveDatabase, (DBSObject)catalog, (DBCExecutionContext)this);
        if (schema != null) {
            this.setDefaultSchema(monitor, schema, force);
        }
    }

    public void setDefaultSchema(DBRProgressMonitor monitor, @NotNull GenericSchema newActiveSchema) throws DBCException {
        this.setDefaultSchema(monitor, (DBSObject)newActiveSchema, false);
    }

    void setDefaultSchema(DBRProgressMonitor monitor, @NotNull DBSObject newActiveSchema, boolean force) throws DBCException {
        String newSchemaName = newActiveSchema.getName();
        if (!force && newSchemaName.equals(this.activeSchemaName)) {
            return;
        }
        this.setActiveSchema(monitor, newSchemaName);
        GenericSchema oldActiveSchema = this.getDefaultSchema();
        this.activeSchemaName = newSchemaName;
        DBUtils.fireObjectSelectionChange((DBSObject)oldActiveSchema, (DBSObject)newActiveSchema, (DBCExecutionContext)this);
    }

    public boolean refreshDefaults(DBRProgressMonitor monitor, boolean useBootstrapSettings) throws DBException {
        boolean isRefreshed = false;
        String currentDatabase = null;
        String currentSchema = null;
        Throwable throwable = null;
        Object var7_8 = null;
        try (JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.META, "Query active database and schema");){
            try {
                Throwable throwable2 = null;
                Object var10_14 = null;
                try (JDBCStatement dbStat = session.createStatement();){
                    Throwable throwable3 = null;
                    Object var13_19 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery("SELECT CURRENT_DATABASE(), CURRENT_SCHEMA()");){
                        if (dbResult != null) {
                            dbResult.next();
                            currentDatabase = dbResult.getString(1);
                            currentSchema = dbResult.getString(2);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (SQLException e) {
                log.debug((Object)"Exception caught when refreshing defaults for Snowflake execution context", (Throwable)e);
                throw new DBException("Unable to refresh defaults for Snowflake execution context", (Throwable)e);
            }
            if (useBootstrapSettings) {
                DBPConnectionBootstrap bootstrap = this.getBootstrapSettings();
                DBPConnectionConfiguration connectionConfiguration = this.getDataSource().getContainer().getConnectionConfiguration();
                if (!CommonUtils.isEmpty((String)bootstrap.getDefaultCatalogName()) && CommonUtils.isEmpty((String)connectionConfiguration.getProviderProperty("@dbeaver-schema@"))) {
                    this.setActiveDatabase(monitor, bootstrap.getDefaultCatalogName());
                    currentDatabase = bootstrap.getDefaultCatalogName();
                }
                if (!CommonUtils.isEmpty((String)bootstrap.getDefaultSchemaName()) && CommonUtils.isEmpty((String)connectionConfiguration.getDatabaseName())) {
                    this.setActiveSchema(monitor, bootstrap.getDefaultSchemaName());
                    currentSchema = bootstrap.getDefaultSchemaName();
                }
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
        if (!CommonUtils.isEmpty((String)currentDatabase) && !CommonUtils.equalObjects((Object)currentDatabase, (Object)this.activeDatabaseName)) {
            this.activeDatabaseName = currentDatabase;
            isRefreshed = true;
        }
        if (!CommonUtils.isEmpty((String)currentSchema) && !CommonUtils.equalObjects((Object)currentSchema, (Object)this.activeSchemaName)) {
            this.activeSchemaName = currentSchema;
            isRefreshed = true;
        }
        if (CommonUtils.isEmpty((String)currentSchema)) {
            this.activeSchemaName = "PUBLIC";
            isRefreshed = true;
        }
        return isRefreshed;
    }

    private void setActiveDatabase(DBRProgressMonitor monitor, @NotNull String databaseName) throws DBCException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.UTIL, "Set active database");){
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (JDBCStatement dbStat = session.createStatement();){
                    dbStat.executeUpdate("USE DATABASE " + DBUtils.getQuotedIdentifier((DBPDataSource)this.getDataSource(), (String)databaseName));
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            log.error((Object)("Unable to set active database due to unexpected SQLException. databaseName=" + databaseName));
            throw new DBCException((Throwable)e, (DBCExecutionContext)this);
        }
    }

    private void setActiveSchema(DBRProgressMonitor monitor, @NotNull String schemaName) throws DBCException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.UTIL, "Set active schema");){
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (JDBCStatement dbStat = session.createStatement();){
                    dbStat.executeUpdate("USE SCHEMA " + DBUtils.getQuotedIdentifier((DBPDataSource)this.getDataSource(), (String)schemaName));
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            log.error((Object)("Unable to set active schema due to unexpected SQLException. schemaName=" + schemaName));
            throw new DBCException((Throwable)e, (DBCExecutionContext)this);
        }
    }

    @NotNull
    public DBCCachedContextDefaults getCachedDefault() {
        return new DBCCachedContextDefaults(this.activeDatabaseName, this.activeSchemaName);
    }
}

