/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.vertica.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.vertica.VerticaUtils;
import org.jkiss.dbeaver.ext.vertica.model.VerticaDataSource;
import org.jkiss.dbeaver.ext.vertica.model.VerticaSchema;
import org.jkiss.dbeaver.model.DBPObjectStatistics;
import org.jkiss.dbeaver.model.DBPObjectWithLazyDescription;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.IPropertyCacheValidator;
import org.jkiss.dbeaver.model.meta.LazyProperty;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class VerticaTable
extends GenericTable
implements DBPObjectStatistics,
DBPSystemObject,
DBPObjectWithLazyDescription {
    private long tableSize = -1L;
    private String partitionExpression;
    private Date createTime;
    private boolean isTempTable;
    private boolean isSystemTable;
    private boolean hasAggregateProjection;
    private String description;

    public VerticaTable(VerticaSchema container, String tableName, String tableType, JDBCResultSet dbResult) {
        super((GenericStructContainer)container, tableName, tableType, dbResult);
        if (dbResult != null) {
            this.partitionExpression = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"partition_expression");
            this.createTime = JDBCUtils.safeGetDate((ResultSet)dbResult, (String)"create_time");
            this.isTempTable = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"is_temp_table");
            this.isSystemTable = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"is_system_table");
            this.hasAggregateProjection = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"has_aggregate_projection");
        }
    }

    @Property(viewable=true, order=5)
    public String getPartitionExpression() {
        return this.partitionExpression;
    }

    @Property(viewable=true, order=6)
    public Date getCreateTime() {
        return this.createTime;
    }

    @Property(viewable=true, order=7)
    public boolean isTempTable() {
        return this.isTempTable;
    }

    public boolean isSystem() {
        return this.isSystemTable;
    }

    @Property(viewable=true, order=8)
    public boolean isHasAggregateProjection() {
        return this.hasAggregateProjection;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Property(viewable=true, editable=true, updatable=true, length=PropertyLength.MULTILINE, order=100)
    @LazyProperty(cacheValidator=CommentsValidator.class)
    @Nullable
    public String getDescription(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.description == null) {
            if (!((VerticaDataSource)this.getDataSource()).avoidCommentsReading()) {
                VerticaUtils.readTableAndColumnsDescriptions(monitor, (GenericDataSource)this.getDataSource(), (GenericTableBase)this, false);
            }
            if (this.description == null) {
                this.description = "";
            }
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isPhysicalTable() {
        return !this.isView();
    }

    public boolean hasStatistics() {
        return this.tableSize != -1L;
    }

    public long getStatObjectSize() {
        return this.tableSize;
    }

    void fetchStatistics(JDBCResultSet dbResult) throws SQLException {
        this.tableSize = dbResult.getLong("used_bytes");
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.tableSize != -1L) {
            this.tableSize = -1L;
            ((VerticaSchema)this.getSchema()).resetStatistics();
        }
        return super.refreshObject(monitor);
    }

    @Nullable
    public DBPPropertySource getStatProperties() {
        return null;
    }

    public static class CommentsValidator
    implements IPropertyCacheValidator<VerticaTable> {
        public boolean isPropertyCached(@NotNull VerticaTable object, @NotNull Object propertyId) {
            return object.description != null;
        }
    }
}

