/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.editors.DB2ObjectType;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.DB2Object;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.model.DB2ViewBase;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2TableDepType;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class DB2ViewBaseDep
extends DB2Object<DB2ViewBase> {
    private DB2TableDepType tableDepType;
    private DB2Schema depSchema;
    private String depModuleId;
    private String tabAuth;
    private DBSObject depObject;

    public DB2ViewBaseDep(DBRProgressMonitor monitor, DB2ViewBase db2ViewBase, ResultSet resultSet) throws DBException {
        super(db2ViewBase, JDBCUtils.safeGetString((ResultSet)resultSet, (String)"BNAME"), true);
        DB2ObjectType db2ObjectType;
        DB2DataSource db2DataSource = (DB2DataSource)db2ViewBase.getDataSource();
        this.tabAuth = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"TABAUTH");
        this.tableDepType = (DB2TableDepType)CommonUtils.valueOf(DB2TableDepType.class, (String)JDBCUtils.safeGetString((ResultSet)resultSet, (String)"BTYPE"));
        String depSchemaName = JDBCUtils.safeGetStringTrimmed((ResultSet)resultSet, (String)"BSCHEMA");
        if (db2DataSource.isAtLeastV9_5()) {
            this.depModuleId = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"BMODULEID");
        }
        if ((db2ObjectType = this.tableDepType.getDb2ObjectType()) != null) {
            this.depSchema = this.getDataSource().getSchema(monitor, depSchemaName);
            this.depObject = db2ObjectType.findObject(monitor, this.depSchema, this.getName());
        }
    }

    @Override
    @Property(viewable=true, editable=false, id="Name", order=1)
    @NotNull
    public String getName() {
        return super.getName();
    }

    @Property(viewable=true, editable=false, order=2)
    public DB2TableDepType getTableDepType() {
        return this.tableDepType;
    }

    @Property(viewable=true, editable=false, order=3)
    public DB2Schema getDepSchema() {
        return this.depSchema;
    }

    @Property(viewable=true, editable=false, order=4)
    public DBSObject getDepObject() {
        return this.depObject;
    }

    @Property(viewable=true, editable=false)
    public String getDepModuleId() {
        return this.depModuleId;
    }

    @Property(viewable=true, editable=false)
    public String getTabAuth() {
        return this.tabAuth;
    }
}

