/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.hsqldb.model;

import java.sql.ResultSet;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableTrigger;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.sql.format.SQLFormatUtils;
import org.jkiss.utils.CommonUtils;

public class HSQLTrigger
extends GenericTableTrigger {
    private String manipulation;
    private String orientation;
    private String timing;
    private String statement;

    HSQLTrigger(GenericTableBase table, String name, JDBCResultSet dbResult) {
        super(table, name, null);
        this.manipulation = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"EVENT_MANIPULATION");
        this.orientation = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ACTION_ORIENTATION");
        this.timing = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ACTION_TIMING");
        this.statement = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ACTION_STATEMENT");
        String newReference = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ACTION_REFERENCE_NEW_ROW");
        if (CommonUtils.isEmpty((String)newReference)) {
            newReference = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ACTION_REFERENCE_NEW_TABLE");
        }
        String oldReference = null;
        if (CommonUtils.isEmpty((String)newReference) && CommonUtils.isEmpty((String)(oldReference = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ACTION_REFERENCE_OLD_ROW")))) {
            oldReference = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ACTION_REFERENCE_OLD_TABLE");
        }
        if (this.statement != null) {
            this.statement = "CREATE TRIGGER " + name + " " + this.timing + " " + this.manipulation + " ON " + DBUtils.getObjectFullName((DBPNamedObject)table, (DBPEvaluationContext)DBPEvaluationContext.DML) + (String)(newReference != null ? "\nREFERENCING NEW AS " + newReference : (oldReference != null ? "\nREFERENCING OLD AS " + oldReference : "")) + " FOR EACH " + this.orientation + "\n" + SQLFormatUtils.formatSQL((DBPDataSource)this.getDataSource(), (String)this.statement);
        }
    }

    @Property(viewable=true, order=11)
    public String getManipulation() {
        return this.manipulation;
    }

    @Property(viewable=true, order=12)
    public String getOrientation() {
        return this.orientation;
    }

    @Property(viewable=true, order=10)
    public String getTiming() {
        return this.timing;
    }

    public String getStatement() {
        return this.statement;
    }

    @Nullable
    public String getDescription() {
        return super.getDescription();
    }
}

